/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.actions.CommonEditActionsProvider;
import com.intellij.designer.actions.DeselectAllAction;
import com.intellij.designer.actions.MorphingAction;
import com.intellij.designer.actions.SelectAllAction;
import com.intellij.designer.actions.SelectSameTypeAction;
import com.intellij.designer.actions.SelectSiblingsAction;
import com.intellij.designer.actions.StartInplaceEditing;
import com.intellij.designer.actions.WrapInAction;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DesignerActionPanel
implements DataProvider {
    public static final String TOOLBAR = "DesignerToolbar";
    private final DefaultActionGroup a;
    private final DefaultActionGroup g = new DefaultActionGroup();
    private final DefaultActionGroup b = new DefaultActionGroup();
    private final DefaultActionGroup f = new DefaultActionGroup();
    private final DefaultActionGroup e = new DefaultActionGroup();
    protected final JComponent myToolbar;
    protected final DesignerEditorPanel myDesigner;
    private final CommonEditActionsProvider c;
    private final JComponent d;

    public DesignerActionPanel(DesignerEditorPanel designerEditorPanel, JComponent jComponent) {
        this.myDesigner = designerEditorPanel;
        this.c = new CommonEditActionsProvider(designerEditorPanel);
        this.d = jComponent;
        DesignerActionPanel.createInplaceEditingAction(this.d).setDesignerPanel(designerEditorPanel);
        this.a = this.createActionGroup();
        this.myToolbar = this.createToolbar();
        ActionManager actionManager = ActionManager.getInstance();
        this.f.add(actionManager.getAction("$Cut"));
        this.f.add(actionManager.getAction("$Copy"));
        this.f.add(actionManager.getAction("$Paste"));
        this.f.addSeparator();
        this.f.add(actionManager.getAction("$Delete"));
        this.f.addSeparator();
        this.f.add((AnAction)this.a(designerEditorPanel));
        this.f.addSeparator();
        this.f.add((AnAction)this.e);
        designerEditorPanel.getSurfaceArea().addSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectionChanged(EditableArea editableArea) {
                DesignerActionPanel.this.a(editableArea.getSelection());
            }
        });
    }

    protected DefaultActionGroup createActionGroup() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)this.g);
        defaultActionGroup.add((AnAction)this.b);
        return defaultActionGroup;
    }

    protected JComponent createToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar(TOOLBAR, (ActionGroup)this.a, true);
        actionToolbar.setLayoutPolicy(1);
        JComponent jComponent = actionToolbar.getComponent();
        jComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        jComponent.setVisible(false);
        return jComponent;
    }

    @NotNull
    private ActionGroup a(DesignerEditorPanel designerEditorPanel) {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup("_Select", true);
        AnAction anAction = new AnAction("Select Parent", "Select Parent", null){

            public void actionPerformed(AnActionEvent anActionEvent) {
                DesignerActionPanel.this.myDesigner.getToolProvider().processKeyEvent(new KeyEvent(DesignerActionPanel.this.myDesigner.getSurfaceArea().getNativeComponent(), 401, 0L, 0, 27, '\u001b'), DesignerActionPanel.this.myDesigner.getSurfaceArea());
            }
        };
        anAction.registerCustomShortcutSet(27, 0, null);
        EditableArea editableArea = designerEditorPanel.getSurfaceArea();
        SelectSiblingsAction selectSiblingsAction = new SelectSiblingsAction(editableArea);
        SelectSameTypeAction selectSameTypeAction = new SelectSameTypeAction(editableArea);
        DeselectAllAction deselectAllAction = new DeselectAllAction(editableArea);
        AnAction anAction2 = this.createSelectAllAction(editableArea);
        this.registerAction(anAction2, "$SelectAll");
        defaultActionGroup.add(anAction);
        defaultActionGroup.add((AnAction)selectSiblingsAction);
        defaultActionGroup.add((AnAction)selectSameTypeAction);
        defaultActionGroup.addSeparator();
        defaultActionGroup.add(anAction2);
        defaultActionGroup.add((AnAction)deselectAllAction);
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
        if (defaultActionGroup2 == null) {
            DesignerActionPanel.a(0);
        }
        return defaultActionGroup2;
    }

    public AnAction createSelectAllAction(EditableArea editableArea) {
        return new SelectAllAction(editableArea);
    }

    public static StartInplaceEditing createInplaceEditingAction(JComponent jComponent) {
        StartInplaceEditing startInplaceEditing = new StartInplaceEditing();
        startInplaceEditing.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), jComponent);
        return startInplaceEditing;
    }

    public void registerAction(AnAction anAction, @NonNls String string) {
        anAction.registerCustomShortcutSet(ActionManager.getInstance().getAction(string).getShortcutSet(), this.d);
    }

    public JComponent getToolbarComponent() {
        return this.myToolbar;
    }

    public DefaultActionGroup getActionGroup() {
        return this.g;
    }

    public DefaultActionGroup getPopupGroup() {
        return this.f;
    }

    protected DefaultActionGroup getDynamicActionGroup() {
        return this.b;
    }

    protected JComponent getShortcuts() {
        return this.d;
    }

    public void update() {
        boolean bl2 = this.myToolbar.isVisible();
        boolean bl3 = DesignerActionPanel.a(this.a);
        this.myToolbar.setVisible(bl3);
        if (bl2 && bl3) {
            ((JComponent)this.myToolbar.getParent()).revalidate();
        }
    }

    private static boolean a(DefaultActionGroup defaultActionGroup) {
        if (defaultActionGroup.getChildrenCount() == 0) {
            return false;
        }
        for (AnAction anAction : defaultActionGroup.getChildren(null)) {
            if (anAction instanceof DefaultActionGroup) {
                if (!DesignerActionPanel.a((DefaultActionGroup)anAction)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void a(List<RadComponent> list2) {
        boolean bl2 = DesignerActionPanel.a(this.b);
        if (this.b.getChildrenCount() > 0) {
            for (AnAction anAction : this.b.getChildActionsOrStubs()) {
                anAction.unregisterCustomShortcutSet(this.d);
            }
            this.b.removeAll();
        }
        this.addSelectionActions(list2, this.b);
        if (bl2 || DesignerActionPanel.a(this.b)) {
            this.update();
        }
    }

    protected void addSelectionActions(List<RadComponent> list2, DefaultActionGroup defaultActionGroup) {
        for (RadComponent radComponent : RadComponent.getParents(list2)) {
            radComponent.getLayout().addSelectionActions(this.myDesigner, defaultActionGroup, this.d, list2);
        }
        for (RadComponent radComponent : list2) {
            radComponent.addSelectionActions(this.myDesigner, defaultActionGroup, this.d, list2);
        }
    }

    public ActionGroup getPopupActions(EditableArea editableArea) {
        if (this.e.getChildrenCount() > 0) {
            this.e.removeAll();
        }
        WrapInAction.fill(this.myDesigner, this.e, editableArea);
        MorphingAction.fill(this.myDesigner, this.e, editableArea);
        return this.f;
    }

    public Object getData(@NonNls String string) {
        Component component;
        RadPropertyTable radPropertyTable;
        if ((PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(string) || PlatformDataKeys.CUT_PROVIDER.is(string) || PlatformDataKeys.COPY_PROVIDER.is(string) || PlatformDataKeys.PASTE_PROVIDER.is(string)) && !UIUtil.isAncestor((Component)((Object)(radPropertyTable = DesignerToolWindowManager.getInstance(this.myDesigner).getPropertyTable())), (Component)(component = IdeFocusManager.getInstance((Project)this.myDesigner.getProject()).getFocusOwner()))) {
            return this.c;
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/actions/DesignerActionPanel", "createSelectActionGroup"));
    }
}

