/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.List;

public class MorphingAction
extends AnAction {
    private final DesignerEditorPanel d;
    private final EditableArea c;
    private final List<RadComponent> a;
    private final MetaModel b;

    public MorphingAction(DesignerEditorPanel designerEditorPanel, EditableArea editableArea, List<RadComponent> list2, MetaModel metaModel) {
        super(metaModel.getTag(), null, metaModel.getIcon());
        this.d = designerEditorPanel;
        this.c = editableArea;
        this.a = list2;
        this.b = metaModel;
    }

    public void update(AnActionEvent anActionEvent) {
        PaletteItem paletteItem = this.b.getPaletteItem();
        anActionEvent.getPresentation().setEnabled(paletteItem == null || paletteItem.isEnabled());
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        this.d.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>();
            for (RadComponent radComponent : this.a) {
                RadComponent radComponent2 = radComponent.morphingTo(this.b);
                if (radComponent2 == null) continue;
                arrayList.add(radComponent2);
            }
            this.c.setSelection(arrayList);
        }), "Run Morphing action", true);
    }

    public static void fill(DesignerEditorPanel designerEditorPanel, DefaultActionGroup defaultActionGroup, EditableArea editableArea) {
        RadComponent radComponent2;
        List<RadComponent> list2 = editableArea.getSelection();
        if (list2.isEmpty()) {
            return;
        }
        MetaModel metaModel = null;
        for (RadComponent radComponent2 : list2) {
            if (metaModel == null) {
                metaModel = radComponent2.getMetaModel();
                continue;
            }
            if (metaModel == radComponent2.getMetaModel()) continue;
            return;
        }
        if (metaModel == null) {
            return;
        }
        List<MetaModel> list3 = metaModel.getMorphingModels();
        if (list3.isEmpty()) {
            return;
        }
        radComponent2 = new DefaultActionGroup("Morphing", true);
        for (MetaModel metaModel2 : list3) {
            radComponent2.add(new MorphingAction(designerEditorPanel, editableArea, list2, metaModel2));
        }
        defaultActionGroup.add((AnAction)radComponent2);
    }
}

