/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class TreeDropListener
extends DropTargetAdapter {
    private final EditableArea g;
    private final ToolProvider d;
    private final Class[] f;
    private final OperationContext h = new OperationContext();
    private DropTargetDragEvent j;
    private EditOperation a;
    private RadComponent b;
    private boolean i;
    private boolean e;
    private static final Cursor c = Cursors.getMoveCursor();

    public TreeDropListener(ComponentTree componentTree, EditableArea editableArea, ToolProvider toolProvider) {
        this((JComponent)((Object)componentTree), editableArea, toolProvider, TreeDropListener.class, PaletteItem.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            componentTree.setDragEnabled(true);
            componentTree.setTransferHandler(new TreeTransfer(TreeDropListener.class));
        }
    }

    public TreeDropListener(JComponent jComponent, EditableArea editableArea, ToolProvider toolProvider, Class ... classArray) {
        this.g = editableArea;
        this.h.setArea(editableArea);
        this.d = toolProvider;
        this.f = classArray;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            jComponent.setDropTarget(new DropTarget(jComponent, this));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.a();
        this.a(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.j = dropTargetDragEvent;
        this.g();
        this.b();
        this.d();
        this.e();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.a();
        this.c();
        this.a(true);
        dropTargetDropEvent.dropComplete(true);
    }

    private void e() {
        if (this.a != null) {
            this.a.showFeedback();
        }
        this.e = true;
    }

    private void a() {
        if (this.e) {
            this.e = false;
            if (this.a != null) {
                this.a.eraseFeedback();
            }
        }
    }

    private void g() {
        this.h.setLocation(this.f());
        if (this.h.getComponents() == null) {
            if (!ArrayUtil.contains((Object)SimpleTransferable.getData(this.j.getTransferable(), Class.class), (Object[])this.f)) {
                this.h.setComponents(Collections.emptyList());
                return;
            }
            if (this.d.getActiveTool() instanceof CreationTool) {
                this.h.setType("create_children");
                CreationTool creationTool = (CreationTool)this.d.getActiveTool();
                try {
                    this.h.setComponents(Collections.singletonList(creationTool.getFactory().create()));
                }
                catch (Throwable throwable) {
                    this.h.setComponents(Collections.emptyList());
                    this.d.loadDefaultTool();
                }
                return;
            }
            List<RadComponent> list2 = RadComponent.getPureSelection(this.g.getSelection());
            RadComponent radComponent = null;
            for (RadComponent radComponent2 : list2) {
                if (radComponent == null) {
                    radComponent = radComponent2.getParent();
                    continue;
                }
                if (radComponent == radComponent2.getParent()) continue;
                list2 = Collections.emptyList();
                break;
            }
            this.h.setComponents(list2);
            this.h.resetMoveAddEnabled();
            for (RadComponent radComponent2 : list2) {
                radComponent2.processDropOperation(this.h);
            }
        }
    }

    private void b() {
        if (this.h.getComponents().isEmpty()) {
            return;
        }
        final ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>(this.h.getComponents());
        if (!this.h.isCreate()) {
            for (RadComponent object2 : this.h.getComponents()) {
                object2.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent radComponent) {
                        arrayList.add(radComponent);
                    }
                }, true);
            }
        }
        final EditOperation[] editOperationArray = new EditOperation[1];
        ComponentTargetFilter componentTargetFilter = new ComponentTargetFilter(){

            @Override
            public boolean preFilter(RadComponent radComponent) {
                return TreeDropListener.this.h.isCreate() || !arrayList.contains((Object)radComponent);
            }

            @Override
            public boolean resultFilter(RadComponent radComponent) {
                if (!TreeDropListener.this.h.isCreate()) {
                    if (TreeDropListener.this.h.getComponents().get(0).getParent() == radComponent) {
                        TreeDropListener.this.h.setType("move_children");
                    } else {
                        TreeDropListener.this.h.setType("add_children");
                    }
                }
                if (TreeDropListener.this.b == radComponent) {
                    return true;
                }
                RadLayout radLayout = radComponent.getLayout();
                if (radLayout != null) {
                    editOperationArray[0] = radLayout.processChildOperation(TreeDropListener.this.h);
                }
                return editOperationArray[0] != null;
            }
        };
        Point point = this.f();
        RadComponent radComponent = this.g.findTarget(point.x, point.y, componentTargetFilter);
        if (radComponent != this.b) {
            if (this.a != null) {
                this.a();
            }
            this.b = radComponent;
            this.a = editOperationArray[0];
        }
        if (radComponent == null) {
            if (!this.h.isCreate()) {
                this.h.setType(null);
            }
        } else {
            this.a.setComponents(this.h.getComponents());
        }
    }

    private Point f() {
        return this.j.getLocation();
    }

    private void d() {
        if (this.a != null) {
            if (this.h.isMove()) {
                this.b(this.h.isMoveEnabled() && this.a.canExecute());
            } else if (this.h.isAdd()) {
                this.b(this.h.isAddEnabled() && this.a.canExecute());
            } else if (this.h.isCreate()) {
                this.b(this.a.canExecute());
            } else {
                this.b(false);
            }
        } else {
            this.b(false);
        }
    }

    private void b(boolean bl2) {
        this.i = bl2;
        if (bl2) {
            this.j.acceptDrag(this.j.getDropAction());
            this.g.setCursor(this.h.isCreate() ? Cursors.getCopyCursor() : c);
        } else {
            this.j.rejectDrag();
            this.g.setCursor(Cursors.getSystemNoCursor());
        }
    }

    private void c() {
        if (this.i) {
            this.d.execute(Collections.singletonList(this.a), this.h.getMessage());
            if (this.h.isCreate()) {
                this.g.setSelection(this.h.getComponents());
            }
        }
    }

    private void a(boolean bl2) {
        this.h.setComponents(null);
        this.j = null;
        this.a = null;
        this.b = null;
        this.i = false;
        if (bl2 || !this.h.isCreate()) {
            this.h.setType(null);
            this.d.loadDefaultTool();
        }
        this.g.setCursor(null);
    }
}

