/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.TargetingTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Dimension;
import java.awt.event.KeyEvent;

public abstract class AbstractCreationTool
extends TargetingTool {
    private final boolean g;

    protected AbstractCreationTool(boolean bl2) {
        this.g = bl2;
        this.setDefaultCursor(Cursors.getCopyCursor());
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (n2 == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.handleInvalidInput();
        }
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 2 || this.myState == 3) {
            this.eraseFeedback();
            this.executeCommand();
            this.b();
        }
        this.myState = 0;
        this.c();
    }

    @Override
    protected void handleMove() {
        this.updateContext();
        this.a();
        this.showFeedback();
        this.updateCommand();
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.updateContext();
            this.showFeedback();
            this.updateCommand();
        }
    }

    private void b() {
        if (this.myExecuteEnabled) {
            this.myArea.setSelection(this.myContext.getComponents());
        }
    }

    @Override
    protected void resetState() {
        if (this.g || this.myArea == null) {
            super.resetState();
        }
    }

    private void c() {
        if (this.g) {
            this.myToolProvider.loadDefaultTool();
        } else {
            this.deactivate();
            this.activate();
            if (this.myArea != null) {
                this.handleMove();
            }
        }
    }

    private void a() {
        TargetingTool.ContainerTargetFilter containerTargetFilter = new TargetingTool.ContainerTargetFilter(this);
        RadComponent radComponent = this.myArea.findTarget(this.myCurrentScreenX, this.myCurrentScreenY, containerTargetFilter);
        this.setTarget(radComponent, containerTargetFilter);
        if (radComponent != null) {
            this.updateTarget();
        }
    }

    protected abstract void updateTarget();

    @Override
    protected void updateContext() {
        super.updateContext();
        if (this.myState == 3) {
            this.myContext.setSizeDelta(new Dimension(this.moveDeltaWidth(), this.moveDeltaHeight()));
        }
        this.myContext.setLocation(this.getLocation());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        super.keyPressed(keyEvent, editableArea);
        if (keyEvent.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        }
    }

    @Override
    protected void handleKeyEvent() {
    }
}

