/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.inspector;

import com.intellij.designer.inspector.AbstractProperty;
import com.intellij.designer.inspector.DefaultPresentationManager;
import com.intellij.designer.inspector.PresentationManager;
import com.intellij.designer.inspector.Property;
import com.intellij.designer.inspector.PropertyEditor;
import com.intellij.designer.inspector.PropertyRenderer;
import com.intellij.designer.inspector.PropertyValidator;
import com.intellij.designer.inspector.impl.InspectorSpeedSearch;
import com.intellij.designer.inspector.impl.NameRendererAdapter;
import com.intellij.designer.inspector.impl.ValueEditorAdapter;
import com.intellij.designer.inspector.impl.ValueRendererAdapter;
import com.intellij.designer.inspector.impl.actions.CollapseAllAction;
import com.intellij.designer.inspector.impl.actions.ExpandAllAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyInspector
extends TreeTable
implements DataProvider {
    @NonNls
    public static final String INSPECTOR_KEY = "propertyInspector";
    @NonNls
    public static final String STOP_EDITING_ACTION_KEY = "stpEditingOnEnter";
    private PresentationManager d;
    private boolean c = true;
    private boolean e = true;
    private final Map<Class, PropertyRenderer> f = new HashMap<Class, PropertyRenderer>();
    private final Map<Class, PropertyRenderer> a = new HashMap<Class, PropertyRenderer>();
    private final Map<Class, PropertyEditor> b = new HashMap<Class, PropertyEditor>();

    public PropertyInspector() {
        super(PropertyInspector.a());
        this.setRowMargin(0);
        new InspectorSpeedSearch(this);
        this.d = new DefaultPresentationManager<PropertyInspector>(this);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if ("tableCellEditor".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == null && propertyChangeEvent.getOldValue() != null && (object = propertyChangeEvent.getOldValue()) instanceof ValueEditorAdapter) {
                    ((ValueEditorAdapter)object).cancelCellEditing();
                    PropertyInspector.this.requestFocusInWindow();
                }
            }
        });
        this.setDragEnabled(false);
    }

    public <P extends Property> void setNameRenderer(Class<P> clazz, @NotNull PropertyRenderer<P> propertyRenderer) {
        if (propertyRenderer == null) {
            PropertyInspector.a(0);
        }
        this.f.put(clazz, propertyRenderer);
    }

    public <P extends Property> PropertyRenderer<P> getNameRenderer(P p2) {
        return PropertyInspector.a(this.f, p2);
    }

    public <P extends Property> void setValueRenderer(Class<P> clazz, @NotNull PropertyRenderer<P> propertyRenderer) {
        if (propertyRenderer == null) {
            PropertyInspector.a(1);
        }
        this.a.put(clazz, propertyRenderer);
    }

    public <P extends Property> PropertyRenderer<P> getValueRenderer(P p2) {
        return PropertyInspector.a(this.a, p2);
    }

    public <P extends Property> void setValueEditor(Class<P> clazz, @NotNull PropertyEditor<P> propertyEditor) {
        if (propertyEditor == null) {
            PropertyInspector.a(2);
        }
        this.b.put(clazz, propertyEditor);
    }

    public <P extends Property> PropertyEditor<P> getValueEditor(@NotNull P p2) {
        if (p2 == null) {
            PropertyInspector.a(3);
        }
        return PropertyInspector.a(this.b, p2);
    }

    private static <P extends Property, T extends PropertyValidator<P>> T a(@NotNull Map<Class, T> map, @NotNull P p2) {
        Class<?> clazz;
        PropertyValidator propertyValidator;
        if (map == null) {
            PropertyInspector.a(4);
        }
        if (p2 == null) {
            PropertyInspector.a(5);
        }
        if ((propertyValidator = (PropertyValidator)map.get(clazz = p2.getClass())) != null) {
            return (T)propertyValidator;
        }
        for (Class clazz2 : map.keySet()) {
            PropertyValidator propertyValidator2 = (PropertyValidator)map.get(clazz2);
            if (!clazz2.isAssignableFrom(clazz) || !propertyValidator2.accepts(p2)) continue;
            map.put(clazz, propertyValidator2);
            return (T)propertyValidator2;
        }
        return (T)propertyValidator;
    }

    protected String getNameColumnTitle() {
        return "name";
    }

    protected String getValueColumnTitle() {
        return "value";
    }

    protected ColumnInfo[] getColumnInfo() {
        return new ColumnInfo[]{new TreeColumnInfo(this.getNameColumnTitle()), new ColumnInfo<Property, Object>(this.getValueColumnTitle()){

            public Object valueOf(Property property) {
                return property;
            }

            public boolean isCellEditable(Property property) {
                PropertyEditor<Property> propertyEditor = PropertyInspector.this.getValueEditor(property);
                return propertyEditor != null && propertyEditor.canEdit(property);
            }
        }};
    }

    protected void setStopEditingOnEnter(boolean bl2) {
        this.c = bl2;
    }

    protected void setStartEditingOnEnter(boolean bl2) {
        this.e = bl2;
    }

    public void setRoot(Property property) {
        int n2 = this.getSelectedRow();
        this.setModel((TreeTableModel)new ListTreeTableModel((TreeNode)property, this.getColumnInfo()));
        if (this.getRowCount() > n2) {
            this.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    @Nullable
    public Property getRoot() {
        return (Property)this.getTableModel().getRoot();
    }

    public boolean editCellAt(int n2, int n3, EventObject eventObject) {
        TableCellEditor tableCellEditor;
        if (!this.isEditing() && (tableCellEditor = this.getCellEditor(n2, n3)) != null && this.isCellEditable(n2, n3)) {
            Component component = tableCellEditor.getTableCellEditorComponent((JTable)((Object)this), this.getRowValue(n2), this.isRowSelected(n2), n2, n3);
            this.add(component);
        }
        return super.editCellAt(n2, n3, eventObject);
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Rectangle getCellRect(@NotNull Property property) {
        if (property == null) {
            PropertyInspector.a(6);
        }
        int n2 = this.getPropertyIndex(property);
        return this.getCellRect(n2, 0, false);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.a(mouseEvent);
        }
        super.processMouseEvent(mouseEvent);
    }

    private void a(MouseEvent mouseEvent) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup("???", true);
        this.addActions(defaultActionGroup);
        ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("TodoViewPopup", (ActionGroup)defaultActionGroup);
        actionPopupMenu.getComponent().show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
    }

    protected void addActions(DefaultActionGroup defaultActionGroup) {
        defaultActionGroup.add(ActionManager.getInstance().getAction("PropertyInspectorActions.CommonActions"));
    }

    public void setModel(TreeTableModel treeTableModel) {
        TreeTableModel treeTableModel2 = treeTableModel == null ? PropertyInspector.a() : treeTableModel;
        super.setModel(treeTableModel2);
        this.b();
        this.setRootVisible(false);
        if (treeTableModel2 != null && treeTableModel2.getRoot() instanceof Property) {
            this.expandAll();
        }
    }

    private void b() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setDragEnabled(false);
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        TreeTableTree treeTableTree = this.getTree();
        treeTableTree.setShowsRootHandles(false);
        treeTableTree.getSelectionModel().setSelectionMode(1);
        treeTableTree.setCellRenderer((TreeCellRenderer)new NameRendererAdapter(this, treeTableTree.getCellRenderer()));
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel.getColumnCount() == 2) {
            TableColumn tableColumn = tableColumnModel.getColumn(1);
            tableColumn.setCellRenderer(new ValueRendererAdapter(this, this.getDefaultRenderer(Object.class)));
            tableColumn.setCellEditor(new ValueEditorAdapter(this));
        }
    }

    private static TreeTableModel a() {
        return new ListTreeTableModel((TreeNode)new AbstractProperty<String, String>("dummy", "dummy"){}, ColumnInfo.EMPTY_ARRAY);
    }

    @Nullable
    public Object getData(String string) {
        if (INSPECTOR_KEY.equals(string)) {
            return this;
        }
        return null;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)this.getTree());
    }

    public void collapseAll() {
        TreeUtil.collapseAll((JTree)this.getTree(), (int)1);
    }

    public void firePropertyAdded(Property property, Property property2, int n2) {
        ((AbstractTableModel)this.getModel()).fireTableRowsInserted(n2, n2);
    }

    public void firePropertyRemoved(Property property, Property property2, int n2) {
        ((AbstractTableModel)this.getModel()).fireTableRowsDeleted(n2, n2);
    }

    @NotNull
    public AnAction getExpandAll() {
        ExpandAllAction expandAllAction = new ExpandAllAction(this);
        if (expandAllAction == null) {
            PropertyInspector.a(7);
        }
        return expandAllAction;
    }

    @NotNull
    public AnAction getCollapseAll() {
        CollapseAllAction collapseAllAction = new CollapseAllAction(this);
        if (collapseAllAction == null) {
            PropertyInspector.a(8);
        }
        return collapseAllAction;
    }

    @Nullable
    public Property getSelectedProperty() {
        int n2 = this.getSelectedRow();
        return this.getRowValue(n2);
    }

    protected Property getRowValue(int n2) {
        return (Property)this.getModel().getValueAt(n2, 1);
    }

    public int getSelectedPropertyIndex() {
        return this.getSelectedRow();
    }

    protected int getPropertyIndex(@NotNull Property property) {
        if (property == null) {
            PropertyInspector.a(9);
        }
        TableModel tableModel = this.getModel();
        for (int i2 = 0; i2 < tableModel.getRowCount(); ++i2) {
            Object object = tableModel.getValueAt(i2, 1);
            if (object != property) continue;
            return i2;
        }
        return -1;
    }

    public void setSelectedProperty(@NotNull Property property) {
        if (property == null) {
            PropertyInspector.a(10);
        }
        int n2 = this.getPropertyIndex(property);
        this.getSelectionModel().setSelectionInterval(n2, n2);
    }

    public PresentationManager getPresentationManager() {
        return this.d;
    }

    public void setPresentationManager(PresentationManager presentationManager) {
        this.d = presentationManager;
    }

    public TreePath getPathForRow(int n2) {
        return this.getTree().getPathForRow(n2);
    }

    public void processEnter() {
        int n2;
        if (this.c && this.isEditing()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.requestFocusInWindow();
        } else if (this.e && this.isCellEditable(n2 = this.getSelectedRow(), 1)) {
            this.editCellAt(n2, 1, null);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "class2valueMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/inspector/PropertyInspector";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/inspector/PropertyInspector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandAll";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapseAll";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNameRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setValueRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValueEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueFromMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCellRect";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

