/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItemsComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;

public class PaletteGroupComponent
extends JCheckBox {
    private PaletteItemsComponent a;

    public PaletteGroupComponent(PaletteGroup paletteGroup) {
        this.setText(paletteGroup.getName());
        this.setSelected(true);
        this.setIcon(AllIcons.Nodes.TreeClosed);
        this.setSelectedIcon(AllIcons.Nodes.Folder);
        this.setFont(this.getFont().deriveFont(1));
        this.setFocusPainted(false);
        this.setMargin(new Insets(0, 3, 0, 3));
        this.setOpaque(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteGroupComponent.this.a.setVisible(PaletteGroupComponent.this.isSelected());
            }
        });
        this.a();
    }

    @Override
    public Color getBackground() {
        if (this.isFocusOwner()) {
            return UIUtil.getListSelectionBackground();
        }
        if (UIUtil.isUnderDarcula()) {
            return Gray._100;
        }
        return super.getBackground();
    }

    @Override
    public Color getForeground() {
        if (this.isFocusOwner()) {
            return UIUtil.getListSelectionForeground();
        }
        return super.getForeground();
    }

    public PaletteItemsComponent getItemsComponent() {
        return this.a;
    }

    public void setItemsComponent(PaletteItemsComponent paletteItemsComponent) {
        this.a = paletteItemsComponent;
    }

    private void a() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "moveFocusDown");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "moveFocusUp");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "collapse");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "expand");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("moveFocusDown", new MoveFocusAction(true));
        actionMap.put("moveFocusUp", new MoveFocusAction(false));
        actionMap.put("collapse", new ExpandAction(false));
        actionMap.put("expand", new ExpandAction(true));
    }

    private class ExpandAction
    extends AbstractAction {
        private final boolean a;

        public ExpandAction(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.a != PaletteGroupComponent.this.isSelected()) {
                PaletteGroupComponent.this.setSelected(this.a);
                if (PaletteGroupComponent.this.a != null) {
                    PaletteGroupComponent.this.a.setVisible(PaletteGroupComponent.this.isSelected());
                }
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private final boolean a;

        public MoveFocusAction(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = keyboardFocusManager.getCurrentFocusCycleRoot();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                Component component;
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                if (focusTraversalPolicy == null) {
                    focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
                }
                Component component2 = component = this.a ? focusTraversalPolicy.getComponentAfter(container, PaletteGroupComponent.this) : focusTraversalPolicy.getComponentBefore(container, PaletteGroupComponent.this);
                if (component instanceof PaletteItemsComponent) {
                    PaletteItemsComponent paletteItemsComponent = (PaletteItemsComponent)((Object)((Object)component));
                    if (paletteItemsComponent.getModel().getSize() != 0) {
                        paletteItemsComponent.takeFocusFrom(paletteItemsComponent == PaletteGroupComponent.this.a ? 0 : -1);
                        return;
                    }
                    Component component3 = component = this.a ? focusTraversalPolicy.getComponentAfter(container, component) : focusTraversalPolicy.getComponentBefore(container, component);
                }
                if (component instanceof PaletteGroupComponent) {
                    IdeFocusManager.getGlobalInstance().requestFocus(component, true);
                }
            });
        }
    }
}

