/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.AlternativeSdkRootsProvider;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.application.ApplicationConfigurable;
import com.intellij.execution.application.ApplicationConfigurationOptions;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfigurationOptions;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.PathsList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
ConfigurationWithCommandLineShortener,
SingleClassConfiguration,
RefactoringListenerProvider {
    @Deprecated
    public String MAIN_CLASS_NAME;
    @Deprecated
    public String PROGRAM_PARAMETERS;
    @Deprecated
    public String WORKING_DIRECTORY;
    @Deprecated
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    @Deprecated
    public String ALTERNATIVE_JRE_PATH;
    @Deprecated
    public boolean ENABLE_SWING_INSPECTOR;
    private ShortenCommandLine a = null;

    public ApplicationConfiguration(String string, Project project2, ApplicationConfigurationType applicationConfigurationType) {
        this(string, project2, applicationConfigurationType.getConfigurationFactories()[0]);
    }

    protected ApplicationConfiguration(String string, Project project2, ConfigurationFactory configurationFactory) {
        super(string, (RunConfigurationModule)new JavaRunConfigurationModule(project2, true), configurationFactory);
    }

    protected ApplicationConfigurationOptions getOptions() {
        return (ApplicationConfigurationOptions)super.getOptions();
    }

    protected Class<? extends ModuleBasedConfigurationOptions> getOptionsClass() {
        return ApplicationConfigurationOptions.class;
    }

    @Override
    public void setMainClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ApplicationConfiguration.a(0);
        }
        Module module2 = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(module2);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            ApplicationConfiguration.a(1);
        }
        if (executionEnvironment == null) {
            ApplicationConfiguration.a(2);
        }
        JavaApplicationCommandLineState<ApplicationConfiguration> javaApplicationCommandLineState = new JavaApplicationCommandLineState<ApplicationConfiguration>(this, executionEnvironment);
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        javaApplicationCommandLineState.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), javaRunConfigurationModule.getSearchScope()));
        return javaApplicationCommandLineState;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup settingsEditorGroup = new SettingsEditorGroup();
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, settingsEditorGroup);
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup2 = settingsEditorGroup;
        if (settingsEditorGroup2 == null) {
            ApplicationConfiguration.a(3);
        }
        return settingsEditorGroup2;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement psiElement) {
        RefactoringElementListener refactoringElementListener = RefactoringListeners.getClassOrPackageListener(psiElement, new RefactoringListeners.SingleClassConfigurationAccessor(this));
        return RunConfigurationExtension.wrapRefactoringElementListener(psiElement, (RunConfigurationBase)this, refactoringElementListener);
    }

    @Override
    @Nullable
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.getMainClassName());
    }

    @Nullable
    public String getMainClassName() {
        return this.MAIN_CLASS_NAME;
    }

    @Nullable
    public String suggestedName() {
        if (this.getMainClassName() == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName());
    }

    public String getActionName() {
        if (this.getMainClassName() == null) {
            return null;
        }
        return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.getMainClassName()), (int)6) + ".main()";
    }

    @Override
    public void setMainClassName(@Nullable String string) {
        this.MAIN_CLASS_NAME = string;
        this.getOptions().setMainClassName(string);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass psiClass = javaRunConfigurationModule.checkModuleAndClassName(this.getMainClassName(), ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        if (!PsiMethodUtil.hasMainMethod((PsiClass)psiClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"main.method.not.found.in.class.error.message", (Object[])new Object[]{this.getMainClassName()}));
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)javaRunConfigurationModule.getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    @Override
    public void setVMParameters(@Nullable String string) {
        this.getOptions().setVmParameters(string);
    }

    @Override
    public String getVMParameters() {
        return this.getOptions().getVmParameters();
    }

    public void setProgramParameters(@Nullable String string) {
        this.PROGRAM_PARAMETERS = string;
        this.getOptions().setProgramParameters(string);
    }

    public String getProgramParameters() {
        return this.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String string) {
        String string2;
        this.WORKING_DIRECTORY = string2 = ExternalizablePath.urlValue((String)string);
        this.getOptions().setWorkingDirectory(string2);
    }

    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
    }

    public void setPassParentEnvs(boolean bl2) {
        this.getOptions().setPassParentEnv(bl2);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.getOptions().getEnv();
        if (map == null) {
            ApplicationConfiguration.a(4);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> map) {
        if (map == null) {
            ApplicationConfiguration.a(5);
        }
        this.getOptions().setEnv(map);
    }

    public boolean isPassParentEnvs() {
        return this.getOptions().isPassParentEnv();
    }

    @Override
    @Nullable
    public String getRunClass() {
        return this.getMainClassName();
    }

    @Override
    @Nullable
    public String getPackage() {
        return null;
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean bl2) {
        boolean bl3 = this.ALTERNATIVE_JRE_PATH_ENABLED != bl2;
        this.ALTERNATIVE_JRE_PATH_ENABLED = bl2;
        this.getOptions().setAlternativeJrePathEnabled(bl2);
        ApplicationConfiguration.onAlternativeJreChanged(bl3, this.getProject());
    }

    @Override
    @Nullable
    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    @Override
    public void setAlternativeJrePath(@Nullable String string) {
        boolean bl2 = !Objects.equals(this.ALTERNATIVE_JRE_PATH, string);
        this.ALTERNATIVE_JRE_PATH = string;
        this.getOptions().setAlternativeJrePath(string);
        ApplicationConfiguration.onAlternativeJreChanged(bl2, this.getProject());
    }

    public static void onAlternativeJreChanged(boolean bl2, Project project2) {
        if (bl2) {
            AlternativeSdkRootsProvider.reindexIfNeeded(project2);
        }
    }

    public boolean isProvidedScopeIncluded() {
        return this.getOptions().getIncludeProvidedScope();
    }

    public void setIncludeProvidedScope(boolean bl2) {
        this.getOptions().setIncludeProvidedScope(bl2);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.getMainClassName());
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            ApplicationConfiguration.a(6);
        }
        super.readExternal(element);
        ApplicationConfigurationOptions applicationConfigurationOptions = this.getOptions();
        this.MAIN_CLASS_NAME = applicationConfigurationOptions.getMainClassName();
        this.PROGRAM_PARAMETERS = applicationConfigurationOptions.getProgramParameters();
        this.WORKING_DIRECTORY = applicationConfigurationOptions.getWorkingDirectory();
        this.ALTERNATIVE_JRE_PATH = applicationConfigurationOptions.getAlternativeJrePath();
        this.ALTERNATIVE_JRE_PATH_ENABLED = applicationConfigurationOptions.isAlternativeJrePathEnabled();
        this.ENABLE_SWING_INSPECTOR = applicationConfigurationOptions.isSwingInspectorEnabled();
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        this.setShortenCommandLine(ShortenCommandLine.readShortenClasspathMethod((Element)element));
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ApplicationConfiguration.a(7);
        }
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        ShortenCommandLine.writeShortenClasspathMethod((Element)element, (ShortenCommandLine)this.a);
    }

    @Nullable
    public ShortenCommandLine getShortenCommandLine() {
        return this.a;
    }

    public void setShortenCommandLine(ShortenCommandLine shortenCommandLine) {
        this.a = shortenCommandLine;
    }

    public boolean isSwingInspectorEnabled() {
        return this.ENABLE_SWING_INSPECTOR;
    }

    public void setSwingInspectorEnabled(boolean bl2) {
        this.ENABLE_SWING_INSPECTOR = bl2;
        this.getOptions().setSwingInspectorEnabled(bl2);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/application/ApplicationConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/application/ApplicationConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setMainClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JavaApplicationCommandLineState<T extends ApplicationConfiguration>
    extends BaseJavaApplicationCommandLineState<T> {
        public JavaApplicationCommandLineState(@NotNull T t2, ExecutionEnvironment executionEnvironment) {
            if (t2 == null) {
                JavaApplicationCommandLineState.b(0);
            }
            super(executionEnvironment, t2);
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            String string;
            JavaParameters javaParameters = new JavaParameters();
            ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)this.getConfiguration();
            javaParameters.setShortenCommandLine(applicationConfiguration.getShortenCommandLine(), applicationConfiguration.getProject());
            JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)((ApplicationConfiguration)this.myConfiguration).getConfigurationModule();
            String string2 = string = ((ApplicationConfiguration)this.myConfiguration).isAlternativeJrePathEnabled() ? ((ApplicationConfiguration)this.myConfiguration).getAlternativeJrePath() : null;
            if (javaRunConfigurationModule.getModule() != null) {
                DumbService.getInstance((Project)javaRunConfigurationModule.getProject()).runWithAlternativeResolveEnabled(() -> {
                    int n2 = JavaParametersUtil.getClasspathType((RunConfigurationModule)javaRunConfigurationModule, ((ApplicationConfiguration)this.myConfiguration).getMainClassName(), false, ((ApplicationConfiguration)this.myConfiguration).isProvidedScopeIncluded());
                    JavaParametersUtil.configureModule((RunConfigurationModule)javaRunConfigurationModule, javaParameters, n2, string);
                });
            } else {
                JavaParametersUtil.configureProject(javaRunConfigurationModule.getProject(), javaParameters, 7, string);
            }
            javaParameters.setMainClass(((ApplicationConfiguration)this.myConfiguration).getMainClassName());
            this.setupJavaParameters(javaParameters);
            JavaApplicationCommandLineState.a(javaParameters, javaRunConfigurationModule);
            return javaParameters;
        }

        protected GeneralCommandLine createCommandLine() throws ExecutionException {
            GeneralCommandLine generalCommandLine = super.createCommandLine();
            Map map = (Map)generalCommandLine.getUserData(JdkUtil.COMMAND_LINE_CONTENT);
            if (map != null) {
                map.forEach((string, string2) -> this.addConsoleFilters(new Filter[]{new ArgumentFileFilter(string, string2)}));
            }
            return generalCommandLine;
        }

        @Override
        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            OSProcessHandler oSProcessHandler = super.startProcess();
            if (oSProcessHandler instanceof KillableProcessHandler && DebuggerSettings.getInstance().KILL_PROCESS_IMMEDIATELY) {
                ((KillableProcessHandler)oSProcessHandler).setShouldKillProcessSoftly(false);
            }
            OSProcessHandler oSProcessHandler2 = oSProcessHandler;
            if (oSProcessHandler2 == null) {
                JavaApplicationCommandLineState.b(1);
            }
            return oSProcessHandler2;
        }

        private static void a(JavaParameters javaParameters, JavaRunConfigurationModule javaRunConfigurationModule) {
            PsiJavaModule psiJavaModule;
            if (JavaSdkUtil.isJdkAtLeast((Sdk)javaParameters.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (psiJavaModule = (PsiJavaModule)DumbService.getInstance((Project)javaRunConfigurationModule.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByElement((PsiElement)javaRunConfigurationModule.findClass(javaParameters.getMainClass())))) != null) {
                javaParameters.setModuleName(psiJavaModule.getName());
                PathsList pathsList = javaParameters.getClassPath();
                PathsList pathsList2 = javaParameters.getModulePath();
                pathsList2.addAll(pathsList.getPathList());
                pathsList.clear();
            }
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/application/ApplicationConfiguration$JavaApplicationCommandLineState";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/application/ApplicationConfiguration$JavaApplicationCommandLineState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startProcess";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

