/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.execution.jar.JarApplicationCommandLineState;
import com.intellij.execution.jar.JarApplicationConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarApplicationConfiguration
extends LocatableConfigurationBase
implements CommonJavaRunConfigurationParameters,
SearchScopeProvidingRunProfile {
    private static final SkipDefaultValuesSerializationFilters d = new SkipDefaultValuesSerializationFilters();
    private JarApplicationConfigurationBean c = new JarApplicationConfigurationBean();
    private Map<String, String> b = new LinkedHashMap<String, String>();
    private JavaRunConfigurationModule a;

    public JarApplicationConfiguration(Project project2, ConfigurationFactory configurationFactory, String string) {
        super(project2, configurationFactory, string);
        this.a = new JavaRunConfigurationModule(project2, true);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup settingsEditorGroup = new SettingsEditorGroup();
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JarApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, settingsEditorGroup);
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup2 = settingsEditorGroup;
        if (settingsEditorGroup2 == null) {
            JarApplicationConfiguration.a(0);
        }
        return settingsEditorGroup2;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JarApplicationConfiguration.a(1);
        }
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        XmlSerializer.deserializeInto((Object)this.c, (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getEnvs());
        this.a.readExternal(element);
    }

    public RunConfiguration clone() {
        JarApplicationConfiguration jarApplicationConfiguration = (JarApplicationConfiguration)super.clone();
        jarApplicationConfiguration.b = new LinkedHashMap<String, String>(this.b);
        jarApplicationConfiguration.a = new JavaRunConfigurationModule(this.getProject(), true);
        jarApplicationConfiguration.a.setModule(this.a.getModule());
        jarApplicationConfiguration.c = (JarApplicationConfigurationBean)XmlSerializerUtil.createCopy((Object)this.c);
        return jarApplicationConfiguration;
    }

    public void setModule(Module module2) {
        this.a.setModule(module2);
    }

    public Module getModule() {
        return this.a.getModule();
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JarApplicationConfiguration.a(2);
        }
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        XmlSerializer.serializeInto((Object)this.c, (Element)element, (SerializationFilter)d);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getEnvs());
        if (this.a.getModule() != null) {
            this.a.writeExternal(element);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), null);
        File file = new File(this.getJarPath());
        if (!file.exists()) {
            throw new RuntimeConfigurationWarning("JAR file '" + file.getAbsolutePath() + "' doesn't exist");
        }
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray;
        Module module2 = this.a.getModule();
        if (module2 != null) {
            Module[] moduleArray2 = new Module[1];
            moduleArray = moduleArray2;
            moduleArray2[0] = module2;
        } else {
            moduleArray = Module.EMPTY_ARRAY;
        }
        if (moduleArray == null) {
            JarApplicationConfiguration.a(3);
        }
        return moduleArray;
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        return SearchScopeProvider.createSearchScope((Module[])this.getModules());
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            JarApplicationConfiguration.a(4);
        }
        if (executionEnvironment == null) {
            JarApplicationConfiguration.a(5);
        }
        return new JarApplicationCommandLineState(this, executionEnvironment);
    }

    public String getJarPath() {
        return this.c.JAR_PATH;
    }

    public void setJarPath(String string) {
        this.c.JAR_PATH = string;
    }

    @Override
    public void setVMParameters(@Nullable String string) {
        this.c.VM_PARAMETERS = string;
    }

    @Override
    public String getVMParameters() {
        return this.c.VM_PARAMETERS;
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.c.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean bl2) {
        this.c.ALTERNATIVE_JRE_PATH_ENABLED = bl2;
    }

    @Override
    @Nullable
    public String getAlternativeJrePath() {
        return this.c.ALTERNATIVE_JRE_PATH;
    }

    @Override
    public void setAlternativeJrePath(String string) {
        this.c.ALTERNATIVE_JRE_PATH = string;
    }

    @Override
    @Nullable
    public String getRunClass() {
        return null;
    }

    @Override
    @Nullable
    public String getPackage() {
        return null;
    }

    public void setProgramParameters(@Nullable String string) {
        this.c.PROGRAM_PARAMETERS = string;
    }

    @Nullable
    public String getProgramParameters() {
        return this.c.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String string) {
        this.c.WORKING_DIRECTORY = string;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.c.WORKING_DIRECTORY;
    }

    public void setEnvs(@NotNull Map<String, String> map) {
        if (map == null) {
            JarApplicationConfiguration.a(6);
        }
        this.b.clear();
        this.b.putAll(map);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.b;
        if (map == null) {
            JarApplicationConfiguration.a(7);
        }
        return map;
    }

    public void setPassParentEnvs(boolean bl2) {
        this.c.PASS_PARENT_ENVS = bl2;
    }

    public boolean isPassParentEnvs() {
        return this.c.PASS_PARENT_ENVS;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/jar/JarApplicationConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/jar/JarApplicationConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JarApplicationConfigurationBean {
        public String JAR_PATH = "";
        public String VM_PARAMETERS = "";
        public String PROGRAM_PARAMETERS = "";
        public String WORKING_DIRECTORY = "";
        public boolean ALTERNATIVE_JRE_PATH_ENABLED;
        public String ALTERNATIVE_JRE_PATH = "";
        public boolean PASS_PARENT_ENVS = true;

        private JarApplicationConfigurationBean() {
        }
    }
}

