/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.jar.JarApplicationConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public class JarApplicationConfigurationProducer
extends RunConfigurationProducer<JarApplicationConfiguration> {
    public JarApplicationConfigurationProducer() {
        super((ConfigurationType)JarApplicationConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(JarApplicationConfiguration jarApplicationConfiguration, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        VirtualFile virtualFile = JarApplicationConfigurationProducer.a(configurationContext);
        if (virtualFile != null) {
            jarApplicationConfiguration.setName(virtualFile.getName());
            jarApplicationConfiguration.setJarPath(virtualFile.getPath());
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile a(ConfigurationContext configurationContext) {
        Location location = configurationContext.getLocation();
        if (location == null) {
            return null;
        }
        VirtualFile virtualFile = location.getVirtualFile();
        return virtualFile != null && FileUtilRt.extensionEquals((String)virtualFile.getName(), (String)"jar") ? virtualFile : null;
    }

    public boolean isConfigurationFromContext(JarApplicationConfiguration jarApplicationConfiguration, ConfigurationContext configurationContext) {
        VirtualFile virtualFile = JarApplicationConfigurationProducer.a(configurationContext);
        return virtualFile != null && FileUtil.pathsEqual((String)virtualFile.getPath(), (String)jarApplicationConfiguration.getJarPath());
    }
}

