/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewRunningState;
import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.protocol.CodeSnippet;
import com.intellij.execution.jshell.protocol.Endpoint;
import com.intellij.execution.jshell.protocol.Event;
import com.intellij.execution.jshell.protocol.Message;
import com.intellij.execution.jshell.protocol.MessageReader;
import com.intellij.execution.jshell.protocol.MessageWriter;
import com.intellij.execution.jshell.protocol.Request;
import com.intellij.execution.jshell.protocol.Response;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class JShellHandler {
    private static final Logger g = Logger.getInstance((String)"#com.intellij.execution.jshell.JShellHandler");
    private static final int a = -1;
    public static final Key<JShellHandler> MARKER_KEY = Key.create((String)"JShell console key");
    private static final Charset j = StandardCharsets.UTF_8;
    private static final Executor e = DefaultRunExecutor.getRunExecutorInstance();
    private static final String c = "jshell-frontend.jar";
    private final Project k;
    private final RunContentDescriptor b;
    private final ConsoleViewImpl m;
    private final OSProcessHandler d;
    private final MessageReader<Response> i;
    private final MessageWriter<Request> f;
    private final ExecutorService l;
    private final AtomicReference<Collection<String>> h;

    private JShellHandler(@NotNull Project project2, RunContentDescriptor runContentDescriptor, ConsoleViewImpl consoleViewImpl, final VirtualFile virtualFile, OSProcessHandler oSProcessHandler) throws Exception {
        if (project2 == null) {
            JShellHandler.a(0);
        }
        this.l = new SequentialTaskExecutor("JShell Command Queue", (java.util.concurrent.Executor)PooledThreadExecutor.INSTANCE);
        this.h = new AtomicReference<Object>(null);
        this.k = project2;
        this.b = runContentDescriptor;
        this.m = consoleViewImpl;
        this.d = oSProcessHandler;
        PipedInputStream pipedInputStream = new PipedInputStream();
        final OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new PipedOutputStream(pipedInputStream));
        this.i = new MessageReader((InputStream)pipedInputStream, Response.class);
        this.f = new MessageWriter(oSProcessHandler.getProcessInput(), Request.class);
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent processEvent, @NotNull Key key) {
                if (processEvent == null) {
                    1.a(0);
                }
                if (key == null) {
                    1.a(1);
                }
                if (key == ProcessOutputTypes.STDOUT) {
                    try {
                        outputStreamWriter.write(processEvent.getText());
                        outputStreamWriter.flush();
                    }
                    catch (IOException iOException) {
                        g.info((Throwable)iOException);
                    }
                } else {
                    JShellHandler.this.m.print(processEvent.getText(), key == ProcessOutputTypes.STDERR ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }

            public void processTerminated(@NotNull ProcessEvent processEvent) {
                if (processEvent == null) {
                    1.a(2);
                }
                if (JShellHandler.getAssociatedHandler(virtualFile) == JShellHandler.this) {
                    virtualFile.putUserData(MARKER_KEY, null);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/jshell/JShellHandler$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        project2.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile virtualFile2) {
                if (fileEditorManager == null) {
                    2.a(0);
                }
                if (virtualFile2 == null) {
                    2.a(1);
                }
                if (virtualFile2.equals(virtualFile)) {
                    JShellHandler.this.stop();
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/jshell/JShellHandler$2";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        virtualFile.putUserData(MARKER_KEY, (Object)this);
        consoleViewImpl.attachToProcess((ProcessHandler)oSProcessHandler);
    }

    @Nullable
    public static JShellHandler getAssociatedHandler(VirtualFile virtualFile) {
        return virtualFile != null ? (JShellHandler)virtualFile.getUserData(MARKER_KEY) : null;
    }

    public static JShellHandler create(@NotNull Project project2, @NotNull VirtualFile virtualFile, @Nullable Module module2, @Nullable Sdk sdk) throws Exception {
        if (project2 == null) {
            JShellHandler.a(1);
        }
        if (virtualFile == null) {
            JShellHandler.a(2);
        }
        final OSProcessHandler oSProcessHandler = JShellHandler.a(project2, module2, sdk);
        String string = "JShell " + virtualFile.getNameWithoutExtension();
        MyConsoleView myConsoleView = new MyConsoleView(project2);
        RunContentDescriptor runContentDescriptor = new RunContentDescriptor((ExecutionConsole)myConsoleView, (ProcessHandler)oSProcessHandler, (JComponent)new JPanel(new BorderLayout()), string);
        final JShellHandler jShellHandler = new JShellHandler(project2, runContentDescriptor, myConsoleView, virtualFile, oSProcessHandler);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Computable computable = module2 != null ? () -> ModuleRootManager.getInstance((Module)module2).orderEntries() : () -> {
            if (project2 == null) {
                JShellHandler.a(6);
            }
            return ProjectRootManager.getInstance((Project)project2).orderEntries();
        };
        ApplicationManager.getApplication().runReadAction(() -> linkedHashSet.addAll(((OrderEnumerator)computable.compute()).librariesOnly().recursively().withoutSdk().getPathsList().getPathList()));
        if (!linkedHashSet.isEmpty()) {
            jShellHandler.h.set(linkedHashSet);
        }
        JComponent jComponent = myConsoleView.getComponent();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.addAll(myConsoleView.createConsoleActions());
        defaultActionGroup.add((AnAction)new CloseAction(e, runContentDescriptor, project2){

            public void actionPerformed(AnActionEvent anActionEvent) {
                jShellHandler.stop();
                if (!oSProcessHandler.waitFor(10000L)) {
                    oSProcessHandler.destroyProcess();
                }
                super.actionPerformed(anActionEvent);
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)defaultActionGroup, false);
        actionToolbar.setTargetComponent(jComponent);
        JComponent jComponent2 = runContentDescriptor.getComponent();
        jComponent2.add((Component)jComponent, "Center");
        jComponent2.add((Component)actionToolbar.getComponent(), "West");
        oSProcessHandler.startNotify();
        ExecutionManager.getInstance((Project)project2).getContentManager().showRunContent(e, runContentDescriptor);
        return jShellHandler;
    }

    private static OSProcessHandler a(@NotNull Project project2, @Nullable Module module2, @Nullable Sdk sdk) throws Exception {
        JavaSdkVersion javaSdkVersion;
        Sdk sdk2;
        if (project2 == null) {
            JShellHandler.a(3);
        }
        Sdk sdk3 = sdk != null ? sdk : (sdk2 = module2 != null ? ModuleRootManager.getInstance((Module)module2).getSdk() : ProjectRootManager.getInstance((Project)project2).getProjectSdk());
        if (sdk2 == null || !(sdk2.getSdkType() instanceof JavaSdkType)) {
            throw new ExecException((sdk2 != null ? "Expected Java SDK" : " SDK is not configured") + (module2 != null ? " for module " + module2.getName() : " for project " + project2.getName()));
        }
        JavaSdkType javaSdkType = (JavaSdkType)sdk2.getSdkType();
        String string = sdk2.getVersionString();
        JavaSdkVersion javaSdkVersion2 = javaSdkVersion = string == null ? null : JavaSdkVersion.fromVersionString((String)string);
        if (javaSdkVersion == null) {
            throw new ExecException("Cannot determine version for JDK " + sdk2.getName() + ". Please re-configure the JDK.");
        }
        if (!javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_9)) {
            throw new ExecException("JDK version is " + javaSdkVersion.getDescription() + ". JDK 9 or higher is needed to run JShell.");
        }
        String string2 = javaSdkType.getVMExecutablePath(sdk2);
        if (string2 == null) {
            throw new ExecException("Cannot determine path to VM executable for JDK " + sdk2.getName() + ". Please re-configure the JDK.");
        }
        File file = new File(string2);
        String string3 = JShellHandler.b();
        if (string3 == null) {
            throw new ExecException("Library jshell-frontend.jar not found in IDE classpath");
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(file.getAbsolutePath());
        generalCommandLine.setWorkDirectory(file.getParent());
        generalCommandLine.setCharset(j);
        generalCommandLine.addParameter("--add-modules");
        generalCommandLine.addParameter("java.xml.bind");
        StringBuilder stringBuilder = new StringBuilder().append(string3);
        String string4 = JShellHandler.a(Endpoint.class);
        if (string4 != null) {
            stringBuilder.append(File.pathSeparator).append(string4);
        }
        if (stringBuilder.length() > 0) {
            generalCommandLine.addParameter("-classpath");
            generalCommandLine.addParameter(stringBuilder.toString());
        }
        generalCommandLine.addParameter("com.intellij.execution.jshell.frontend.Main");
        OSProcessHandler oSProcessHandler = new OSProcessHandler(generalCommandLine);
        return oSProcessHandler;
    }

    private static String b() {
        String string = PathManager.getResourceRoot((ClassLoader)JShellHandler.class.getClassLoader(), (String)"/com/intellij/execution/jshell/frontend/Marker.class");
        return string != null ? string : c;
    }

    private static String a(Class<?> clazz) {
        return PathManager.getResourceRoot(clazz, (String)("/" + clazz.getName().replace('.', '/') + ".class"));
    }

    public void stop() {
        this.d.destroyProcess();
        ExecutionManager.getInstance((Project)this.k).getContentManager().removeRunContent(e, this.b);
    }

    public void toFront() {
        ExecutionManager.getInstance((Project)this.k).getContentManager().toFrontRunContent(e, this.b);
    }

    @Nullable
    public Future<Response> evaluate(@NotNull String string) {
        if (string == null) {
            JShellHandler.a(4);
        }
        return StringUtil.isEmptyOrSpaces((String)string) ? null : this.l.submit(() -> {
            if (string == null) {
                JShellHandler.a(5);
            }
            return this.a(new Request(JShellHandler.a(), Request.Command.EVAL, string));
        });
    }

    public void dropState() {
        this.l.submit(() -> this.a(new Request(JShellHandler.a(), Request.Command.DROP_STATE, null)));
    }

    private static String a() {
        return UUID.randomUUID().toString();
    }

    @Nullable
    private Response a(Request request) {
        boolean bl2;
        boolean bl3 = bl2 = !this.d.isProcessTerminating() && !this.d.isProcessTerminated();
        if (bl2) {
            Collection collection = this.h.getAndSet(null);
            if (collection != null) {
                for (String string2 : collection) {
                    request.addClasspathItem(string2);
                }
            }
            this.m.performWhenNoDeferredOutput(() -> {
                try {
                    this.f.send((Message)request);
                }
                catch (IOException iOException) {
                    g.info((Throwable)iOException);
                }
            });
            try {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                string2 = (Response)this.i.receive(string -> stringBuffer.append((String)string));
                this.a(request, (Response)string2, stringBuffer.toString());
                return string2;
            }
            catch (IOException iOException) {
                g.info((Throwable)iOException);
            }
        }
        return null;
    }

    private void a(Request request, Response response, String string) {
        List list2 = response.getEvents();
        if (list2 != null) {
            if (request.getCommand() == Request.Command.DROP_STATE) {
                int n2 = 0;
                for (Event event : list2) {
                    CodeSnippet.Status status = event.getPreviousStatus();
                    CodeSnippet.Status status2 = event.getStatus();
                    if (event.getSnippet() == null || status == status2 || status2 != CodeSnippet.Status.DROPPED) continue;
                    ++n2;
                }
                JShellDiagnostic.notifyInfo("Dropped " + n2 + " code snippets", this.k);
            } else {
                for (Event event : list2) {
                    CodeSnippet codeSnippet;
                    String string2;
                    String string3;
                    String string4;
                    if (event.getCauseSnippet() != null) continue;
                    String string5 = event.getExceptionText();
                    if (!StringUtil.isEmptyOrSpaces((String)string5)) {
                        this.m.print("\n" + string5, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(string4 = event.getDiagnostic()))) {
                        this.m.print("\n" + string4, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(string3 = JShellHandler.a(event)))) {
                        this.m.print("\n" + string3, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if ((string2 = (codeSnippet = event.getSnippet()) != null && !codeSnippet.getSubKind().hasValue() ? null : event.getValue()) == null) continue;
                    this.m.print(" = " + (string2.isEmpty() ? "\"\"" : string2), ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }
        }
        if (!StringUtil.isEmpty((String)string)) {
            this.m.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            if (!"\n".equals(string)) {
                this.m.print(string, ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }
    }

    private static String a(Event event) {
        CodeSnippet codeSnippet = event.getSnippet();
        if (event.getCauseSnippet() != null || codeSnippet == null) {
            return "";
        }
        CodeSnippet.Status status = event.getStatus();
        CodeSnippet.Kind kind = codeSnippet.getKind();
        CodeSnippet.SubKind subKind = codeSnippet.getSubKind();
        String string = codeSnippet.getPresentation();
        if (string == null || subKind == CodeSnippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND) {
            string = StringUtil.trim((String)codeSnippet.getCodeText());
        }
        String string2 = event.getPreviousStatus() == CodeSnippet.Status.NONEXISTENT && status.isDefined() ? (subKind == CodeSnippet.SubKind.VAR_DECLARATION_WITH_INITIALIZER_SUBKIND || !subKind.isExecutable() ? "Defined" : "") : (status == CodeSnippet.Status.REJECTED ? "Rejected" : (status == CodeSnippet.Status.DROPPED ? "Dropped" : (status == CodeSnippet.Status.OVERWRITTEN ? "Overwritten" : "")));
        String string3 = kind == CodeSnippet.Kind.TYPE_DECL ? (subKind == CodeSnippet.SubKind.INTERFACE_SUBKIND ? "interface" : (subKind == CodeSnippet.SubKind.ENUM_SUBKIND ? "enum" : (subKind == CodeSnippet.SubKind.ANNOTATION_TYPE_SUBKIND ? "annotation" : "class"))) : (kind == CodeSnippet.Kind.VAR ? (subKind == CodeSnippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND ? "" : "field") : (kind == CodeSnippet.Kind.METHOD ? "method" : (kind == CodeSnippet.Kind.IMPORT ? (subKind == CodeSnippet.SubKind.STATIC_IMPORT_ON_DEMAND_SUBKIND || subKind == CodeSnippet.SubKind.SINGLE_STATIC_IMPORT_SUBKIND ? "static import" : "import") : "")));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        if (!string2.isEmpty()) {
            stringBuilder.append(" ");
        }
        if (!string3.isEmpty()) {
            stringBuilder.append(string3).append(" ");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/jshell/JShellHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "launchProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$evaluate$3";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$create$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ExecException
    extends Exception {
        public ExecException(String string) {
            super(string);
        }

        public ExecException(String string, Throwable throwable) {
            super(string, throwable);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class MyConsoleView
    extends ConsoleViewImpl {
        public MyConsoleView(Project project2) {
            super(project2, GlobalSearchScope.allScope((Project)project2), true, (ConsoleState)new ConsoleState.NotStartedStated(){

                @NotNull
                public ConsoleState attachTo(@NotNull ConsoleViewImpl consoleViewImpl, ProcessHandler processHandler) {
                    if (consoleViewImpl == null) {
                        1.a(0);
                    }
                    ConsoleViewRunningState consoleViewRunningState = new ConsoleViewRunningState(consoleViewImpl, processHandler, (ConsoleState)this, false, false);
                    if (consoleViewRunningState == null) {
                        1.a(1);
                    }
                    return consoleViewRunningState;
                }

                private static /* synthetic */ void a(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "console";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/jshell/JShellHandler$MyConsoleView$1";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/jshell/JShellHandler$MyConsoleView$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "attachTo";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "attachTo";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, true);
        }
    }
}

