/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitRecognizer;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitUtil {
    public static final String TEST_CASE_CLASS = "junit.framework.TestCase";
    private static final String i = "junit.framework.Test";
    private static final String b = "junit.framework.TestSuite";
    public static final String TEST_ANNOTATION = "org.junit.Test";
    public static final String TEST5_PACKAGE_FQN = "org.junit.jupiter.api";
    public static final String TEST5_ANNOTATION = "org.junit.jupiter.api.Test";
    public static final String CUSTOM_TESTABLE_ANNOTATION = "org.junit.platform.commons.annotation.Testable";
    public static final String TEST5_FACTORY_ANNOTATION = "org.junit.jupiter.api.TestFactory";
    public static final String IGNORE_ANNOTATION = "org.junit.Ignore";
    public static final String RUN_WITH = "org.junit.runner.RunWith";
    public static final String DATA_POINT = "org.junit.experimental.theories.DataPoint";
    public static final String SUITE_METHOD_NAME = "suite";
    public static final String BEFORE_ANNOTATION_NAME = "org.junit.Before";
    public static final String AFTER_ANNOTATION_NAME = "org.junit.After";
    public static final String BEFORE_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeEach";
    public static final String AFTER_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.AfterEach";
    public static final String PARAMETRIZED_PARAMETERS_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameters";
    public static final String PARAMETRIZED_PARAMETER_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameter";
    public static final String AFTER_CLASS_ANNOTATION_NAME = "org.junit.AfterClass";
    public static final String BEFORE_CLASS_ANNOTATION_NAME = "org.junit.BeforeClass";
    public static final Collection<String> TEST5_CONFIG_METHODS = Collections.unmodifiableList(Arrays.asList("org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach"));
    public static final String BEFORE_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeAll";
    public static final String AFTER_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.AfterAll";
    public static final Collection<String> TEST5_STATIC_CONFIG_METHODS = Collections.unmodifiableList(Arrays.asList("org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"));
    public static final Collection<String> TEST5_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory", "org.junit.platform.commons.annotation.Testable"));
    public static final Collection<String> TEST5_JUPITER_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory"));
    private static final List<String> e = Arrays.asList("org.junit.Before", "org.junit.After");
    private static final List<String> h = Arrays.asList("org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach");
    private static final List<String> g = Arrays.asList("org.junit.BeforeClass", "org.junit.AfterClass", "org.junit.runners.Parameterized.Parameters");
    private static final List<String> a = Arrays.asList("org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll");
    private static final Collection<String> d = Collections.unmodifiableList(Arrays.asList("org.junit.experimental.theories.DataPoint", "org.junit.After", "org.junit.Before", "org.junit.AfterClass", "org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"));
    public static final String PARAMETERIZED_CLASS_NAME = "org.junit.runners.Parameterized";
    public static final String SUITE_CLASS_NAME = "org.junit.runners.Suite";
    public static final String JUNIT5_NESTED = "org.junit.jupiter.api.Nested";
    private static final String[] c = new String[]{"org.junit.runners.Parameterized", "org.junit.runners.BlockJUnit4ClassRunner", "org.junit.runners.JUnit4", "org.junit.internal.runners.JUnit38ClassRunner", "org.junit.internal.runners.JUnit4ClassRunner", "org.junit.runners.Suite"};
    private static final String[] f = new String[]{"org.junit.runners.Parameterized", "org.junit.runners.BlockJUnit4ClassRunner", "org.junit.runners.JUnit4", "org.junit.internal.runners.JUnit4ClassRunner"};

    public static boolean isSuiteMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JUnitUtil.a(0);
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.getParameterList().isEmpty()) {
            return false;
        }
        PsiType psiType = psiMethod.getReturnType();
        if (psiType == null || psiType instanceof PsiPrimitiveType) {
            return false;
        }
        return psiType.equalsToText(i) || psiType.equalsToText(b) || InheritanceUtil.isInheritor((PsiType)psiType, (String)i);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location) {
        return JUnitUtil.isTestMethod(location, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean bl2) {
        return JUnitUtil.isTestMethod(location, bl2, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean bl2, boolean bl3) {
        return JUnitUtil.isTestMethod(location, bl2, bl3, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean bl2, boolean bl3, boolean bl4) {
        PsiAnnotation psiAnnotation;
        PsiClass psiClass;
        PsiMethod psiMethod = (PsiMethod)location.getPsiElement();
        PsiClass psiClass2 = psiClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : psiMethod.getContainingClass();
        if (bl4 && (psiClass == null || !JUnitUtil.isTestClass(psiClass, bl2, true))) {
            return false;
        }
        if (JUnitUtil.isTestAnnotated(psiMethod, false)) {
            return !psiMethod.hasModifierProperty("static");
        }
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, Collections.singletonList(CUSTOM_TESTABLE_ANNOTATION))) {
            return true;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (psiMethod.hasModifierProperty("abstract")) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, d, (int)0)) {
            return false;
        }
        if (bl4 && bl3 && (psiAnnotation = JUnitUtil.getRunWithAnnotation(psiClass)) != null) {
            return !JUnitUtil.isInheritorOrSelfRunner(psiAnnotation, f);
        }
        if (!psiMethod.getParameterList().isEmpty()) {
            return false;
        }
        if (psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!psiMethod.getName().startsWith("test")) {
            return false;
        }
        if (bl4 && ((psiAnnotation = JUnitUtil.a(location)) == null || !psiMethod.getContainingClass().isInheritor((PsiClass)psiAnnotation, true))) {
            return false;
        }
        return PsiType.VOID.equals((Object)psiMethod.getReturnType());
    }

    public static boolean isTestCaseInheritor(PsiClass psiClass) {
        if (!psiClass.isValid()) {
            return false;
        }
        Location location = PsiLocation.fromPsiElement((PsiElement)psiClass);
        PsiClass psiClass2 = JUnitUtil.a(location);
        return psiClass2 != null && psiClass.isInheritor(psiClass2, true);
    }

    public static boolean isTestClass(PsiClass psiClass) {
        return JUnitUtil.isTestClass(psiClass, true, true);
    }

    public static boolean isTestClass(@NotNull PsiClass psiClass, boolean bl2, boolean bl3) {
        PsiAnnotation psiAnnotation;
        if (psiClass == null) {
            JUnitUtil.a(1);
        }
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        if (JUnitUtil.isJUnit5((PsiElement)psiClass) && JUnitUtil.isJUnit5TestClass(psiClass, bl2)) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)bl2)) {
            return false;
        }
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
        if (psiClass2 != null && (psiAnnotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClass2, Collections.singleton(RUN_WITH))) != null && !JUnitUtil.isInheritorOrSelfRunner(psiAnnotation, c)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (int)1)) {
            return true;
        }
        if (bl3 && JUnitUtil.isTestCaseInheritor(psiClass)) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                JUnitUtil.a(8);
            }
            return CachedValueProvider.Result.create((Object)JUnitUtil.c(psiClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static boolean c(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JUnitUtil.a(2);
        }
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (JUnitUtil.isSuiteMethod(psiMethod)) {
                return true;
            }
            if (!JUnitUtil.isTestAnnotated(psiMethod)) continue;
            return true;
        }
        if (JUnitUtil.isJUnit5((PsiElement)psiClass)) {
            for (PsiMethod psiMethod : psiClass.getInnerClasses()) {
                for (PsiMethod psiMethod2 : psiMethod.getAllMethods()) {
                    if (!JUnitUtil.isTestAnnotated(psiMethod2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isJUnit3TestClass(PsiClass psiClass) {
        return JUnitUtil.isTestCaseInheritor(psiClass);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass) {
        return JUnitUtil.isJUnit4TestClass(psiClass, true);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass, boolean bl2) {
        PsiModifierList psiModifierList = psiClass.getModifierList();
        if (psiModifierList == null) {
            return false;
        }
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiModifierList, PsiClass.class);
        if (psiClass2 != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass2, (String)RUN_WITH, (int)1)) {
            PsiMethod[] psiMethodArray = JUnitUtil.getRunWithAnnotation(psiClass2);
            if (psiClass2 == psiClass) {
                return true;
            }
            if (psiMethodArray != null && !JUnitUtil.isInheritorOrSelfRunner((PsiAnnotation)psiMethodArray, c)) {
                return true;
            }
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)bl2)) {
            return false;
        }
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            ProgressManager.checkCanceled();
            if (!JUnitUtil.isTestAnnotated(psiMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJUnit5TestClass(@NotNull PsiClass psiClass, boolean bl2) {
        PsiModifierList psiModifierList;
        if (psiClass == null) {
            JUnitUtil.a(3);
        }
        if ((psiModifierList = psiClass.getModifierList()) == null) {
            return false;
        }
        if (psiClass.getContainingClass() != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)JUNIT5_NESTED, (int)0)) {
            return true;
        }
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiClass, Collections.singleton(CUSTOM_TESTABLE_ANNOTATION))) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)false, (boolean)bl2)) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module2 != null) {
            return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
                if (psiClass == null) {
                    JUnitUtil.a(7);
                }
                boolean bl2 = false;
                for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                    ProgressManager.checkCanceled();
                    if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, TEST5_ANNOTATIONS)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    for (PsiMethod psiMethod : psiClass.getAllInnerClasses()) {
                        if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, Collections.singleton(JUNIT5_NESTED))) continue;
                        bl2 = true;
                        break;
                    }
                }
                return CachedValueProvider.Result.create((Object)bl2, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            });
        }
        return false;
    }

    public static boolean isJUnit5(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JUnitUtil.a(4);
        }
        return JUnitUtil.isJUnit5(psiElement.getResolveScope(), psiElement.getProject());
    }

    public static boolean isJUnit5(GlobalSearchScope globalSearchScope, Project project2) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
        Condition condition = string -> {
            PsiPackage psiPackage = javaPsiFacade.findPackage(string);
            return psiPackage != null && psiPackage.getDirectories(globalSearchScope).length > 0;
        };
        return (Boolean)ReadAction.compute(() -> condition.value((Object)TEST5_PACKAGE_FQN));
    }

    public static boolean isTestAnnotated(PsiMethod psiMethod) {
        return JUnitUtil.isTestAnnotated(psiMethod, true);
    }

    public static boolean isTestAnnotated(PsiMethod psiMethod, boolean bl2) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)TEST_ANNOTATION, (int)0) || JUnitRecognizer.willBeAnnotatedAfterCompilation((PsiMethod)psiMethod)) {
            return true;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, bl2 ? TEST5_ANNOTATIONS : TEST5_JUPITER_ANNOTATIONS);
    }

    @Nullable
    private static PsiClass a(Location<?> location) {
        Location location2 = location.getAncestorOrSelf(PsiClass.class);
        if (location2 == null) {
            return null;
        }
        PsiClass psiClass = (PsiClass)location2.getPsiElement();
        Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
        if (module2 == null) {
            return null;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module2, (boolean)true);
        return JUnitUtil.b(globalSearchScope, module2.getProject());
    }

    public static PsiClass getTestCaseClass(Module module2) throws NoJUnitException {
        if (module2 == null) {
            throw new NoJUnitException();
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module2, (boolean)true);
        return JUnitUtil.a(globalSearchScope, module2.getProject());
    }

    public static PsiClass getTestCaseClass(SourceScope sourceScope) throws NoJUnitException {
        if (sourceScope == null) {
            throw new NoJUnitException();
        }
        return JUnitUtil.a(sourceScope.getLibrariesScope(), sourceScope.getProject());
    }

    public static void checkTestCase(SourceScope sourceScope, Project project2) throws NoJUnitException {
        if (sourceScope == null) {
            throw new NoJUnitException();
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project2).findPackage("junit.framework");
        if (psiPackage == null || psiPackage.getDirectories(sourceScope.getLibrariesScope()).length == 0) {
            throw new NoJUnitException();
        }
    }

    private static PsiClass a(GlobalSearchScope globalSearchScope, Project project2) throws NoJUnitException {
        PsiClass psiClass = JUnitUtil.b(globalSearchScope, project2);
        if (psiClass == null) {
            throw new NoJUnitException(globalSearchScope.getDisplayName());
        }
        return psiClass;
    }

    @Nullable
    private static PsiClass b(GlobalSearchScope globalSearchScope, Project project2) {
        return JavaPsiFacade.getInstance((Project)project2).findClass(TEST_CASE_CLASS, globalSearchScope);
    }

    public static boolean isTestMethodOrConfig(@NotNull PsiMethod psiMethod) {
        Object object;
        PsiClass psiClass;
        if (psiMethod == null) {
            JUnitUtil.a(5);
        }
        if ((psiClass = psiMethod.getContainingClass()) == null) {
            return false;
        }
        if (JUnitUtil.isTestMethod((Location<? extends PsiMethod>)PsiLocation.fromPsiElement((PsiElement)psiMethod), false)) {
            if (psiClass.hasModifierProperty("abstract")) {
                object = new boolean[1];
                ClassInheritorsSearch.search((PsiClass)psiClass).forEach(arg_0 -> JUnitUtil.a((boolean[])object, arg_0));
                if (object[0] != false) {
                    return true;
                }
            } else {
                return true;
            }
        }
        object = psiMethod.getName();
        boolean bl2 = psiMethod.hasModifierProperty("public");
        if (!psiMethod.hasModifierProperty("abstract")) {
            if (bl2 && (SUITE_METHOD_NAME.equals(object) || "setUp".equals(object) || "tearDown".equals(object))) {
                return true;
            }
            if (psiMethod.hasModifierProperty("static")) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, g, (int)0)) {
                    return bl2;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, a, (int)0)) {
                    return true;
                }
            } else {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, e, (int)0)) {
                    return bl2;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, h, (int)0)) {
                    return true;
                }
                if (TestUtils.testInstancePerClass((PsiClass)psiClass) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, a, (int)0)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod findFirstTestMethod(PsiClass psiClass) {
        PsiMethod psiMethod = null;
        for (PsiMethod psiMethod2 : psiClass.getMethods()) {
            if (!JUnitUtil.isTestMethod(MethodLocation.elementInClass(psiMethod2, psiClass)) && !JUnitUtil.isSuiteMethod(psiMethod2)) continue;
            psiMethod = psiMethod2;
            break;
        }
        return psiMethod;
    }

    @Nullable
    public static PsiMethod findSuiteMethod(PsiClass psiClass) {
        PsiMethod[] psiMethodArray;
        for (PsiMethod psiMethod : psiMethodArray = psiClass.findMethodsByName(SUITE_METHOD_NAME, false)) {
            if (!JUnitUtil.isSuiteMethod(psiMethod)) continue;
            return psiMethod;
        }
        return null;
    }

    public static PsiAnnotation getRunWithAnnotation(PsiClass psiClass) {
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton(RUN_WITH));
    }

    public static boolean isParameterized(PsiAnnotation psiAnnotation) {
        return JUnitUtil.isInheritorOrSelfRunner(psiAnnotation, PARAMETERIZED_CLASS_NAME);
    }

    public static boolean isInheritorOrSelfRunner(PsiAnnotation psiAnnotation, String ... stringArray) {
        PsiAnnotationMemberValue psiAnnotationMemberValue = psiAnnotation.findAttributeValue("value");
        if (psiAnnotationMemberValue instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement psiTypeElement = ((PsiClassObjectAccessExpression)psiAnnotationMemberValue).getOperand();
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiTypeElement.getType());
            return psiClass != null && Arrays.stream(stringArray).anyMatch(string -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)string));
        }
        return false;
    }

    public static PsiClass findPsiClass(String string, Module module2, Project project2) {
        GlobalSearchScope globalSearchScope = module2 == null ? GlobalSearchScope.projectScope((Project)project2) : GlobalSearchScope.moduleWithDependenciesScope((Module)module2);
        return JavaPsiFacade.getInstance((Project)project2).findClass(string, globalSearchScope);
    }

    public static PsiPackage getContainingPackage(@NotNull PsiClass psiClass) {
        PsiDirectory psiDirectory;
        if (psiClass == null) {
            JUnitUtil.a(6);
        }
        return (psiDirectory = psiClass.getContainingFile().getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(psiDirectory);
    }

    public static PsiClass getTestClass(PsiElement psiElement) {
        return JUnitUtil.getTestClass(PsiLocation.fromPsiElement((PsiElement)psiElement));
    }

    public static PsiClass getTestClass(Location<?> location) {
        PsiClass[] psiClassArray;
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            psiClassArray = (PsiClass[])iterator.next();
            if (!JUnitUtil.isTestClass((PsiClass)psiClassArray.getPsiElement(), false, true)) continue;
            return (PsiClass)psiClassArray.getPsiElement();
        }
        iterator = location.getPsiElement();
        if (iterator instanceof PsiClassOwner && (psiClassArray = ((PsiClassOwner)iterator).getClasses()).length == 1 && JUnitUtil.isTestClass(psiClassArray[0], false, true)) {
            return psiClassArray[0];
        }
        return null;
    }

    public static PsiMethod getTestMethod(PsiElement psiElement) {
        return JUnitUtil.getTestMethod(psiElement, true);
    }

    public static PsiMethod getTestMethod(PsiElement psiElement, boolean bl2) {
        return JUnitUtil.getTestMethod(psiElement, bl2, true);
    }

    public static PsiMethod getTestMethod(PsiElement psiElement, boolean bl2, boolean bl3) {
        PsiManager psiManager = psiElement.getManager();
        Location location = PsiLocation.fromPsiElement((Project)psiManager.getProject(), (PsiElement)psiElement);
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location location2 = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location<? extends PsiMethod>)location2, bl2, bl3)) continue;
            return (PsiMethod)location2.getPsiElement();
        }
        return null;
    }

    private static /* synthetic */ boolean a(boolean[] blArray, PsiClass psiClass) {
        if (!psiClass.hasModifierProperty("abstract")) {
            blArray[0] = true;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/JUnitUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuiteMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTestOrSuiteMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit5TestClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit5";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestMethodOrConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingPackage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isJUnit5TestClass$1";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isTestClass$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NoJUnitException
    extends CantRunException {
        public NoJUnitException() {
            super(ExecutionBundle.message((String)"no.junit.error.message", (Object[])new Object[0]));
        }

        public NoJUnitException(String string) {
            super(ExecutionBundle.message((String)"no.junit.in.scope.error.message", (Object[])new Object[]{string}));
        }
    }

    public static class TestMethodFilter
    implements Condition<PsiMethod> {
        private final PsiClass b;
        private final JavaTestFramework a;

        public TestMethodFilter(PsiClass psiClass) {
            this.b = psiClass;
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
            this.a = testFramework instanceof JavaTestFramework ? (JavaTestFramework)testFramework : null;
        }

        public boolean value(PsiMethod psiMethod) {
            return this.a != null ? this.a.isTestMethod(psiMethod, this.b) : JUnitUtil.isTestMethod(MethodLocation.elementInClass(psiMethod, this.b));
        }
    }
}

