/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.Nullable;

public abstract class JavaRunConfigurationProducerBase<T extends ModuleBasedConfiguration>
extends RunConfigurationProducer<T> {
    protected JavaRunConfigurationProducerBase(ConfigurationFactory configurationFactory) {
        super(configurationFactory);
    }

    protected JavaRunConfigurationProducerBase(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationModule(@Nullable ConfigurationContext configurationContext, T t2) {
        if (configurationContext != null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationContext.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
            Module module2 = configurationContext.getModule();
            Module module3 = ((ModuleBasedConfiguration)runnerAndConfigurationSettings.getConfiguration()).getConfigurationModule().getModule();
            if (module3 != null) {
                t2.setModule(module3);
                return true;
            }
            Module module4 = this.findModule(t2, module2);
            if (module4 != null) {
                t2.setModule(module4);
                return true;
            }
        }
        return false;
    }

    protected Module findModule(T t2, Module module2) {
        if (t2.getConfigurationModule().getModule() == null && module2 != null) {
            return module2;
        }
        return null;
    }

    protected TestSearchScope setupPackageConfiguration(ConfigurationContext configurationContext, T t2, TestSearchScope testSearchScope) {
        if (testSearchScope != TestSearchScope.WHOLE_PROJECT && !this.setupConfigurationModule(configurationContext, t2)) {
            return TestSearchScope.WHOLE_PROJECT;
        }
        return testSearchScope;
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(ConfigurationContext configurationContext) {
        ConfigurationFromContext configurationFromContext = super.createConfigurationFromContext(configurationContext);
        if (configurationFromContext != null) {
            JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configurationFromContext.getConfiguration(), configurationContext.getLocation());
        }
        return configurationFromContext;
    }
}

