/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringListeners {
    public static RefactoringElementListener getListener(PsiPackage psiPackage, Accessor<PsiPackage> accessor) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PsiPackage psiPackage2 = accessor.getPsiElement(); psiPackage2 != null; psiPackage2 = psiPackage2.getParentPackage()) {
            if (psiPackage2.equals(psiPackage)) {
                return new RefactorPackage(accessor, stringBuilder.toString());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, psiPackage2.getName());
        }
        return null;
    }

    public static RefactoringElementListener getListeners(PsiClass psiClass, Accessor<PsiClass> accessor) {
        PsiClass psiClass2 = accessor.getPsiElement();
        if (psiClass2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        PsiClass psiClass3 = psiClass2;
        while (psiClass3 != null) {
            if (psiClass3.equals(psiClass)) {
                return new RefactorClass(accessor, stringBuilder.toString());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '$');
            }
            stringBuilder.insert(0, psiClass3.getName());
            psiClass3 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass3, PsiClass.class, (boolean)true);
        }
        return null;
    }

    public static RefactoringElementListener getClassOrPackageListener(PsiElement psiElement, Accessor<PsiClass> accessor) {
        if (psiElement instanceof PsiClass) {
            return RefactoringListeners.getListeners((PsiClass)psiElement, accessor);
        }
        if (psiElement instanceof PsiPackage) {
            PsiClass psiClass = accessor.getPsiElement();
            if (psiClass == null) {
                return null;
            }
            return RefactoringListeners.getListener((PsiPackage)psiElement, new ClassPackageAccessor(accessor));
        }
        return null;
    }

    private static class ClassPackageAccessor
    implements Accessor<PsiPackage> {
        private final PsiPackage c;
        private final Module d;
        private final Accessor<PsiClass> b;
        private final String a;

        public ClassPackageAccessor(Accessor<PsiClass> accessor) {
            String string;
            String string2;
            this.b = accessor;
            PsiClass psiClass = this.b.getPsiElement();
            psiClass = (PsiClass)psiClass.getOriginalElement();
            this.c = JavaDirectoryService.getInstance().getPackage(psiClass.getContainingFile().getContainingDirectory());
            this.d = JavaExecutionUtil.findModule((PsiClass)psiClass);
            String string3 = psiClass.getQualifiedName();
            String string4 = string2 = this.c != null ? this.c.getQualifiedName() : null;
            this.a = string3 != null && string2 != null && string3.startsWith(string2) ? (StringUtil.startsWithChar((CharSequence)(string = string3.substring(string2.length())), (char)'.') ? string.substring(1) : string) : null;
        }

        @Override
        public PsiPackage getPsiElement() {
            return this.c;
        }

        @Override
        public void setPsiElement(PsiPackage psiPackage) {
            if (this.a == null) {
                return;
            }
            String string = this.a(psiPackage.getQualifiedName());
            PsiClass psiClass = JUnitUtil.findPsiClass(string, this.d, psiPackage.getProject());
            if (psiClass != null) {
                this.b.setPsiElement(psiClass);
            } else {
                this.b.setName(string);
            }
        }

        @Override
        public void setName(String string) {
            this.b.setName(this.a(string));
        }

        private String a(String string) {
            if (string.length() > 0) {
                return string + '.' + this.a;
            }
            return this.a;
        }
    }

    public static class RefactorPackageByClass
    extends RenameElement<PsiClass> {
        public RefactorPackageByClass(Accessor<PsiClass> accessor) {
            super(accessor, "*");
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String string) {
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(string.replace('$', '.').replace("\\*", psiClass.getName()), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            String string = psiClass.getQualifiedName();
            return string != null ? StringUtil.getPackageName((String)string) : null;
        }
    }

    private static class RefactorClass
    extends RenameElement<PsiClass> {
        public RefactorClass(Accessor<PsiClass> accessor, String string) {
            super(accessor, string);
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String string) {
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(string.replace('$', '.'), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            return psiClass.getQualifiedName();
        }
    }

    private static class RefactorPackage
    extends RenameElement<PsiPackage> {
        public RefactorPackage(Accessor<PsiPackage> accessor, String string) {
            super(accessor, string);
        }

        @Override
        public PsiPackage findNewElement(PsiPackage psiPackage, String string) {
            return JavaPsiFacade.getInstance((Project)psiPackage.getProject()).findPackage(string);
        }

        @Override
        public String getQualifiedName(PsiPackage psiPackage) {
            return psiPackage.getQualifiedName();
        }
    }

    private static abstract class RenameElement<T extends PsiElement>
    extends RefactoringElementAdapter
    implements UndoRefactoringElementListener {
        private final Accessor<T> a;
        private final String b;

        public RenameElement(Accessor<T> accessor, String string) {
            this.a = accessor;
            this.b = string;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                RenameElement.a(0);
            }
            PsiElement psiElement2 = psiElement;
            String string = this.getQualifiedName(psiElement2);
            if (this.b.length() > 0) {
                string = string + "." + this.b;
                psiElement2 = this.findNewElement(psiElement2, string);
            }
            if (psiElement2 != null) {
                this.a.setPsiElement(psiElement2);
            } else {
                this.a.setName(string);
            }
        }

        @Nullable
        protected abstract T findNewElement(T var1, String var2);

        protected abstract String getQualifiedName(T var1);

        public void undoElementMovedOrRenamed(@NotNull PsiElement psiElement, @NotNull String string) {
            if (psiElement == null) {
                RenameElement.a(1);
            }
            if (string == null) {
                RenameElement.a(2);
            }
            this.a.setName(string);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/junit/RefactoringListeners$RenameElement";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamedOrMoved";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "undoElementMovedOrRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SingleClassConfigurationAccessor
    implements Accessor<PsiClass> {
        private final SingleClassConfiguration a;

        public SingleClassConfigurationAccessor(SingleClassConfiguration singleClassConfiguration) {
            this.a = singleClassConfiguration;
        }

        @Override
        public PsiClass getPsiElement() {
            return this.a.getMainClass();
        }

        @Override
        public void setPsiElement(PsiClass psiClass) {
            this.a.setMainClass(psiClass);
        }

        @Override
        public void setName(String string) {
            this.a.setMainClassName(string);
        }
    }

    public static interface Accessor<T extends PsiElement> {
        public void setName(String var1);

        public T getPsiElement();

        public void setPsiElement(T var1);
    }
}

