/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteConfigurable
extends SettingsEditor<RemoteConfiguration> {
    JPanel myPanel;
    private JRadioButton a;
    private JRadioButton d;
    private JRadioButton n;
    private JRadioButton c;
    private JTextField g;
    private JTextField j;
    private IntegerField k;
    private JPanel e;
    private JPanel i;
    private ConfigurationArgumentsHelpArea l;
    private LabeledComponent<ModuleDescriptionsComboBox> b;
    private ComboBox<JDKVersionItem> m;
    private String h = "";
    @NonNls
    protected static final String LOCALHOST = "localhost";
    private final ConfigurationModuleSelector f;

    public RemoteConfigurable(Project project2) {
        this.a();
        this.l.setLabelText(null);
        this.l.setToolbarVisible();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.a);
        buttonGroup.add(this.d);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.n);
        buttonGroup2.add(this.c);
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            public void textChanged(DocumentEvent documentEvent) {
                RemoteConfigurable.this.c();
            }
        };
        this.g.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.j.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.k.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.a.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object.equals(RemoteConfigurable.this.a)) {
                    RemoteConfigurable.this.e.setVisible(false);
                    RemoteConfigurable.this.i.setVisible(true);
                } else if (object.equals(RemoteConfigurable.this.d)) {
                    RemoteConfigurable.this.e.setVisible(true);
                    RemoteConfigurable.this.i.setVisible(false);
                }
                RemoteConfigurable.this.myPanel.repaint();
                RemoteConfigurable.this.c();
            }
        };
        this.d.addActionListener(actionListener);
        this.a.addActionListener(actionListener);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl2 = RemoteConfigurable.this.c.isSelected();
                if (!bl2 && RemoteConfigurable.this.j.isEditable()) {
                    RemoteConfigurable.this.h = RemoteConfigurable.this.j.getText();
                }
                RemoteConfigurable.this.j.setEditable(bl2);
                RemoteConfigurable.this.j.setEnabled(bl2);
                RemoteConfigurable.this.j.setText(bl2 ? RemoteConfigurable.this.h : RemoteConfigurable.LOCALHOST);
                RemoteConfigurable.this.c();
            }
        };
        this.c.addItemListener(itemListener);
        this.n.addItemListener(itemListener);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                RemoteConfigurable.this.c();
            }
        };
        this.g.addFocusListener(focusAdapter);
        this.k.addFocusListener((FocusListener)focusAdapter);
        ((ModuleDescriptionsComboBox)this.b.getComponent()).allowEmptySelection("<whole project>");
        this.f = new ConfigurationModuleSelector(project2, (ModuleDescriptionsComboBox)this.b.getComponent());
        JavaSdkVersion javaSdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)ProjectRootManager.getInstance((Project)project2).getProjectSdk());
        boolean bl2 = false;
        for (JDKVersionItem jDKVersionItem : JDKVersionItem.values()) {
            this.m.addItem((Object)jDKVersionItem);
            if (bl2 || javaSdkVersion == null || !javaSdkVersion.isAtLeast(jDKVersionItem.a)) continue;
            this.m.setSelectedItem((Object)jDKVersionItem);
            bl2 = true;
        }
        this.m.addItemListener(itemEvent -> this.c());
    }

    public void applyEditorTo(@NotNull RemoteConfiguration remoteConfiguration) throws ConfigurationException {
        if (remoteConfiguration == null) {
            RemoteConfigurable.a(0);
        }
        remoteConfiguration.HOST = (this.j.isEditable() ? this.j.getText() : this.h).trim();
        if (remoteConfiguration.HOST != null && remoteConfiguration.HOST.isEmpty()) {
            remoteConfiguration.HOST = null;
        }
        remoteConfiguration.PORT = this.k.getText().trim();
        if (remoteConfiguration.PORT != null && remoteConfiguration.PORT.isEmpty()) {
            remoteConfiguration.PORT = null;
        }
        remoteConfiguration.SHMEM_ADDRESS = this.g.getText().trim();
        if (remoteConfiguration.SHMEM_ADDRESS != null && remoteConfiguration.SHMEM_ADDRESS.isEmpty()) {
            remoteConfiguration.SHMEM_ADDRESS = null;
        }
        remoteConfiguration.USE_SOCKET_TRANSPORT = this.a.isSelected();
        if (remoteConfiguration.USE_SOCKET_TRANSPORT) {
            this.k.validateContent();
        }
        remoteConfiguration.SERVER_MODE = this.n.isSelected();
        this.f.applyTo(remoteConfiguration);
    }

    public void resetEditorFrom(@NotNull RemoteConfiguration remoteConfiguration) {
        if (remoteConfiguration == null) {
            RemoteConfigurable.a(1);
        }
        if (!SystemInfo.isWindows) {
            remoteConfiguration.USE_SOCKET_TRANSPORT = true;
            this.d.setEnabled(false);
            this.g.setEditable(false);
        }
        this.g.setText(remoteConfiguration.SHMEM_ADDRESS);
        this.h = remoteConfiguration.HOST;
        this.j.setText(remoteConfiguration.HOST);
        this.k.setText(remoteConfiguration.PORT);
        if (remoteConfiguration.USE_SOCKET_TRANSPORT) {
            this.a.doClick();
        } else {
            this.d.doClick();
        }
        if (remoteConfiguration.SERVER_MODE) {
            this.n.doClick();
        } else {
            this.c.doClick();
        }
        this.d.setEnabled(SystemInfo.isWindows);
        this.f.reset(remoteConfiguration);
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            RemoteConfigurable.a(2);
        }
        return jPanel;
    }

    private void c() {
        boolean bl2 = !this.d.isSelected();
        RemoteConnection remoteConnection = new RemoteConnection(bl2, this.h, bl2 ? this.k.getText().trim() : this.g.getText().trim(), this.n.isSelected());
        this.l.updateText(((JDKVersionItem)((Object)this.m.getSelectedItem())).getLaunchCommandLine(remoteConnection));
    }

    private void b() {
        this.k = new IntegerField("Port", 0, 65535);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void a() {
        ComboBox comboBox;
        LabeledComponent labeledComponent;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.b();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.settings.border"), (int)0, (int)0, null, null));
        this.i = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.j = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.host.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.a(jLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.port.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField = this.k;
        jPanel2.add((Component)integerField, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, new Dimension(150, -1), null));
        this.e = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.a(jLabel3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.address.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.g = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.a(jLabel4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.transport.label"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.a = jRadioButton4 = new JRadioButton();
        this.a(jRadioButton4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.socket.radio"));
        jPanel4.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.d = jRadioButton3 = new JRadioButton();
        this.a(jRadioButton3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.radio"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.a(jLabel5, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.debugger.mode.label"));
        jPanel4.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.c = jRadioButton2 = new JRadioButton();
        this.a(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.attach.radio"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.n = jRadioButton = new JRadioButton();
        this.a(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.listen.radio"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.l = configurationArgumentsHelpArea = new ConfigurationArgumentsHelpArea();
        ((Component)configurationArgumentsHelpArea).setVisible(true);
        jPanel3.add((Component)configurationArgumentsHelpArea, new GridConstraints(1, 0, 1, 2, 9, 1, 3, 1, null, null, null));
        this.b = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.application.options.ModuleDescriptionsComboBox");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Search sources using m&odule's classpath:");
        labeledComponent.setVisible(true);
        jPanel3.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.a(jLabel6, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.remote.debugging.allows.you.to.connect.idea.to.a.running.jvm.label"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private static enum JDKVersionItem {
        JDK9(JavaSdkVersion.JDK_1_9){

            @Override
            String getLaunchCommandLine(RemoteConnection remoteConnection) {
                String string = JDK5to8.getLaunchCommandLine(remoteConnection);
                if (remoteConnection.isUseSockets() && !remoteConnection.isServerMode()) {
                    string = string.replace(remoteConnection.getAddress(), "*:" + remoteConnection.getAddress());
                }
                return string;
            }

            public String toString() {
                return "9 and after";
            }
        }
        ,
        JDK5to8(JavaSdkVersion.JDK_1_5){

            @Override
            String getLaunchCommandLine(RemoteConnection remoteConnection) {
                return remoteConnection.getLaunchCommandLine().replace("-Xdebug", "").replace("-Xrunjdwp:", "-agentlib:jdwp=").trim();
            }

            public String toString() {
                return "5 - 8";
            }
        }
        ,
        JDK1_4(JavaSdkVersion.JDK_1_4){

            @Override
            String getLaunchCommandLine(RemoteConnection remoteConnection) {
                return remoteConnection.getLaunchCommandLine();
            }

            public String toString() {
                return "1.4.x";
            }
        }
        ,
        JDK1_3(JavaSdkVersion.JDK_1_3){

            @Override
            String getLaunchCommandLine(RemoteConnection remoteConnection) {
                return "-Xnoagent -Djava.compiler=NONE " + remoteConnection.getLaunchCommandLine();
            }

            public String toString() {
                return "1.3.x or earlier";
            }
        };

        private final JavaSdkVersion a;

        private JDKVersionItem(JavaSdkVersion javaSdkVersion) {
            this.a = javaSdkVersion;
        }

        abstract String getLaunchCommandLine(RemoteConnection var1);
    }
}

