/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class JavaScratchCompilationSupport
implements CompileTask {
    public JavaScratchCompilationSupport(CompilerManager compilerManager) {
        compilerManager.addAfterTask((CompileTask)this);
    }

    @Nullable
    public static File getScratchOutputDirectory(Project project2) {
        File file = CompilerManager.getInstance((Project)project2).getJavacCompilerWorkingDir();
        return file != null ? new File(file, "scratches/out") : null;
    }

    @Nullable
    public static File getScratchTempDirectory(Project project2) {
        File file = CompilerManager.getInstance((Project)project2).getJavacCompilerWorkingDir();
        return file != null ? new File(file, "scratches/src") : null;
    }

    public boolean execute(CompileContext compileContext) {
        Sdk sdk;
        Project project2 = compileContext.getProject();
        RunConfiguration runConfiguration = CompileStepBeforeRun.getRunConfiguration(compileContext);
        if (!(runConfiguration instanceof JavaScratchConfiguration)) {
            return true;
        }
        JavaScratchConfiguration javaScratchConfiguration = (JavaScratchConfiguration)runConfiguration;
        String string = javaScratchConfiguration.getScratchFileUrl();
        if (string == null) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, "Associated scratch file not found", null, -1, -1);
            return false;
        }
        Module module2 = ((JavaRunConfigurationModule)javaScratchConfiguration.getConfigurationModule()).getModule();
        Sdk sdk2 = sdk = module2 != null ? ModuleRootManager.getInstance((Module)module2).getSdk() : ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (sdk == null) {
            String string2 = module2 != null ? "Cannot find associated SDK for run configuration module \"" + module2.getName() + "\".\nPlease check project settings." : "Cannot find associated project SDK for the run configuration.\nPlease check project settings.";
            compileContext.addMessage(CompilerMessageCategory.ERROR, string2, string, -1, -1);
            return true;
        }
        if (!(sdk.getSdkType() instanceof JavaSdkType)) {
            String string3 = module2 != null ? "Expected Java SDK for run configuration module \"" + module2.getName() + "\".\nPlease check project settings." : "Expected Java SDK for project \"" + project2.getName() + "\".\nPlease check project settings.";
            compileContext.addMessage(CompilerMessageCategory.ERROR, string3, string, -1, -1);
            return true;
        }
        File file = JavaScratchCompilationSupport.getScratchOutputDirectory(project2);
        if (file == null) {
            return true;
        }
        FileUtil.delete((File)file);
        try {
            Object object;
            Object object2;
            Object object3;
            File file2;
            File file3 = file2 = new File(VirtualFileManager.extractPath((String)string));
            if (!StringUtil.endsWith((CharSequence)file3.getName(), (CharSequence)".java")) {
                object3 = JavaScratchCompilationSupport.getScratchTempDirectory(project2);
                if (object3 == null) {
                    return true;
                }
                FileUtil.delete((File)object3);
                object2 = (String)ReadAction.compute(() -> {
                    PsiFile psiFile;
                    VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
                    if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile)) instanceof PsiJavaFile) {
                        String string2 = null;
                        for (PsiClass psiClass : ((PsiJavaFile)psiFile).getClasses()) {
                            if (string2 == null) {
                                string2 = psiClass.getName();
                                if (!JavaScratchCompilationSupport.a(psiClass)) continue;
                                break;
                            }
                            if (!JavaScratchCompilationSupport.a(psiClass)) continue;
                            string2 = psiClass.getName();
                            break;
                        }
                        if (string2 != null) {
                            return string2;
                        }
                    }
                    return FileUtil.getNameWithoutExtension((File)file2);
                });
                file3 = new File((File)object3, (String)object2 + ".java");
                FileUtil.copy((File)file2, (File)file3);
            }
            object3 = Collections.singleton(file3);
            object2 = new LinkedHashSet();
            ArrayList arrayList = new ArrayList();
            Computable computable = module2 != null ? () -> ModuleRootManager.getInstance((Module)module2).orderEntries() : () -> ProjectRootManager.getInstance((Project)project2).orderEntries();
            ApplicationManager.getApplication().runReadAction(() -> JavaScratchCompilationSupport.a(computable, (Set)object2, arrayList));
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add("-g");
            JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
            if (javaSdkVersion != null) {
                object = JpsJavaSdkType.complianceOption((JavaVersion)javaSdkVersion.getMaxLanguageLevel().toJavaVersion());
                arrayList2.add("-source");
                arrayList2.add(object);
                arrayList2.add("-target");
                arrayList2.add(object);
            }
            arrayList2.add("-proc:none");
            object = CompilerManager.getInstance((Project)project2).compileJavaCode(arrayList2, arrayList, (Collection)object2, Collections.emptyList(), Collections.emptyList(), (Collection)object3, file);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ClassObject classObject = (ClassObject)iterator.next();
                byte[] byArray = classObject.getContent();
                if (byArray == null) continue;
                FileUtil.writeToFile((File)new File(classObject.getPath()), (byte[])byArray);
            }
        }
        catch (CompilationException compilationException) {
            for (CompilationException.Message message : compilationException.getMessages()) {
                compileContext.addMessage(message.getCategory(), message.getText(), string, message.getLine(), message.getColumn());
            }
        }
        catch (IOException iOException) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, iOException.getMessage(), string, -1, -1);
        }
        return true;
    }

    private static boolean a(PsiClass psiClass) {
        PsiModifierList psiModifierList = psiClass.getModifierList();
        return psiModifierList != null && psiModifierList.hasModifierProperty("public");
    }

    private static /* synthetic */ void a(Computable computable, Set set, List list2) {
        for (String string : ((OrderEnumerator)computable.compute()).compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
            set.add(new File(string));
        }
        for (String string : ((OrderEnumerator)computable.compute()).compileOnly().sdkOnly().getPathsList().getPathList()) {
            list2.add(new File(string));
        }
    }
}

