/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoverySearchHelper {
    public static Set<String> search(Project project2, Pair<String, String> pair2, String string, String string2) {
        VirtualFile virtualFile2;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (pair2 != null) {
            try {
                TestDiscoverySearchHelper.a(project2, linkedHashSet, (String)pair2.first, (String)pair2.second, string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        List<VirtualFile> list2 = TestDiscoverySearchHelper.a(string, project2);
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(project2);
        for (VirtualFile virtualFile2 : list2) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile psiFile = psiManager.findFile(virtualFile2);
                if (psiFile instanceof PsiClassOwner) {
                    Object object;
                    if (pair2 != null && (((PsiClass[])(object = ((PsiClassOwner)psiFile).getClasses())).length == 0 || TestFrameworks.detectFramework((PsiClass)object[0]) == null)) {
                        return;
                    }
                    try {
                        object = FormatChangedTextUtil.getInstance().getChangedTextRanges(project2, psiFile);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            TextRange textRange = (TextRange)iterator.next();
                            PsiElement psiElement = psiFile.findElementAt(textRange.getStartOffset());
                            PsiElement psiElement2 = psiFile.findElementAt(textRange.getEndOffset());
                            PsiElement psiElement3 = PsiTreeUtil.findCommonParent((PsiElement[])new PsiElement[]{psiElement, psiElement2});
                            ArrayList<PsiMethod> arrayList = new ArrayList<PsiMethod>(PsiTreeUtil.findChildrenOfType((PsiElement)psiElement3, PsiMethod.class));
                            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement3, PsiMethod.class);
                            if (psiMethod != null) {
                                arrayList.add(psiMethod);
                            }
                            for (PsiMethod psiMethod2 : arrayList) {
                                PsiClass psiClass;
                                LinkedHashSet<String> linkedHashSet;
                                LinkedHashSet<String> linkedHashSet2 = linkedHashSet = pair2 == null ? TestDiscoverySearchHelper.a(psiMethod2, string2) : null;
                                if (linkedHashSet != null) {
                                    linkedHashSet.addAll(linkedHashSet);
                                }
                                if ((psiClass = psiMethod2.getContainingClass()) == null || psiClass.getParent() != psiFile) continue;
                                String string2 = psiClass.getQualifiedName();
                                String string3 = psiMethod2.getName();
                                try {
                                    if (string2 == null || (pair2 != null || TestFrameworks.detectFramework((PsiClass)psiClass) == null) && (pair2 == null || testDiscoveryIndex.hasTestTrace(string2 + string2 + "-" + string3))) continue;
                                    linkedHashSet.add(string2 + "," + string3);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    catch (FilesTooBigForDiffException filesTooBigForDiffException) {
                        // empty catch block
                    }
                }
            });
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
        virtualFile2 = GlobalSearchScope.projectScope((Project)project2);
        return new HashSet<String>(ContainerUtil.filter(linkedHashSet, arg_0 -> TestDiscoverySearchHelper.a(javaPsiFacade, (GlobalSearchScope)virtualFile2, arg_0)));
    }

    private static void a(Project project2, Set<String> set, String string, String string3, String string4) throws IOException {
        TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(project2);
        Collection<String> collection = testDiscoveryIndex.getTestsByMethodName(string, string3);
        if (collection != null) {
            for (String string5 : ContainerUtil.filter(collection, string2 -> string2.startsWith(string4))) {
                set.add(string5.substring(string4.length()).replace('-', ','));
            }
        }
    }

    @NotNull
    private static List<VirtualFile> a(String string, Project project2) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        if ("All".equals(string)) {
            List list2 = changeListManager.getAffectedFiles();
            if (list2 == null) {
                TestDiscoverySearchHelper.a(0);
            }
            return list2;
        }
        LocalChangeList localChangeList = changeListManager.findChangeList(string);
        if (localChangeList != null) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            for (Change change : localChangeList.getChanges()) {
                VirtualFile virtualFile;
                ContentRevision contentRevision = change.getAfterRevision();
                if (contentRevision == null || (virtualFile = contentRevision.getFile().getVirtualFile()) == null) continue;
                arrayList.add(virtualFile);
            }
            ArrayList<VirtualFile> arrayList2 = arrayList;
            if (arrayList2 == null) {
                TestDiscoverySearchHelper.a(1);
            }
            return arrayList2;
        }
        List<VirtualFile> list3 = Collections.emptyList();
        if (list3 == null) {
            TestDiscoverySearchHelper.a(2);
        }
        return list3;
    }

    @Nullable
    private static LinkedHashSet<String> a(PsiMethod psiMethod, String string) {
        String string2;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass != null && (string2 = psiClass.getQualifiedName()) != null) {
            try {
                TestDiscoverySearchHelper.a(psiMethod.getProject(), linkedHashSet, string2, psiMethod.getName(), string);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return linkedHashSet;
    }

    private static /* synthetic */ boolean a(JavaPsiFacade javaPsiFacade, GlobalSearchScope globalSearchScope, String string) {
        return (Boolean)ReadAction.compute(() -> javaPsiFacade.findClass(StringUtil.getPackageName((String)string, (char)','), globalSearchScope) != null);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoverySearchHelper", "getAffectedFiles"));
    }
}

