/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TestInfoHolder {
    final PersistentHashMap<Long, TIntArrayList> myMethodQNameToTestNames;
    final PersistentHashMap<Integer, TIntObjectHashMap<TIntArrayList>> myTestNameToUsedClassesAndMethodMap;
    final PersistentHashMap<Long, TIntArrayList> myTestNameToNearestModule;
    final PersistentStringEnumerator myClassEnumerator;
    final CachingEnumerator<String> myClassEnumeratorCache;
    final PersistentStringEnumerator myMethodEnumerator;
    final CachingEnumerator<String> myMethodEnumeratorCache;
    final PersistentStringEnumerator myTestNameEnumerator;
    final PersistentStringEnumerator myModuleNameEnumerator;
    final List<PersistentEnumeratorDelegate> myConstructedDataFiles;
    private ScheduledFuture<?> e;
    private boolean c;
    private final Object d;
    private static final int b = 4;
    private static final int a = -1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TestInfoHolder(@NotNull Path path, final boolean bl2, Object object) {
        if (path == null) {
            TestInfoHolder.a(0);
        }
        this.myConstructedDataFiles = new ArrayList<PersistentEnumeratorDelegate>(6);
        this.d = object;
        Path path2 = TestInfoHolder.getVersionFile(path);
        PathKt.createDirectories((Path)path);
        File file = path.resolve("methodQNameToTestName.data").toFile();
        File file2 = path.resolve("testToCalledMethodNames.data").toFile();
        File file3 = path.resolve("classNameEnumerator.data").toFile();
        File file4 = path.resolve("methodNameEnumerator.data").toFile();
        File file5 = path.resolve("testNameEnumerator.data").toFile();
        File file6 = path.resolve("moduleNameEnumerator.data").toFile();
        File file7 = path.resolve("testNameToNearestModule.data").toFile();
        try {
            PersistentStringEnumerator persistentStringEnumerator;
            PersistentStringEnumerator persistentStringEnumerator2;
            PersistentStringEnumerator persistentStringEnumerator3;
            PersistentStringEnumerator persistentStringEnumerator4;
            PersistentHashMap persistentHashMap;
            PersistentHashMap<Integer, TIntObjectHashMap<TIntArrayList>> persistentHashMap2;
            PersistentHashMap<Long, TIntArrayList> persistentHashMap3;
            int n2 = TestInfoHolder.b(path2);
            if (n2 != 4) {
                assert (!bl2);
                TestDiscoveryIndex.LOG.info("TestDiscoveryIndex was rewritten due to version change");
                TestInfoHolder.a(file, file2, file3, file4, file5, file6, file7);
                TestInfoHolder.a(path2);
            }
            int n3 = 0;
            while (true) {
                ++n3;
                try {
                    persistentHashMap3 = new PersistentHashMap<Long, TIntArrayList>(file, (KeyDescriptor)MethodQNameSerializer.INSTANCE, (DataExternalizer)new TestNamesExternalizer()){

                        protected boolean isReadOnly() {
                            return bl2;
                        }
                    };
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)persistentHashMap3);
                    persistentHashMap2 = new PersistentHashMap<Integer, TIntObjectHashMap<TIntArrayList>>(file2, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new ClassesAndMethodsMapDataExternalizer()){

                        protected boolean isReadOnly() {
                            return bl2;
                        }
                    };
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)persistentHashMap2);
                    persistentHashMap = new PersistentHashMap(file7, (KeyDescriptor)MethodQNameSerializer.INSTANCE, (DataExternalizer)new TestNamesExternalizer());
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)persistentHashMap);
                    persistentStringEnumerator4 = new PersistentStringEnumerator(file3);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)persistentStringEnumerator4);
                    persistentStringEnumerator3 = new PersistentStringEnumerator(file4);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)persistentStringEnumerator3);
                    persistentStringEnumerator2 = new PersistentStringEnumerator(file6);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)persistentStringEnumerator2);
                    persistentStringEnumerator = new PersistentStringEnumerator(file5);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)persistentStringEnumerator);
                }
                catch (Throwable throwable) {
                    TestDiscoveryIndex.LOG.info("TestDiscoveryIndex problem", throwable);
                    this.a(true);
                    this.myConstructedDataFiles.clear();
                    TestInfoHolder.a(file, file2, file3, file4, file5, file6, file7);
                    if (n3 < 3) continue;
                    TestDiscoveryIndex.LOG.error("Unexpected circular initialization problem");
                    assert (false);
                    continue;
                }
                break;
            }
            this.myMethodQNameToTestNames = persistentHashMap3;
            this.myTestNameToUsedClassesAndMethodMap = persistentHashMap2;
            this.myTestNameToNearestModule = persistentHashMap;
            this.myClassEnumerator = persistentStringEnumerator4;
            this.myMethodEnumerator = persistentStringEnumerator3;
            this.myTestNameEnumerator = persistentStringEnumerator;
            this.myModuleNameEnumerator = persistentStringEnumerator2;
            this.myMethodEnumeratorCache = new CachingEnumerator((DataEnumerator)persistentStringEnumerator3, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE);
            this.myClassEnumeratorCache = new CachingEnumerator((DataEnumerator)persistentStringEnumerator4, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE);
            this.e = FlushingDaemon.everyFiveSeconds(() -> {
                Object object = this.d;
                synchronized (object) {
                    if (this.c) {
                        this.e.cancel(false);
                        return;
                    }
                    for (PersistentEnumeratorDelegate persistentEnumeratorDelegate : this.myConstructedDataFiles) {
                        if (!persistentEnumeratorDelegate.isDirty()) continue;
                        persistentEnumeratorDelegate.force();
                    }
                    this.myClassEnumeratorCache.clear();
                    this.myMethodEnumeratorCache.clear();
                }
            });
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void a(boolean bl2) {
        for (Closeable closeable : this.myConstructedDataFiles) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                if (bl2) continue;
                throw new RuntimeException(throwable);
            }
        }
    }

    private static void a(File ... fileArray) {
        for (File file : fileArray) {
            IOUtil.deleteAllFilesStartingWith((File)file);
        }
    }

    private static void a(@NotNull Path path) throws IOException {
        if (path == null) {
            TestInfoHolder.a(1);
        }
        try (DataOutputStream dataOutputStream = new DataOutputStream(PathKt.outputStream((Path)path));){
            DataInputOutputUtil.writeINT((DataOutput)dataOutputStream, (int)4);
        }
    }

    private static int b(@NotNull Path path) throws IOException {
        InputStream inputStream;
        if (path == null) {
            TestInfoHolder.a(2);
        }
        if ((inputStream = PathKt.inputStreamIfExists((Path)path)) == null) {
            return 0;
        }
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            int n2 = DataInputOutputUtil.readINT((DataInput)dataInputStream);
            return n2;
        }
    }

    void dispose() {
        assert (Thread.holdsLock(this.d));
        try {
            this.a(false);
        }
        finally {
            this.c = true;
        }
    }

    void doUpdateFromDiff(int n2, @Nullable TIntObjectHashMap<TIntArrayList> tIntObjectHashMap, @Nullable TIntObjectHashMap<TIntArrayList> tIntObjectHashMap2, @Nullable Integer n3) throws IOException {
        ValueDiff valueDiff = new ValueDiff(tIntObjectHashMap, tIntObjectHashMap2);
        if (valueDiff.hasRemovedDelta()) {
            for (int n4 : valueDiff.myRemovedClassData.keys()) {
                for (int n5 : ((TIntArrayList)valueDiff.myRemovedClassData.get(n4)).toNativeArray()) {
                    this.myMethodQNameToTestNames.appendData((Object)TestInfoHolder.createKey(n4, n5), dataOutput -> {
                        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)-1);
                        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)n2);
                    });
                }
            }
        }
        if (valueDiff.hasAddedDelta()) {
            for (int n4 : valueDiff.myAddedOrChangedClassData.keys()) {
                for (int n5 : ((TIntArrayList)valueDiff.myAddedOrChangedClassData.get(n4)).toNativeArray()) {
                    this.myMethodQNameToTestNames.appendData((Object)TestInfoHolder.createKey(n4, n5), dataOutput -> DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)n2));
                    if (n3 == null) continue;
                    this.myTestNameToNearestModule.appendData((Object)TestInfoHolder.createKey(n4, n5), dataOutput -> DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)n3));
                }
            }
        }
        if (valueDiff.hasAddedDelta() || valueDiff.hasRemovedDelta()) {
            if (tIntObjectHashMap != null) {
                this.myTestNameToUsedClassesAndMethodMap.put((Object)n2, tIntObjectHashMap);
            } else {
                this.myTestNameToUsedClassesAndMethodMap.remove((Object)n2);
            }
        }
    }

    public boolean isDisposed() {
        return this.c;
    }

    public static boolean isValidPath(@NotNull Path path) {
        if (path == null) {
            TestInfoHolder.a(3);
        }
        try {
            return TestInfoHolder.b(TestInfoHolder.getVersionFile(path)) == 4;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @NotNull
    static Path getVersionFile(Path path) {
        Path path2 = path.resolve("index.version");
        if (path2 == null) {
            TestInfoHolder.a(4);
        }
        return path2;
    }

    static long createKey(int n2, int n3) {
        return (long)n2 << 32 | (long)n3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestInfoHolder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPath";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ValueDiff {
        final TIntObjectHashMap<TIntArrayList> myAddedOrChangedClassData;
        final TIntObjectHashMap<TIntArrayList> myRemovedClassData;

        ValueDiff(@Nullable TIntObjectHashMap<TIntArrayList> tIntObjectHashMap, @Nullable TIntObjectHashMap<TIntArrayList> tIntObjectHashMap2) {
            TIntObjectHashMap tIntObjectHashMap3 = tIntObjectHashMap;
            TIntObjectHashMap tIntObjectHashMap4 = tIntObjectHashMap2;
            if (tIntObjectHashMap2 != null && !tIntObjectHashMap2.isEmpty()) {
                TIntArrayList tIntArrayList;
                tIntObjectHashMap4 = new TIntObjectHashMap();
                tIntObjectHashMap3 = new TIntObjectHashMap();
                if (tIntObjectHashMap != null) {
                    for (int n2 : tIntObjectHashMap.keys()) {
                        tIntArrayList = (TIntArrayList)tIntObjectHashMap.get(n2);
                        TIntArrayList tIntArrayList2 = (TIntArrayList)tIntObjectHashMap2.get(n2);
                        if (tIntArrayList2 == null) {
                            tIntObjectHashMap3.put(n2, (Object)tIntArrayList);
                            continue;
                        }
                        int[] nArray = tIntArrayList2.toNativeArray();
                        TIntHashSet tIntHashSet = new TIntHashSet(nArray);
                        int[] nArray2 = tIntArrayList.toNativeArray();
                        TIntHashSet tIntHashSet2 = new TIntHashSet(nArray2);
                        tIntHashSet2.removeAll(nArray);
                        tIntHashSet.removeAll(nArray2);
                        if (!tIntHashSet2.isEmpty()) {
                            tIntObjectHashMap3.put(n2, (Object)new TIntArrayList(tIntHashSet2.toArray()));
                        }
                        if (tIntHashSet.isEmpty()) continue;
                        tIntObjectHashMap4.put(n2, (Object)new TIntArrayList(tIntHashSet.toArray()));
                    }
                }
                if (tIntObjectHashMap != null) {
                    for (int n2 : tIntObjectHashMap2.keys()) {
                        if (tIntObjectHashMap.containsKey(n2)) continue;
                        tIntArrayList = (TIntArrayList)tIntObjectHashMap2.get(n2);
                        tIntObjectHashMap4.put(n2, (Object)tIntArrayList);
                    }
                }
            }
            this.myAddedOrChangedClassData = tIntObjectHashMap3;
            this.myRemovedClassData = tIntObjectHashMap4;
        }

        public boolean hasRemovedDelta() {
            return this.myRemovedClassData != null && !this.myRemovedClassData.isEmpty();
        }

        public boolean hasAddedDelta() {
            return this.myAddedOrChangedClassData != null && !this.myAddedOrChangedClassData.isEmpty();
        }
    }

    private static class MethodQNameSerializer
    implements KeyDescriptor<Long> {
        public static final MethodQNameSerializer INSTANCE = new MethodQNameSerializer();

        private MethodQNameSerializer() {
        }

        public void save(@NotNull DataOutput dataOutput, Long l2) throws IOException {
            if (dataOutput == null) {
                MethodQNameSerializer.a(0);
            }
            dataOutput.writeLong(l2);
        }

        public Long read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                MethodQNameSerializer.a(1);
            }
            return dataInput.readLong();
        }

        public int getHashCode(Long l2) {
            return l2.hashCode();
        }

        public boolean isEqual(Long l2, Long l3) {
            return l2.equals(l3);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder$MethodQNameSerializer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassesAndMethodsMapDataExternalizer
    implements DataExternalizer<TIntObjectHashMap<TIntArrayList>> {
        private ClassesAndMethodsMapDataExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, TIntObjectHashMap<TIntArrayList> tIntObjectHashMap) throws IOException {
            if (dataOutput == null) {
                ClassesAndMethodsMapDataExternalizer.a(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)tIntObjectHashMap.size());
            int[] nArray = tIntObjectHashMap.keys();
            Arrays.sort(nArray);
            int n2 = 0;
            for (int n3 : nArray) {
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)(n3 - n2));
                TIntArrayList tIntArrayList = (TIntArrayList)tIntObjectHashMap.get(n3);
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)tIntArrayList.size());
                int[] nArray2 = tIntArrayList.toNativeArray();
                Arrays.sort(nArray2);
                int n4 = 0;
                for (int n5 : nArray2) {
                    DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)(n5 - n4));
                    n4 = n5;
                }
                n2 = n3;
            }
        }

        public TIntObjectHashMap<TIntArrayList> read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                ClassesAndMethodsMapDataExternalizer.a(1);
            }
            int n2 = DataInputOutputUtil.readINT((DataInput)dataInput);
            TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
            int n3 = 0;
            while (n2-- > 0) {
                int n4 = DataInputOutputUtil.readINT((DataInput)dataInput) + n3;
                int n5 = DataInputOutputUtil.readINT((DataInput)dataInput);
                TIntArrayList tIntArrayList = new TIntArrayList(n5);
                int n6 = 0;
                while (n5-- > 0) {
                    int n7 = DataInputOutputUtil.readINT((DataInput)dataInput) + n6;
                    tIntArrayList.add(n7);
                    n6 = n7;
                }
                tIntObjectHashMap.put(n4, (Object)tIntArrayList);
                n3 = n4;
            }
            return tIntObjectHashMap;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataInput";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder$ClassesAndMethodsMapDataExternalizer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TestNamesExternalizer
    implements DataExternalizer<TIntArrayList> {
        private TestNamesExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, TIntArrayList tIntArrayList) throws IOException {
            if (dataOutput == null) {
                TestNamesExternalizer.a(0);
            }
            for (int n2 : tIntArrayList.toNativeArray()) {
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)n2);
            }
        }

        public TIntArrayList read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                TestNamesExternalizer.a(1);
            }
            TIntHashSet tIntHashSet = new TIntHashSet();
            while (((InputStream)((Object)dataInput)).available() > 0) {
                int n2 = DataInputOutputUtil.readINT((DataInput)dataInput);
                if (-1 == n2) {
                    n2 = DataInputOutputUtil.readINT((DataInput)dataInput);
                    if (tIntHashSet.remove(n2)) continue;
                    tIntHashSet.add(-n2);
                    continue;
                }
                tIntHashSet.add(n2);
            }
            return new TIntArrayList(tIntHashSet.toArray());
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataInput";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder$TestNamesExternalizer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

