/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SortedComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ConfigurationModuleSelector {
    public static final String NO_MODULE_TEXT = "<no module>";
    private final Project c;
    private final ModuleDescriptionsComboBox b;
    private final JComboBox<Module> a;

    public ConfigurationModuleSelector(Project project2, JComboBox<Module> jComboBox) {
        this(project2, jComboBox, NO_MODULE_TEXT);
    }

    public ConfigurationModuleSelector(Project project2, ModulesComboBox modulesComboBox) {
        this(project2, modulesComboBox, NO_MODULE_TEXT);
    }

    public ConfigurationModuleSelector(Project project2, ModuleDescriptionsComboBox moduleDescriptionsComboBox) {
        this(project2, moduleDescriptionsComboBox, NO_MODULE_TEXT);
    }

    public ConfigurationModuleSelector(Project project2, ModuleDescriptionsComboBox moduleDescriptionsComboBox, String string) {
        this.c = project2;
        this.b = moduleDescriptionsComboBox;
        this.a = null;
        moduleDescriptionsComboBox.allowEmptySelection(string);
    }

    public ConfigurationModuleSelector(Project project2, ModulesComboBox modulesComboBox, String string) {
        this.c = project2;
        this.a = modulesComboBox;
        this.b = null;
        modulesComboBox.allowEmptySelection(string);
    }

    public ConfigurationModuleSelector(Project project2, JComboBox<Module> jComboBox, final String string) {
        this.c = project2;
        this.a = jComboBox;
        this.b = null;
        new ComboboxSpeedSearch(jComboBox){

            protected String getElementText(Object object) {
                if (object instanceof Module) {
                    return ((Module)object).getName();
                }
                if (object == null) {
                    return string;
                }
                return super.getElementText(object);
            }
        };
        this.a.setModel((ComboBoxModel<Module>)new SortedComboBoxModel((Comparator)ModulesAlphaComparator.INSTANCE));
        this.a.setRenderer((ListCellRenderer<Module>)new ModuleListCellRenderer(string));
    }

    public void applyTo(ModuleBasedConfiguration moduleBasedConfiguration) {
        if (this.a != null) {
            moduleBasedConfiguration.setModule((Module)this.a.getSelectedItem());
        } else {
            moduleBasedConfiguration.setModuleName(this.b.getSelectedModuleName());
        }
    }

    public void reset(ModuleBasedConfiguration moduleBasedConfiguration) {
        this.reset();
        if (this.a != null) {
            this.a.setSelectedItem(moduleBasedConfiguration.getConfigurationModule().getModule());
        } else {
            this.b.setSelectedModule(this.c, moduleBasedConfiguration.getConfigurationModule().getModuleName());
        }
    }

    public void reset() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.getProject()).getModules();
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (Module module2 : moduleArray) {
            if (!this.isModuleAccepted(module2)) continue;
            arrayList.add(module2);
        }
        this.a(arrayList);
    }

    public boolean isModuleAccepted(Module module2) {
        return ModuleTypeManager.getInstance().isClasspathProvider(ModuleType.get((Module)module2));
    }

    public Project getProject() {
        return this.c;
    }

    public JavaRunConfigurationModule getConfigurationModule() {
        JavaRunConfigurationModule javaRunConfigurationModule = new JavaRunConfigurationModule(this.getProject(), false);
        javaRunConfigurationModule.setModule(this.getModule());
        return javaRunConfigurationModule;
    }

    private void a(Collection<Module> collection) {
        if (this.b != null) {
            this.b.setModules(collection);
        } else if (this.a instanceof ModulesComboBox) {
            ((ModulesComboBox)this.a).setModules(collection);
        } else {
            SortedComboBoxModel sortedComboBoxModel = (SortedComboBoxModel)this.a.getModel();
            sortedComboBoxModel.setAll(collection);
            sortedComboBoxModel.add(null);
        }
    }

    public Module getModule() {
        return this.b != null ? this.b.getSelectedModule() : (Module)this.a.getSelectedItem();
    }

    @Nullable
    public PsiClass findClass(String string) {
        return this.getConfigurationModule().findClass(string);
    }

    public String getModuleName() {
        Module module2 = this.getModule();
        return module2 == null ? "" : module2.getName();
    }
}

