/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.StatusText;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;

class JreComboboxEditor
extends BasicComboBoxEditor {
    public static final TextComponentAccessor<JComboBox> TEXT_COMPONENT_ACCESSOR = new JreComboBoxTextComponentAccessor();
    private final SortedComboBoxModel<JrePathEditor.JreComboBoxItem> a;

    public JreComboboxEditor(SortedComboBoxModel<JrePathEditor.JreComboBoxItem> sortedComboBoxModel) {
        this.a = sortedComboBoxModel;
    }

    @Override
    public void setItem(Object object) {
        this.editor.setText(object == null ? "" : ((JrePathEditor.JreComboBoxItem)object).getPresentableText());
    }

    @Override
    public Object getItem() {
        String string = this.editor.getText().trim();
        for (JrePathEditor.JreComboBoxItem jreComboBoxItem : this.a.getItems()) {
            if (!jreComboBoxItem.getPresentableText().equals(string)) continue;
            return jreComboBoxItem;
        }
        return new JrePathEditor.CustomJreItem(FileUtil.toSystemIndependentName((String)string));
    }

    @Override
    protected JTextField createEditorComponent() {
        JBTextField jBTextField = new JBTextField();
        jBTextField.setBorder(null);
        jBTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                this.a(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                this.a(focusEvent);
            }

            private void a(FocusEvent focusEvent) {
                Container container = focusEvent.getComponent().getParent();
                if (container != null) {
                    container.revalidate();
                    container.repaint();
                }
            }
        });
        return jBTextField;
    }

    public StatusText getEmptyText() {
        return this.getEditorComponent().getEmptyText();
    }

    public JBTextField getEditorComponent() {
        return (JBTextField)super.getEditorComponent();
    }

    private static class JreComboBoxTextComponentAccessor
    implements TextComponentAccessor<JComboBox> {
        private JreComboBoxTextComponentAccessor() {
        }

        public String getText(JComboBox jComboBox) {
            Object object = jComboBox.getEditor().getItem();
            return object != null ? ((JrePathEditor.JreComboBoxItem)object).getPresentableText() : "";
        }

        public void setText(JComboBox jComboBox, @NotNull String string) {
            if (string == null) {
                JreComboBoxTextComponentAccessor.a(0);
            }
            jComboBox.getEditor().setItem(new JrePathEditor.CustomJreItem(FileUtil.toSystemIndependentName((String)string)));
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/ui/JreComboboxEditor$JreComboBoxTextComponentAccessor", "setText"));
        }
    }
}

