/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.actions;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.ui.FacetEditorFacade;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.impl.AddFrameworkSupportInProjectStructureAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import java.util.Collection;
import java.util.TreeMap;

public class AddFacetToModuleAction
extends AnAction
implements DumbAware {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.facet.impl.ui.actions.AddFacetToModuleAction");
    private final FacetEditorFacade d;
    private final Project b;
    private final FacetType a;

    private AddFacetToModuleAction(FacetEditorFacade facetEditorFacade, Project project2, FacetType facetType) {
        super(facetType.getPresentableName(), null, facetType.getIcon());
        this.d = facetEditorFacade;
        this.b = project2;
        this.a = facetType;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Facet facet;
        FacetInfo facetInfo = this.d.getSelectedFacetInfo();
        FacetTypeId facetTypeId = this.a.getUnderlyingFacetType();
        if (facetInfo == null && facetTypeId == null || facetInfo != null && facetInfo.getFacetType().getId() == facetTypeId) {
            facet = this.d.createFacet(facetInfo, this.a);
        } else {
            c.assertTrue(facetInfo != null);
            FacetInfo facetInfo2 = this.d.getParent(facetInfo);
            c.assertTrue(facetInfo2 == null && facetTypeId == null || facetInfo2 != null && facetInfo2.getFacetType().getId() == facetTypeId);
            facet = this.d.createFacet(facetInfo2, this.a);
        }
        ProjectStructureConfigurable.getInstance(this.b).select(facet, true);
    }

    public void update(AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setVisible(AddFacetToModuleAction.isVisible(this.d, this.a));
    }

    public static boolean isVisible(FacetEditorFacade facetEditorFacade, FacetType<?, ?> facetType) {
        ModuleType moduleType = facetEditorFacade.getSelectedModuleType();
        if (moduleType == null || !facetType.isSuitableModuleType(moduleType)) {
            return false;
        }
        FacetTypeId facetTypeId = facetType.getUnderlyingFacetType();
        FacetInfo facetInfo = facetEditorFacade.getSelectedFacetInfo();
        if (facetInfo == null) {
            return facetTypeId == null && AddFacetToModuleAction.a(null, facetType, facetEditorFacade);
        }
        FacetTypeId facetTypeId2 = facetInfo.getFacetType().getId();
        if (facetTypeId2 == facetTypeId) {
            return AddFacetToModuleAction.a(facetInfo, facetType, facetEditorFacade);
        }
        FacetInfo facetInfo2 = facetEditorFacade.getParent(facetInfo);
        if (!AddFacetToModuleAction.a(facetInfo2, facetType, facetEditorFacade)) {
            return false;
        }
        return facetInfo2 == null && facetTypeId == null || facetInfo2 != null && facetInfo2.getFacetType().getId() == facetTypeId;
    }

    private static boolean a(FacetInfo facetInfo, FacetType<?, ?> facetType, FacetEditorFacade facetEditorFacade) {
        return !facetType.isOnlyOneFacetAllowed() || !facetEditorFacade.nodeHasFacetOfType(facetInfo, facetType.getId());
    }

    public static Collection<AnAction> createAddFrameworkActions(FacetEditorFacade facetEditorFacade, Project project2) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (FrameworkTypeEx frameworkTypeEx : (FrameworkTypeEx[])FrameworkTypeEx.EP_NAME.getExtensions()) {
            AddFrameworkSupportInProjectStructureAction addFrameworkSupportInProjectStructureAction = new AddFrameworkSupportInProjectStructureAction(frameworkTypeEx, frameworkTypeEx.createProvider(), ModuleStructureConfigurable.getInstance(project2));
            treeMap.put(frameworkTypeEx.getPresentableName(), (Object)addFrameworkSupportInProjectStructureAction);
        }
        for (FrameworkTypeEx frameworkTypeEx : FacetTypeRegistry.getInstance().getFacetTypes()) {
            treeMap.put(frameworkTypeEx.getPresentableName(), (Object)new AddFacetToModuleAction(facetEditorFacade, project2, (FacetType)frameworkTypeEx));
        }
        return treeMap.values();
    }
}

