/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.impl.ui.libraries.RequiredLibrariesInfo;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.frameworkSupport.OldCustomLibraryDescription;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FacetLibrariesValidatorImpl
extends FacetLibrariesValidator {
    private final LibrariesValidatorContext d;
    private final FacetValidatorsManager a;
    private RequiredLibrariesInfo e;
    private FacetLibrariesValidatorDescription b;
    private final List<Library> c = new ArrayList<Library>();

    public FacetLibrariesValidatorImpl(LibraryInfo[] libraryInfoArray, FacetLibrariesValidatorDescription facetLibrariesValidatorDescription, LibrariesValidatorContext librariesValidatorContext, FacetValidatorsManager facetValidatorsManager) {
        this.d = librariesValidatorContext;
        this.a = facetValidatorsManager;
        this.e = new RequiredLibrariesInfo(libraryInfoArray);
        this.b = facetLibrariesValidatorDescription;
    }

    public void setRequiredLibraries(LibraryInfo[] libraryInfoArray) {
        this.e = new RequiredLibrariesInfo(libraryInfoArray);
        this.a();
    }

    public boolean isLibrariesAdded() {
        return false;
    }

    public void setDescription(@NotNull FacetLibrariesValidatorDescription facetLibrariesValidatorDescription) {
        if (facetLibrariesValidatorDescription == null) {
            FacetLibrariesValidatorImpl.a(0);
        }
        this.b = facetLibrariesValidatorDescription;
        this.a();
    }

    @NotNull
    public ValidationResult check() {
        if (this.e == null) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                FacetLibrariesValidatorImpl.a(1);
            }
            return validationResult;
        }
        List<VirtualFile> list2 = this.a(this.d.getRootModel());
        RequiredLibrariesInfo.RequiredClassesNotFoundInfo requiredClassesNotFoundInfo = this.e.checkLibraries(VfsUtil.toVirtualFileArray(list2));
        if (requiredClassesNotFoundInfo == null) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                FacetLibrariesValidatorImpl.a(2);
            }
            return validationResult;
        }
        String string = IdeBundle.message((String)"label.missed.libraries.prefix", (Object[])new Object[0]) + " " + requiredClassesNotFoundInfo.getMissingJarsText();
        LibraryInfo[] libraryInfoArray = requiredClassesNotFoundInfo.getLibraryInfos();
        OldCustomLibraryDescription oldCustomLibraryDescription = new OldCustomLibraryDescription(libraryInfoArray, this.b.getDefaultLibraryName());
        ValidationResult validationResult = new ValidationResult(string, (FacetConfigurationQuickFix)new LibrariesQuickFix(oldCustomLibraryDescription));
        if (validationResult == null) {
            FacetLibrariesValidatorImpl.a(3);
        }
        return validationResult;
    }

    private void a() {
        if (this.a != null) {
            this.a.validate();
        }
    }

    public void onFacetInitialized(Facet facet) {
        for (Library library : this.c) {
            this.b.onLibraryAdded(facet, library);
        }
    }

    private List<VirtualFile> a(@NotNull ModuleRootModel moduleRootModel) {
        if (moduleRootModel == null) {
            FacetLibrariesValidatorImpl.a(4);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        moduleRootModel.orderEntries().using((RootModelProvider)this.d.getModulesProvider()).recursively().librariesOnly().forEachLibrary(library -> {
            ContainerUtil.addAll((Collection)arrayList, (Object[])this.d.getLibrariesContainer().getLibraryFiles((Library)library, OrderRootType.CLASSES));
            return true;
        });
        return arrayList;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/libraries/FacetLibrariesValidatorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/libraries/FacetLibrariesValidatorImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "check";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LibrariesQuickFix
    extends FacetConfigurationQuickFix {
        private final CustomLibraryDescription a;

        public LibrariesQuickFix(CustomLibraryDescription customLibraryDescription) {
            super(IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
            this.a = customLibraryDescription;
        }

        public void run(JComponent jComponent) {
            AddCustomLibraryDialog addCustomLibraryDialog = AddCustomLibraryDialog.createDialog(this.a, FacetLibrariesValidatorImpl.this.d.getLibrariesContainer(), FacetLibrariesValidatorImpl.this.d.getModule(), FacetLibrariesValidatorImpl.this.d.getModifiableRootModel(), null);
            addCustomLibraryDialog.show();
            FacetLibrariesValidatorImpl.this.c.addAll(addCustomLibraryDialog.getAddedLibraries());
            FacetLibrariesValidatorImpl.this.a();
        }
    }
}

