/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequiredLibrariesInfo {
    private final List<LibraryInfo> a = new ArrayList<LibraryInfo>();

    public RequiredLibrariesInfo(LibraryInfo ... libraryInfoArray) {
        this.a.addAll(new ArrayList<LibraryInfo>(Arrays.asList(libraryInfoArray)));
    }

    @Nullable
    public RequiredClassesNotFoundInfo checkLibraries(VirtualFile[] virtualFileArray) {
        return this.checkLibraries(Arrays.asList(virtualFileArray));
    }

    @Nullable
    public RequiredClassesNotFoundInfo checkLibraries(List<VirtualFile> list2) {
        ArrayList<LibraryInfo> arrayList = new ArrayList<LibraryInfo>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (LibraryInfo libraryInfo : this.a) {
            boolean bl2;
            String string = libraryInfo.getMd5();
            if (!StringUtil.isEmptyOrSpaces((String)string)) {
                bl2 = true;
                for (VirtualFile virtualFile : list2) {
                    VirtualFile virtualFile2 = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile);
                    if (!string.equals(RequiredLibrariesInfo.md5(virtualFile2))) continue;
                    bl2 = false;
                    break;
                }
            } else {
                bl2 = false;
                for (String string2 : libraryInfo.getRequiredClasses()) {
                    if (LibraryUtil.isClassAvailableInLibrary(list2, (String)string2)) continue;
                    arrayList2.add(string2);
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            arrayList.add(libraryInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new RequiredClassesNotFoundInfo(ArrayUtil.toStringArray(arrayList2), arrayList.toArray(LibraryInfo.EMPTY_ARRAY));
    }

    @Nullable
    public static String md5(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RequiredLibrariesInfo.a(0);
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(virtualFile.contentsToByteArray());
            byte[] byArray = messageDigest.digest();
            return new String(Hex.encodeHex((byte[])byArray));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getLibrariesPresentableText(LibraryInfo[] libraryInfoArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < libraryInfoArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(libraryInfoArray[i2].getName());
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/facet/impl/ui/libraries/RequiredLibrariesInfo", "md5"));
    }

    public static class RequiredClassesNotFoundInfo {
        private final String[] a;
        private final LibraryInfo[] b;

        public RequiredClassesNotFoundInfo(String[] stringArray, LibraryInfo[] libraryInfoArray) {
            this.a = stringArray;
            this.b = libraryInfoArray;
        }

        public String[] getClassNames() {
            return this.a;
        }

        public LibraryInfo[] getLibraryInfos() {
            return this.b;
        }

        public String getMissingJarsText() {
            return RequiredLibrariesInfo.getLibrariesPresentableText(this.b);
        }
    }
}

