/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class FormatterTestUtils {
    public static final Map<Action, TestFormatAction> ACTIONS = new EnumMap<Action, TestFormatAction>(Action.class);

    public static void testFormatting(@NotNull Project project2, @NotNull String string, @NotNull String string2, @NotNull String string3, @NotNull Action action) {
        if (project2 == null) {
            FormatterTestUtils.a(0);
        }
        if (string == null) {
            FormatterTestUtils.a(1);
        }
        if (string2 == null) {
            FormatterTestUtils.a(2);
        }
        if (string3 == null) {
            FormatterTestUtils.a(3);
        }
        if (action == null) {
            FormatterTestUtils.a(4);
        }
        String string4 = "FTU." + string;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(string4);
        FormatData formatData = FormatterTestUtils.a(string2);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText(string4, fileType, (CharSequence)formatData.text, System.currentTimeMillis(), true);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            throw new IllegalStateException("Document is null");
        }
        TestFormatAction testFormatAction = ACTIONS.get((Object)action);
        if (testFormatAction == null) {
            throw new IllegalStateException("Format action is null");
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> testFormatAction.run(psiFile, formatData.startOffset, formatData.endOffset));
        Assert.assertEquals((Object)string3, (Object)document.getText());
    }

    private static FormatData a(@NotNull String string) {
        if (string == null) {
            FormatterTestUtils.a(5);
        }
        String string2 = "<selection>";
        String string3 = "<selection/>";
        int n2 = string.indexOf("<selection>");
        if (n2 > 0) {
            int n3 = string.indexOf("<selection/>") - "<selection>".length();
            String string4 = string.replace("<selection>", "").replace("<selection/>", "");
            return new FormatData(string4, n2, n3);
        }
        return new FormatData(string, 0, string.length());
    }

    static {
        ACTIONS.put(Action.REFORMAT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatText(psiFile, n2, n3);
            }
        });
        ACTIONS.put(Action.INDENT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile, n2);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(n2, n3)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, (Collection)arrayList);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_INSERTED_LINE_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(n2, n3)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, new ChangedRangesInfo((List)arrayList, (List)arrayList));
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/FormatterTestUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "testFormatting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFormatData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FormatData {
        public int startOffset;
        public int endOffset;
        public String text;

        public FormatData(String string, int n2, int n3) {
            this.text = string;
            this.startOffset = n2;
            this.endOffset = n3;
        }
    }

    public static enum Action {
        REFORMAT,
        INDENT,
        REFORMAT_WITH_CONTEXT,
        REFORMAT_WITH_INSERTED_LINE_CONTEXT;

    }

    public static interface TestFormatAction {
        public void run(PsiFile var1, int var2, int var3);
    }
}

