/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.CreateLibraryFromFilesDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MarkLibraryRootAction
extends AnAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)anActionEvent);
        if (project2 == null) {
            return;
        }
        List<VirtualFile> list2 = MarkLibraryRootAction.a(anActionEvent);
        if (list2.isEmpty()) {
            return;
        }
        List list3 = RootDetectionUtil.detectRoots(list2, null, (Project)project2, (LibraryRootsComponentDescriptor)new DefaultLibraryRootsComponentDescriptor());
        new CreateLibraryFromFilesDialog(project2, list3).show();
    }

    @NotNull
    private static List<VirtualFile> a(AnActionEvent anActionEvent) {
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)anActionEvent);
        VirtualFile[] virtualFileArray = (VirtualFile[])anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null || virtualFileArray == null || virtualFileArray.length == 0) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                MarkLibraryRootAction.a(0);
            }
            return list2;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (virtualFile.isDirectory()) {
                arrayList.add(virtualFile);
                continue;
            }
            VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile);
            if (virtualFile2 == null) continue;
            arrayList.add(virtualFile2);
        }
        ArrayList<VirtualFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            MarkLibraryRootAction.a(1);
        }
        return arrayList2;
    }

    public void update(AnActionEvent anActionEvent) {
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)anActionEvent);
        boolean bl2 = false;
        if (project2 != null && ModuleManager.getInstance((Project)project2).getModules().length > 0) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            block0: for (VirtualFile virtualFile : MarkLibraryRootAction.a(anActionEvent)) {
                if (!virtualFile.isInLocalFileSystem() && FileUtilRt.extensionEquals((String)virtualFile.getName(), (String)"jar") && !projectFileIndex.isInLibraryClasses(virtualFile)) {
                    bl2 = true;
                    break;
                }
                if (!virtualFile.isInLocalFileSystem() || !virtualFile.isDirectory()) continue;
                for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                    VirtualFile virtualFile3;
                    if (!FileUtilRt.extensionEquals((String)virtualFile2.getName(), (String)"jar") || (virtualFile3 = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile2)) == null || projectFileIndex.isInLibraryClasses(virtualFile2)) continue;
                    bl2 = true;
                    continue block0;
                }
            }
        }
        anActionEvent.getPresentation().setVisible(bl2);
        anActionEvent.getPresentation().setEnabled(bl2);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/actions/MarkLibraryRootAction", "getRoots"));
    }
}

