/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class DetectedRootsChooser {
    private static final int b = new JCheckBox().getPreferredSize().width + 4;
    private final ColumnInfo<DetectedRootData, Boolean> d = new ColumnInfo<DetectedRootData, Boolean>(""){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.isIncluded();
        }

        public boolean isCellEditable(DetectedRootData detectedRootData) {
            return true;
        }

        public int getWidth(JTable jTable) {
            return b;
        }

        public void setValue(DetectedRootData detectedRootData, Boolean bl2) {
            if (bl2.booleanValue() != detectedRootData.isIncluded()) {
                detectedRootData.setIncluded(bl2);
                ((RootSelectionListener)DetectedRootsChooser.this.e.getMulticaster()).selectionChanged();
            }
        }
    };
    private static final ColumnInfo<DetectedRootData, String> g = new ColumnInfo<DetectedRootData, String>(""){

        public String valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.getDirectory().getAbsolutePath();
        }
    };
    private static final ColumnInfo<DetectedRootData, DetectedProjectRoot> f = new ColumnInfo<DetectedRootData, DetectedProjectRoot>(""){

        public DetectedProjectRoot valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.getSelectedRoot();
        }

        public TableCellRenderer getRenderer(DetectedRootData detectedRootData) {
            if (this.isCellEditable(detectedRootData)) {
                return new ComboBoxTableRenderer<DetectedProjectRoot>(detectedRootData.getAllRoots()){

                    protected String getTextFor(@NotNull DetectedProjectRoot detectedProjectRoot) {
                        if (detectedProjectRoot == null) {
                            1.a(0);
                        }
                        return detectedProjectRoot.getRootTypeName();
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/importProject/DetectedRootsChooser$3$1", "getTextFor"));
                    }
                };
            }
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                    if (object instanceof DetectedProjectRoot) {
                        this.setText(((DetectedProjectRoot)object).getRootTypeName());
                    }
                    return component;
                }
            };
        }

        public TableCellEditor getEditor(DetectedRootData detectedRootData) {
            ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(detectedRootData.getAllRoots()), (Object)detectedRootData.getSelectedRoot()));
            comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DetectedProjectRoot>(){

                public void customize(JList jList, DetectedProjectRoot detectedProjectRoot, int n2, boolean bl2, boolean bl3) {
                    this.setText(detectedProjectRoot.getRootTypeName());
                }
            });
            return new DefaultCellEditor((JComboBox<?>)comboBox);
        }

        public boolean isCellEditable(DetectedRootData detectedRootData) {
            return detectedRootData.getAllRoots().length > 1;
        }

        public void setValue(DetectedRootData detectedRootData, DetectedProjectRoot detectedProjectRoot) {
            detectedRootData.setSelectedRoot(detectedProjectRoot);
        }
    };
    private final TableView<DetectedRootData> c;
    private final JComponent h;
    private final ListTableModel<DetectedRootData> a;
    private final EventDispatcher<RootSelectionListener> e = EventDispatcher.create(RootSelectionListener.class);

    public DetectedRootsChooser() {
        this.a = new ListTableModel(new ColumnInfo[0]);
        this.c = new TableView(this.a);
        this.c.setTableHeader(null);
        this.c.setShowGrid(false);
        this.h = ScrollPaneFactory.createScrollPane(this.c);
        this.c.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DetectedRootsChooser.this.a();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private void a() {
        int[] nArray = this.c.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        boolean bl2 = false;
        for (int n2 : nArray) {
            bl2 |= ((DetectedRootData)this.a.getItems().get(n2)).isIncluded();
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int n5 : nArray) {
            n3 = Math.min(n3, n5);
            n4 = Math.max(n4, n5);
            ((DetectedRootData)this.a.getItems().get(n5)).setIncluded(!bl2);
        }
        this.a.fireTableRowsUpdated(n3, n4 + 1);
        ((RootSelectionListener)this.e.getMulticaster()).selectionChanged();
    }

    public JComponent getComponent() {
        return this.h;
    }

    public void addSelectionListener(RootSelectionListener rootSelectionListener) {
        this.e.addListener((EventListener)rootSelectionListener);
    }

    public void setAllElementsMarked(boolean bl2) {
        for (DetectedRootData detectedRootData : this.a.getItems()) {
            detectedRootData.setIncluded(bl2);
        }
        this.a.fireTableRowsUpdated(0, this.a.getRowCount() - 1);
        ((RootSelectionListener)this.e.getMulticaster()).selectionChanged();
    }

    public List<DetectedRootData> getMarkedElements() {
        ArrayList<DetectedRootData> arrayList = new ArrayList<DetectedRootData>();
        for (DetectedRootData detectedRootData : this.a.getItems()) {
            if (!detectedRootData.isIncluded()) continue;
            arrayList.add(detectedRootData);
        }
        return arrayList;
    }

    public void setElements(List<? extends DetectedRootData> list2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (DetectedRootData object2 : list2) {
            for (DetectedProjectRoot detectedProjectRoot : object2.getAllRoots()) {
                hashSet.add(detectedProjectRoot.getRootTypeName());
            }
        }
        this.a.setColumnInfos(new ColumnInfo[]{this.d, g, f});
        int n2 = 0;
        for (String string : hashSet) {
            n2 = Math.max(n2, this.c.getFontMetrics(this.c.getFont()).stringWidth(string));
        }
        TableColumn tableColumn = this.c.getColumnModel().getColumn(2);
        int n3 = n2 + 20;
        tableColumn.setPreferredWidth(n3);
        tableColumn.setMaxWidth(n3);
        this.c.updateColumnSizes();
        ArrayList<? extends DetectedRootData> arrayList = new ArrayList<DetectedRootData>(list2);
        Collections.sort(arrayList, Comparator.comparing(DetectedRootData::getDirectory));
        this.a.setItems(arrayList);
    }

    static interface RootSelectionListener
    extends EventListener {
        public void selectionChanged();
    }
}

