/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleDescriptor {
    private String b;
    private final MultiMap<File, DetectedSourceRoot> c = new MultiMap();
    private final Set<File> a = new HashSet<File>();
    private final Set<ModuleDescriptor> g = new HashSet<ModuleDescriptor>();
    private static final Set<String> e = new THashSet(Arrays.asList("java", "src", "source", "sources", "C:", "D:", "E:", "F:", "temp", "tmp"), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private boolean d;
    private final List<ModuleBuilder.ModuleConfigurationUpdater> h = new SmartList();
    private final ModuleType f;

    public ModuleDescriptor(File file, ModuleType moduleType, Collection<? extends DetectedSourceRoot> collection) {
        this.b = ModuleDescriptor.a(file);
        this.c.putValues((Object)file, collection);
        this.f = moduleType;
    }

    public ModuleDescriptor(File file, ModuleType moduleType, DetectedSourceRoot detectedSourceRoot) {
        this(file, moduleType, Collections.singletonList(detectedSourceRoot));
    }

    public void reuseExisting(boolean bl2) {
        this.d = bl2;
    }

    public void addConfigurationUpdater(ModuleBuilder.ModuleConfigurationUpdater moduleConfigurationUpdater) {
        this.h.add(moduleConfigurationUpdater);
    }

    public void updateModuleConfiguration(Module module2, ModifiableRootModel modifiableRootModel) {
        for (ModuleBuilder.ModuleConfigurationUpdater moduleConfigurationUpdater : this.h) {
            moduleConfigurationUpdater.update(module2, modifiableRootModel);
        }
    }

    public boolean isReuseExistingElement() {
        return this.d;
    }

    public ModuleType getModuleType() {
        return this.f;
    }

    private static String a(File file) {
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            String string = file2.getName();
            if (e.contains(string)) continue;
            return string;
        }
        return file.getName();
    }

    public String getName() {
        return this.b;
    }

    public void setName(String string) {
        this.b = string;
    }

    public Set<File> getContentRoots() {
        return Collections.unmodifiableSet(this.c.keySet());
    }

    public Collection<? extends DetectedProjectRoot> getSourceRoots() {
        return this.c.values();
    }

    public Collection<DetectedSourceRoot> getSourceRoots(File file) {
        return this.c.get((Object)file);
    }

    public void addContentRoot(File file) {
        this.c.put((Object)file, new HashSet());
    }

    public Collection<DetectedSourceRoot> removeContentRoot(File file) {
        return this.c.remove((Object)file);
    }

    public void addSourceRoot(File file, DetectedSourceRoot detectedSourceRoot) {
        this.c.putValue((Object)file, (Object)detectedSourceRoot);
    }

    public void addDependencyOn(ModuleDescriptor moduleDescriptor) {
        this.g.add(moduleDescriptor);
    }

    public void removeDependencyOn(ModuleDescriptor moduleDescriptor) {
        this.g.remove(moduleDescriptor);
    }

    public void addLibraryFile(File file) {
        this.a.add(file);
    }

    public Set<File> getLibraryFiles() {
        return this.a;
    }

    public Set<ModuleDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.g);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Module: ").append(this.getContentRoots()).append(" | ");
        for (DetectedProjectRoot detectedProjectRoot : this.getSourceRoots()) {
            stringBuilder.append(detectedProjectRoot.getDirectory().getName()).append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void clearModuleDependencies() {
        this.g.clear();
    }

    public void clearLibraryFiles() {
        this.a.clear();
    }

    @NotNull
    public String computeModuleFilePath() throws InvalidDataException {
        String string = this.getName();
        Set<File> set = this.getContentRoots();
        if (set.size() > 0) {
            String string2 = set.iterator().next().getPath() + File.separator + string + ".iml";
            if (string2 == null) {
                ModuleDescriptor.a(0);
            }
            return string2;
        }
        throw new InvalidDataException("Module " + string + " has no content roots and will not be created.");
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleDescriptor", "computeModuleFilePath"));
    }
}

