/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProgressIndicatorWrapper;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleInsight {
    private static final Logger h = Logger.getInstance((String)"#com.intellij.ide.util.importProject.ModuleInsight");
    @NotNull
    protected final ProgressIndicatorWrapper myProgress;
    private final Set<File> g = new HashSet<File>();
    private final List<DetectedSourceRoot> k = new ArrayList<DetectedSourceRoot>();
    private final Set<String> i = new HashSet<String>();
    private final Map<File, Set<String>> b = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> c = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> l = new HashMap<File, Set<String>>();
    private final StringInterner d = new StringInterner();
    private List<ModuleDescriptor> j;
    private List<LibraryDescriptor> e;
    private final Set<String> f;
    private final Set<String> a;

    public ModuleInsight(@Nullable ProgressIndicator progressIndicator, Set<String> set, Set<String> set2) {
        this.f = set;
        this.a = set2;
        this.myProgress = new ProgressIndicatorWrapper(progressIndicator);
        this.setRoots(Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    public final void setRoots(List<File> list2, List<? extends DetectedSourceRoot> list3, Set<String> set) {
        this.j = null;
        this.e = null;
        this.g.clear();
        this.g.addAll(list2);
        this.k.clear();
        this.k.addAll(list3);
        this.i.clear();
        this.i.addAll(set);
        this.l.clear();
        this.d.clear();
    }

    @Nullable
    public List<LibraryDescriptor> getSuggestedLibraries() {
        return this.e;
    }

    @Nullable
    public List<ModuleDescriptor> getSuggestedModules() {
        return this.j;
    }

    public void scanModules() {
        this.myProgress.setIndeterminate(true);
        HashMap<File, ModuleDescriptor> hashMap = new HashMap<File, ModuleDescriptor>();
        try {
            Object object;
            Serializable serializable;
            File file;
            this.myProgress.pushState();
            ArrayList<DetectedSourceRoot> arrayList = new ArrayList<DetectedSourceRoot>();
            for (DetectedSourceRoot detectedSourceRoot : this.getSourceRootsToScan()) {
                file = detectedSourceRoot.getDirectory();
                if (this.isIgnoredName(file)) continue;
                this.myProgress.setText("Scanning " + file.getPath());
                serializable = new HashSet();
                this.b.put(file, (Set<String>)((Object)serializable));
                object = new HashSet();
                this.addExportedPackages(file, (Set<String>)object);
                this.a(file, ProjectFromSourcesBuilderImpl.getPackagePrefix(detectedSourceRoot), (Set<String>)((Object)serializable), (Set<String>)object);
                serializable.removeAll((Collection<?>)object);
                arrayList.add(detectedSourceRoot);
            }
            this.myProgress.popState();
            this.myProgress.pushState();
            this.myProgress.setText("Building modules layout...");
            for (DetectedSourceRoot detectedSourceRoot : arrayList) {
                file = detectedSourceRoot.getDirectory();
                serializable = this.isEntryPointRoot(file) ? file : file.getParentFile();
                object = (ModuleDescriptor)hashMap.get(serializable);
                if (object != null) {
                    ((ModuleDescriptor)object).addSourceRoot((File)serializable, detectedSourceRoot);
                    continue;
                }
                object = this.createModuleDescriptor((File)serializable, (Collection<DetectedSourceRoot>)Collections.singletonList(detectedSourceRoot));
                hashMap.put((File)serializable, (ModuleDescriptor)object);
            }
            this.a(hashMap);
            this.myProgress.popState();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        this.addModules(hashMap.values());
    }

    protected void addExportedPackages(File file, Set<String> set) {
        this.c.put(file, set);
    }

    protected boolean isIgnoredName(File file) {
        return this.i.contains(file.getName());
    }

    protected void addModules(Collection<ModuleDescriptor> collection) {
        if (this.j == null) {
            this.j = new ArrayList<ModuleDescriptor>(collection);
        } else {
            this.j.addAll(collection);
        }
        HashSet<String> hashSet = new HashSet<String>(this.f);
        for (ModuleDescriptor moduleDescriptor : collection) {
            String string = ModuleInsight.a(hashSet, moduleDescriptor.getName());
            moduleDescriptor.setName(string);
            hashSet.add(string);
        }
    }

    @NotNull
    protected List<DetectedSourceRoot> getSourceRootsToScan() {
        List<DetectedSourceRoot> list2 = Collections.unmodifiableList(this.k);
        if (list2 == null) {
            ModuleInsight.a(0);
        }
        return list2;
    }

    protected boolean isEntryPointRoot(File file) {
        return this.g.contains(file);
    }

    protected abstract ModuleDescriptor createModuleDescriptor(File var1, Collection<DetectedSourceRoot> var2);

    private void a(Map<File, ModuleDescriptor> map) {
        Set<File> set = map.keySet();
        for (File file : set) {
            ModuleDescriptor moduleDescriptor = map.get(file);
            this.myProgress.setText2("Building library dependencies for module " + moduleDescriptor.getName());
            this.a(moduleDescriptor);
            this.myProgress.setText2("Building module dependencies for module " + moduleDescriptor.getName());
            block1: for (File file2 : set) {
                ModuleDescriptor moduleDescriptor2 = map.get(file2);
                if (moduleDescriptor.equals(moduleDescriptor2)) continue;
                Collection<? extends DetectedProjectRoot> collection = moduleDescriptor2.getSourceRoots();
                for (DetectedProjectRoot detectedProjectRoot : moduleDescriptor.getSourceRoots()) {
                    Set<String> set2 = this.b.get(detectedProjectRoot.getDirectory());
                    for (DetectedProjectRoot detectedProjectRoot2 : collection) {
                        if (!ContainerUtil.intersects(set2, (Collection)this.c.get(detectedProjectRoot2.getDirectory()))) continue;
                        moduleDescriptor.addDependencyOn(moduleDescriptor2);
                        continue block1;
                    }
                }
            }
        }
    }

    private void a(ModuleDescriptor moduleDescriptor) {
        block0: for (File file : this.l.keySet()) {
            Set<String> set = this.l.get(file);
            for (DetectedProjectRoot detectedProjectRoot : moduleDescriptor.getSourceRoots()) {
                if (!ContainerUtil.intersects((Collection)this.b.get(detectedProjectRoot.getDirectory()), set)) continue;
                moduleDescriptor.addLibraryFile(file);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanLibraries() {
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            try {
                for (File serializable2 : this.g) {
                    this.myProgress.setText("Scanning for libraries " + serializable2.getPath());
                    this.a(serializable2);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            this.myProgress.setText("Building initial libraries layout...");
            List<LibraryDescriptor> list2 = ModuleInsight.a(this.l.keySet());
            HashSet<String> hashSet = new HashSet<String>(this.a);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                LibraryDescriptor libraryDescriptor = (LibraryDescriptor)iterator.next();
                Collection<File> collection = libraryDescriptor.getJars();
                String string = ModuleInsight.a(hashSet, collection.size() == 1 ? FileUtil.getNameWithoutExtension((File)collection.iterator().next()) : libraryDescriptor.getName());
                libraryDescriptor.setName(string);
                hashSet.add(string);
            }
            this.e = list2;
        }
        finally {
            this.myProgress.popState();
        }
    }

    public abstract boolean isApplicableRoot(DetectedProjectRoot var1);

    private static String a(Set<String> set, String string) {
        String string2 = string;
        int n2 = 1;
        while (set.contains(string2)) {
            string2 = string + n2++;
        }
        return string2;
    }

    public void merge(ModuleDescriptor moduleDescriptor, ModuleDescriptor moduleDescriptor2) {
        for (File object : moduleDescriptor2.getContentRoots()) {
            File file = ModuleInsight.a(moduleDescriptor, object);
            Collection<DetectedSourceRoot> collection = moduleDescriptor2.getSourceRoots(object);
            for (DetectedSourceRoot detectedSourceRoot : collection) {
                moduleDescriptor.addSourceRoot(file, detectedSourceRoot);
            }
        }
        for (File file : moduleDescriptor2.getLibraryFiles()) {
            moduleDescriptor.addLibraryFile(file);
        }
        for (ModuleDescriptor moduleDescriptor3 : moduleDescriptor2.getDependencies()) {
            if (moduleDescriptor.equals(moduleDescriptor3)) continue;
            moduleDescriptor.addDependencyOn(moduleDescriptor3);
        }
        this.j.remove(moduleDescriptor2);
        for (ModuleDescriptor moduleDescriptor4 : this.j) {
            if (!moduleDescriptor4.getDependencies().contains(moduleDescriptor2)) continue;
            moduleDescriptor4.removeDependencyOn(moduleDescriptor2);
            if (moduleDescriptor4.equals(moduleDescriptor)) continue;
            moduleDescriptor4.addDependencyOn(moduleDescriptor);
        }
    }

    public LibraryDescriptor splitLibrary(LibraryDescriptor libraryDescriptor, String string, Collection<File> collection) {
        LibraryDescriptor libraryDescriptor2 = new LibraryDescriptor(string, collection);
        this.e.add(libraryDescriptor2);
        libraryDescriptor.removeJars(collection);
        if (libraryDescriptor.getJars().size() == 0) {
            this.removeLibrary(libraryDescriptor);
        }
        return libraryDescriptor2;
    }

    @Nullable
    public ModuleDescriptor splitModule(ModuleDescriptor moduleDescriptor, String string, Collection<File> collection) {
        ModuleDescriptor moduleDescriptor2 = null;
        for (File object3 : collection) {
            HashSet hashSet = moduleDescriptor.removeContentRoot(object3);
            if (moduleDescriptor2 == null) {
                moduleDescriptor2 = this.createModuleDescriptor(object3, hashSet != null ? hashSet : new HashSet());
                continue;
            }
            if (hashSet != null && hashSet.size() > 0) {
                for (Object object : hashSet) {
                    moduleDescriptor2.addSourceRoot(object3, (DetectedSourceRoot)object);
                }
                continue;
            }
            moduleDescriptor2.addContentRoot(object3);
        }
        if (moduleDescriptor2 == null) {
            return null;
        }
        moduleDescriptor2.setName(string);
        this.j.add(moduleDescriptor2);
        HashMap hashMap = new HashMap();
        for (ModuleDescriptor moduleDescriptor3 : this.j) {
            Object object;
            Set<File> set = moduleDescriptor3.getContentRoots();
            object = set.iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                hashMap.put(file, moduleDescriptor3);
            }
            moduleDescriptor3.clearModuleDependencies();
            moduleDescriptor3.clearLibraryFiles();
        }
        this.a(hashMap);
        return moduleDescriptor2;
    }

    public void removeLibrary(LibraryDescriptor libraryDescriptor) {
        this.e.remove(libraryDescriptor);
    }

    public void moveJarsToLibrary(LibraryDescriptor libraryDescriptor, Collection<File> collection, LibraryDescriptor libraryDescriptor2) {
        libraryDescriptor2.addJars(collection);
        libraryDescriptor.removeJars(collection);
        if (libraryDescriptor.getJars().size() == 0) {
            this.removeLibrary(libraryDescriptor);
        }
    }

    public Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor moduleDescriptor) {
        return ModuleInsight.getLibraryDependencies(moduleDescriptor, this.e);
    }

    public static Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor moduleDescriptor, @Nullable List<LibraryDescriptor> list2) {
        HashSet<LibraryDescriptor> hashSet = new HashSet<LibraryDescriptor>();
        if (list2 != null) {
            for (LibraryDescriptor libraryDescriptor : list2) {
                if (!ContainerUtil.intersects(libraryDescriptor.getJars(), moduleDescriptor.getLibraryFiles())) continue;
                hashSet.add(libraryDescriptor);
            }
        }
        return hashSet;
    }

    private static File a(ModuleDescriptor moduleDescriptor, File file) {
        Set<File> set = moduleDescriptor.getContentRoots();
        for (File file2 : set) {
            if (FileUtil.isAncestor((File)file2, (File)file, (boolean)false)) {
                return file2;
            }
            if (!FileUtil.isAncestor((File)file, (File)file2, (boolean)true)) continue;
            Collection<DetectedSourceRoot> collection = moduleDescriptor.getSourceRoots(file2);
            moduleDescriptor.removeContentRoot(file2);
            moduleDescriptor.addContentRoot(file);
            for (DetectedSourceRoot detectedSourceRoot : collection) {
                moduleDescriptor.addSourceRoot(file, detectedSourceRoot);
            }
            return file;
        }
        moduleDescriptor.addContentRoot(file);
        return file;
    }

    private static List<LibraryDescriptor> a(Set<File> set) {
        HashMap<File, LibraryDescriptor> hashMap = new HashMap<File, LibraryDescriptor>();
        for (File file : set) {
            File file2 = file.getParentFile();
            LibraryDescriptor libraryDescriptor = (LibraryDescriptor)hashMap.get(file2);
            if (libraryDescriptor == null) {
                libraryDescriptor = new LibraryDescriptor(file2.getName(), new HashSet<File>());
                hashMap.put(file2, libraryDescriptor);
            }
            libraryDescriptor.addJars(Collections.singleton(file));
        }
        return new ArrayList<LibraryDescriptor>(hashMap.values());
    }

    private void a(File file, String string, Set<String> set, Set<String> set2) {
        if (this.isIgnoredName(file)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            this.myProgress.checkCanceled();
            boolean bl2 = false;
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    String string2 = string + (string.isEmpty() ? "" : ".") + file2.getName();
                    this.a(file2, string2, set, set2);
                    continue;
                }
                if (!this.isSourceFile(file2)) continue;
                bl2 = true;
                this.a(file2, set);
            }
            if (bl2) {
                set2.add((String)this.d.intern((Object)string));
            }
        }
    }

    protected abstract boolean isSourceFile(File var1);

    private void a(File file, Set<String> set) {
        this.myProgress.setText2(file.getName());
        try {
            char[] cArray = FileUtil.loadFileText((File)file);
            this.scanSourceFileForImportedPackages(StringFactory.createShared((char[])cArray), (Consumer<String>)((Consumer)string -> set.add((String)this.d.intern(string))));
        }
        catch (IOException iOException) {
            h.info((Throwable)iOException);
        }
    }

    protected abstract void scanSourceFileForImportedPackages(CharSequence var1, Consumer<String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file) {
        if (this.isIgnoredName(file)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            this.myProgress.checkCanceled();
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.a(file2);
                    continue;
                }
                String string2 = file2.getName();
                if (!this.isLibraryFile(string2) || this.l.containsKey(file2)) continue;
                HashSet hashSet = new HashSet();
                this.l.put(file2, hashSet);
                this.myProgress.pushState();
                this.myProgress.setText2(file2.getName());
                try {
                    this.scanLibraryForDeclaredPackages(file2, (Consumer<String>)((Consumer)string -> {
                        if (!hashSet.contains(string)) {
                            hashSet.add(this.d.intern(string));
                        }
                    }));
                }
                catch (IOException iOException) {
                    h.info((Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    h.info((Throwable)illegalArgumentException);
                }
                catch (InternalError internalError) {
                    h.info((Throwable)internalError);
                }
                finally {
                    this.myProgress.popState();
                }
            }
        }
    }

    protected abstract boolean isLibraryFile(String var1);

    protected abstract void scanLibraryForDeclaredPackages(File var1, Consumer<String> var2) throws IOException;

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleInsight", "getSourceRootsToScan"));
    }
}

