/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.impl;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNodeBase;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportModelBase
extends UserDataHolderBase
implements FrameworkSupportModel {
    private final Project e;
    private final ModuleBuilder h;
    private final LibrariesContainer g;
    private final EventDispatcher<FrameworkSupportModelListener> i;
    private final EventDispatcher<FrameworkVersionListener> j;
    private final Map<String, FrameworkSupportNode> b;
    private final Map<String, FrameworkSupportOptionsComponent> d;
    private final Map<String, FrameworkVersion> a;
    private final Map<String, String> f;
    private FrameworkLibraryProvider c;

    public FrameworkSupportModelBase(@Nullable Project project2, @Nullable ModuleBuilder moduleBuilder, @NotNull LibrariesContainer librariesContainer) {
        if (librariesContainer == null) {
            FrameworkSupportModelBase.a(0);
        }
        this.i = EventDispatcher.create(FrameworkSupportModelListener.class);
        this.j = EventDispatcher.create(FrameworkVersionListener.class);
        this.b = new HashMap<String, FrameworkSupportNode>();
        this.d = new HashMap<String, FrameworkSupportOptionsComponent>();
        this.a = new HashMap<String, FrameworkVersion>();
        this.f = new HashMap<String, String>();
        this.e = project2;
        this.h = moduleBuilder;
        this.g = librariesContainer;
    }

    @NotNull
    public abstract String getBaseDirectoryForLibrariesPath();

    public void registerComponent(@NotNull FrameworkSupportInModuleProvider frameworkSupportInModuleProvider, @NotNull FrameworkSupportNode frameworkSupportNode) {
        if (frameworkSupportInModuleProvider == null) {
            FrameworkSupportModelBase.a(1);
        }
        if (frameworkSupportNode == null) {
            FrameworkSupportModelBase.a(2);
        }
        this.b.put(frameworkSupportInModuleProvider.getFrameworkType().getId(), frameworkSupportNode);
    }

    public void registerOptionsComponent(FrameworkSupportInModuleProvider frameworkSupportInModuleProvider, FrameworkSupportOptionsComponent frameworkSupportOptionsComponent) {
        this.d.put(frameworkSupportInModuleProvider.getFrameworkType().getId(), frameworkSupportOptionsComponent);
    }

    public Project getProject() {
        return this.e;
    }

    public ModuleBuilder getModuleBuilder() {
        return this.h;
    }

    public boolean isFrameworkSelected(@NotNull @NonNls String string) {
        FrameworkSupportNode frameworkSupportNode;
        if (string == null) {
            FrameworkSupportModelBase.a(3);
        }
        return (frameworkSupportNode = this.b.get(string)) != null && frameworkSupportNode.isChecked();
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener frameworkSupportModelListener) {
        if (frameworkSupportModelListener == null) {
            FrameworkSupportModelBase.a(4);
        }
        this.i.addListener((EventListener)frameworkSupportModelListener);
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener frameworkSupportModelListener, @NotNull Disposable disposable) {
        if (frameworkSupportModelListener == null) {
            FrameworkSupportModelBase.a(5);
        }
        if (disposable == null) {
            FrameworkSupportModelBase.a(6);
        }
        this.i.addListener((EventListener)frameworkSupportModelListener, disposable);
    }

    public void addFrameworkVersionListener(@NotNull FrameworkVersionListener frameworkVersionListener, @NotNull Disposable disposable) {
        if (frameworkVersionListener == null) {
            FrameworkSupportModelBase.a(7);
        }
        if (disposable == null) {
            FrameworkSupportModelBase.a(8);
        }
        this.j.addListener((EventListener)frameworkVersionListener, disposable);
    }

    public void removeFrameworkListener(@NotNull FrameworkSupportModelListener frameworkSupportModelListener) {
        if (frameworkSupportModelListener == null) {
            FrameworkSupportModelBase.a(9);
        }
        this.i.removeListener((EventListener)frameworkSupportModelListener);
    }

    public void setFrameworkComponentEnabled(@NotNull @NonNls String string, boolean bl2) {
        FrameworkSupportNode frameworkSupportNode;
        if (string == null) {
            FrameworkSupportModelBase.a(10);
        }
        if ((frameworkSupportNode = this.b.get(string)) != null && bl2 != frameworkSupportNode.isChecked()) {
            frameworkSupportNode.setChecked(bl2);
            frameworkSupportNode.getConfigurable();
            if (this.f.get(string) == null) {
                for (FrameworkVersion frameworkVersion : ((FrameworkSupportInModuleProvider)frameworkSupportNode.getUserObject()).getFrameworkType().getVersions()) {
                    if (!frameworkVersion.getAvailabilityCondition().isAvailableFor((FrameworkSupportModel)this)) continue;
                    this.setSelectedVersion(string, frameworkVersion);
                }
            }
        }
    }

    public void updateFrameworkLibraryComponent(@NotNull String string) {
        FrameworkSupportOptionsComponent frameworkSupportOptionsComponent;
        if (string == null) {
            FrameworkSupportModelBase.a(11);
        }
        if ((frameworkSupportOptionsComponent = this.d.get(string)) != null) {
            frameworkSupportOptionsComponent.updateLibrariesPanel();
        }
    }

    public FrameworkSupportConfigurable getFrameworkConfigurable(@NotNull @NonNls String string) {
        FrameworkSupportConfigurable frameworkSupportConfigurable;
        if (string == null) {
            FrameworkSupportModelBase.a(12);
        }
        if ((frameworkSupportConfigurable = this.findFrameworkConfigurable(string)) == null) {
            throw new IllegalArgumentException("provider '" + string + "' not found");
        }
        return frameworkSupportConfigurable;
    }

    @Nullable
    public FrameworkSupportConfigurable findFrameworkConfigurable(@NotNull @NonNls String string) {
        FrameworkSupportNode frameworkSupportNode;
        if (string == null) {
            FrameworkSupportModelBase.a(13);
        }
        if ((frameworkSupportNode = this.b.get(string)) == null) {
            return null;
        }
        return ((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)frameworkSupportNode.getConfigurable()).getConfigurable();
    }

    public void setSelectedVersion(@NotNull String string, @NotNull FrameworkVersion frameworkVersion) {
        FrameworkVersion frameworkVersion2;
        if (string == null) {
            FrameworkSupportModelBase.a(14);
        }
        if (frameworkVersion == null) {
            FrameworkSupportModelBase.a(15);
        }
        if (!Comparing.equal((Object)(frameworkVersion2 = this.a.put(string, frameworkVersion)), (Object)frameworkVersion)) {
            for (Map.Entry<String, FrameworkSupportNode> entry : this.b.entrySet()) {
                FrameworkSupportOptionsComponent frameworkSupportOptionsComponent;
                if (!FrameworkSupportModelBase.a(entry.getValue(), string)) continue;
                if (!entry.getValue().getId().equals(string) && (frameworkSupportOptionsComponent = this.d.get(entry.getKey())) != null) {
                    frameworkSupportOptionsComponent.updateVersionsComponent();
                }
                this.updateFrameworkLibraryComponent(entry.getKey());
            }
        }
        ((FrameworkVersionListener)this.j.getMulticaster()).versionChanged(frameworkVersion);
    }

    private static boolean a(FrameworkSupportNode frameworkSupportNode, @NotNull String string) {
        if (string == null) {
            FrameworkSupportModelBase.a(16);
        }
        for (FrameworkSupportNodeBase frameworkSupportNodeBase = frameworkSupportNode; frameworkSupportNodeBase != null; frameworkSupportNodeBase = frameworkSupportNodeBase.getParentNode()) {
            if (!frameworkSupportNodeBase.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public FrameworkLibraryProvider getLibraryProvider() {
        return this.c;
    }

    public void setLibraryProvider(@Nullable FrameworkLibraryProvider frameworkLibraryProvider) {
        this.c = frameworkLibraryProvider;
        for (FrameworkSupportOptionsComponent frameworkSupportOptionsComponent : this.d.values()) {
            frameworkSupportOptionsComponent.updateLibrariesPanel();
        }
    }

    @Nullable
    public <V extends FrameworkVersion> V getSelectedVersion(@NotNull String string) {
        if (string == null) {
            FrameworkSupportModelBase.a(17);
        }
        return (V)this.a.get(string);
    }

    public void onFrameworkSelectionChanged(FrameworkSupportNode frameworkSupportNode) {
        FrameworkSupportInModuleProvider frameworkSupportInModuleProvider = (FrameworkSupportInModuleProvider)frameworkSupportNode.getUserObject();
        boolean bl2 = frameworkSupportNode.isChecked();
        if (frameworkSupportInModuleProvider instanceof OldFrameworkSupportProviderWrapper) {
            FrameworkSupportProvider frameworkSupportProvider = ((OldFrameworkSupportProviderWrapper)frameworkSupportInModuleProvider).getProvider();
            this.selectFramework(frameworkSupportProvider, bl2);
        }
        for (FrameworkSupportInModuleProvider.FrameworkDependency frameworkDependency : frameworkSupportInModuleProvider.getDependenciesFrameworkIds()) {
            if (frameworkDependency.isOptional()) continue;
            String string = frameworkDependency.getFrameworkId();
            this.setFrameworkComponentEnabled(string, true);
        }
    }

    public void selectFramework(FrameworkSupportProvider frameworkSupportProvider, boolean bl2) {
        FrameworkSupportModelListener frameworkSupportModelListener = (FrameworkSupportModelListener)this.i.getMulticaster();
        if (bl2) {
            frameworkSupportModelListener.frameworkSelected(frameworkSupportProvider);
        } else {
            frameworkSupportModelListener.frameworkUnselected(frameworkSupportProvider);
        }
    }

    public void fireWizardStepUpdated() {
        ((FrameworkSupportModelListener)this.i.getMulticaster()).wizardStepUpdated();
    }

    @NotNull
    public LibrariesContainer getLibrariesContainer() {
        LibrariesContainer librariesContainer = this.g;
        if (librariesContainer == null) {
            FrameworkSupportModelBase.a(18);
        }
        return librariesContainer;
    }

    public void setSelectedLibraryVersion(String string, String string2) {
        this.f.put(string, string2);
        ((FrameworkVersionListener)this.j.getMulticaster()).versionChanged((FrameworkVersion)this.getSelectedVersion(string));
    }

    public String getFrameworkVersion(String string) {
        FrameworkVersion frameworkVersion = this.a.get(string);
        return frameworkVersion == null ? this.f.get(string) : frameworkVersion.getVersionNumber();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 18: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkOrGroupId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesContainer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkSelected";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFrameworkListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFrameworkVersionListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFrameworkListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkComponentEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameworkLibraryComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkConfigurable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkConfigurable";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedVersion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasParentWithId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedVersion";
                break;
            }
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

