/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.SwingWorker;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractStepWithProgress<Result>
extends ModuleWizardStep {
    @NonNls
    private static final String h = "progress_panel";
    @NonNls
    private static final String e = "results_panel";
    private JPanel f;
    private JLabel g;
    private JLabel d;
    private JLabel b;
    private ProgressIndicator c = null;
    private final String a;

    public AbstractStepWithProgress(String string) {
        this.a = string;
    }

    public final JComponent getComponent() {
        if (this.f == null) {
            this.f = new JPanel(new CardLayout());
            this.f.setBorder(BorderFactory.createEtchedBorder());
            this.f.add((Component)this.b(), h);
            this.f.add((Component)this.createResultsPanel(), e);
        }
        return this.f;
    }

    protected abstract JComponent createResultsPanel();

    protected abstract String getProgressText();

    protected abstract boolean shouldRunProgress();

    protected abstract Result calculate();

    protected abstract void onFinished(Result var1, boolean var2);

    private JPanel b() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.g = new JLabel();
        this.g.setFont(UIUtil.getLabelFont().deriveFont(1));
        jPanel.add((Component)this.g, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)5, (int)10), 0, 0));
        this.d = new JLabel();
        jPanel.add((Component)this.d, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.b = new JLabel(){

            @Override
            public void setText(String string) {
                super.setText(StringUtil.trimMiddle((String)string, (int)80));
            }
        };
        jPanel.add((Component)this.b, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.stop.searching", (Object[])new Object[0]));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStepWithProgress.this.d();
            }
        });
        jPanel.add((Component)jButton, new GridBagConstraints(1, -1, 1, 2, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)10), 0, 0));
        return jPanel;
    }

    public void performStep() {
        Result Result2 = this.calculate();
        this.createResultsPanel();
        this.onFinished(Result2, false);
        this.updateDataModel();
    }

    private void d() {
        if (this.c != null) {
            this.c.cancel();
        }
    }

    private synchronized boolean c() {
        return this.c != null && this.c.isRunning();
    }

    public void updateStep() {
        if (this.shouldRunProgress()) {
            this.runProgress();
        } else {
            this.a(e);
        }
    }

    protected void runProgress() {
        final MyProgressIndicator myProgressIndicator = new MyProgressIndicator();
        myProgressIndicator.setModalityProgress(null);
        String string = this.getProgressText();
        if (string != null) {
            this.g.setText(string);
        }
        this.a(h);
        this.c = myProgressIndicator;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Object object = ProgressManager.getInstance().runProcess(() -> this.calculate(), (ProgressIndicator)myProgressIndicator);
            this.onFinished(object, false);
            return;
        }
        UiNotifyConnector.doWhenFirstShown((JComponent)this.f, () -> new SwingWorker(){

            public Object construct() {
                Ref ref = Ref.create(null);
                ProgressManager.getInstance().runProcess(() -> ref.set(AbstractStepWithProgress.this.calculate()), (ProgressIndicator)myProgressIndicator);
                return ref.get();
            }

            public void finished() {
                AbstractStepWithProgress.this.c = null;
                ApplicationManager.getApplication().invokeLater(() -> {
                    Object object = this.get();
                    AbstractStepWithProgress.this.onFinished(object, myProgressIndicator.isCanceled());
                    AbstractStepWithProgress.this.a(AbstractStepWithProgress.e);
                });
            }
        }.start());
    }

    private void a(String string) {
        ((CardLayout)this.f.getLayout()).show(this.f, string);
        this.f.revalidate();
    }

    public boolean validate() throws ConfigurationException {
        if (this.c()) {
            int n2 = Messages.showOkCancelDialog((Component)this.getComponent(), (String)this.a, (String)IdeBundle.message((String)"title.question", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.continue.searching", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.stop.searching", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (n2 != 0) {
                this.d();
            }
            return false;
        }
        return true;
    }

    public void onStepLeaving() {
        if (this.c()) {
            this.d();
        }
    }

    protected class MyProgressIndicator
    extends ProgressIndicatorBase {
        protected MyProgressIndicator() {
        }

        public void setText(String string) {
            this.b(AbstractStepWithProgress.this.d, string);
            super.setText(string);
        }

        public void setText2(String string) {
            this.b(AbstractStepWithProgress.this.b, string);
            super.setText2(string);
        }

        private void b(JLabel jLabel, String string) {
            UIUtil.invokeLaterIfNeeded(() -> jLabel.setText(string));
        }
    }
}

