/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class NamePathComponent
extends JPanel {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.NamePathComponent");
    private final JTextField e = new JTextField();
    private final JTextField j;
    private boolean i = false;
    private boolean g = false;
    private boolean a = true;
    private boolean k = true;
    private boolean f = true;
    private final FieldPanel l;
    private final JLabel d;
    private final JLabel b;
    private boolean h;

    public NamePathComponent(String string, String string2, char c2, char c3, String string3, String string4) {
        this(string, string2, string3, string4, true);
    }

    public NamePathComponent(String string, String string2, String string3, String string4, boolean bl2) {
        this(string, string2, string3, string4, bl2, true);
    }

    public NamePathComponent(String string, String string2, String string3, String string4, boolean bl2, boolean bl3) {
        super(new GridBagLayout());
        this.e.setDocument(new NameFieldDocument());
        this.e.setPreferredSize(new Dimension(200, this.e.getPreferredSize().height));
        this.j = new JTextField();
        this.j.setDocument(new PathFieldDocument());
        this.j.setPreferredSize(new Dimension(200, this.j.getPreferredSize().height));
        this.d = new JLabel(string);
        if (bl3) {
            this.d.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        this.d.setLabelFor(this.e);
        JBInsets jBInsets = JBUI.insets((int)0, (int)0, (int)5, (int)4);
        this.add((Component)this.d, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)jBInsets, 0, 0));
        jBInsets = JBUI.insets((int)0, (int)0, (int)5, (int)0);
        this.add((Component)this.e, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)jBInsets, 0, 0));
        FileChooserDescriptor fileChooserDescriptor = (FileChooserDescriptor)BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR.clone();
        fileChooserDescriptor.setHideIgnored(bl2);
        BrowseFilesListener browseFilesListener = new BrowseFilesListener(this.j, string3, string4, fileChooserDescriptor){

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                NamePathComponent.this.g = true;
            }
        };
        this.l = new FieldPanel(this.j, null, null, (ActionListener)browseFilesListener, null);
        this.b = new JLabel(string2);
        this.b.setLabelFor(this.j);
        if (bl3) {
            this.b.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        jBInsets = JBUI.insets((int)0, (int)0, (int)5, (int)4);
        this.add((Component)this.b, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)jBInsets, 0, 0));
        jBInsets = JBUI.insets((int)0, (int)0, (int)5, (int)0);
        this.add((Component)this.l, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)jBInsets, 0, 0));
    }

    public static NamePathComponent initNamePathComponent(WizardContext wizardContext) {
        NamePathComponent namePathComponent = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))}), true, false);
        String string = wizardContext.getProjectFileDirectory();
        String string2 = wizardContext.getProjectName();
        String string3 = string2 != null ? string2 : ProjectWizardUtil.findNonExistingFileName(string, "untitled", "");
        namePathComponent.setPath(string2 == null ? string + File.separator + string3 : string);
        namePathComponent.setNameValue(string3);
        namePathComponent.getNameComponent().select(0, string3.length());
        return namePathComponent;
    }

    public boolean validateNameAndPath(WizardContext wizardContext, boolean bl2) throws ConfigurationException {
        String string = this.getNameValue();
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            throw new ConfigurationException(IdeBundle.message((String)"prompt.new.project.file.name", (Object[])new Object[]{applicationNamesInfo.getFullProductName(), wizardContext.getPresentationName()}));
        }
        String string2 = this.getPath();
        if (StringUtil.isEmptyOrSpaces((String)string2)) {
            throw new ConfigurationException(IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{wizardContext.getPresentationName()}));
        }
        if (this.h && !new File(string2).isAbsolute()) {
            throw new ConfigurationException(StringUtil.capitalize((String)IdeBundle.message((String)"file.location.should.be.absolute", (Object[])new Object[]{wizardContext.getPresentationName()})));
        }
        boolean bl3 = this.isPathChangedByUser();
        String string3 = IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{wizardContext.getPresentationName()});
        if (!ProjectWizardUtil.createDirectoryIfNotExists(string3, string2, bl3)) {
            return false;
        }
        File file = new File(string2);
        if (file.exists() && !file.canWrite()) {
            throw new ConfigurationException(String.format("Directory '%s' is not seem to be writable. Please consider another location.", string2));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((String)string2, (Project)project2)) continue;
            throw new ConfigurationException(String.format("Directory '%s' is already taken by the project '%s'. Please consider another location.", string2, project2.getName()));
        }
        boolean bl4 = true;
        String string4 = bl2 ? string + ".ipr" : ".idea";
        File file2 = new File(file, string4);
        if (file2.exists()) {
            string3 = IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{file2.getAbsolutePath(), wizardContext.getPresentationName()});
            int n2 = Messages.showYesNoDialog((String)string3, (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            bl4 = n2 == 0;
        }
        return bl4;
    }

    public String getNameValue() {
        return this.e.getText().trim();
    }

    public void setNameValue(String string) {
        boolean bl2 = this.i;
        this.a(false);
        try {
            this.e.setText(string);
        }
        finally {
            this.i = bl2;
            this.a(true);
        }
    }

    public String getPath() {
        String string = this.j.getText().trim();
        return FileUtil.expandUserHome((String)FileUtil.toSystemIndependentName((String)string));
    }

    public void setPath(String string) {
        boolean bl2 = this.g;
        this.b(false);
        try {
            this.j.setText(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)string)));
        }
        finally {
            this.g = bl2;
            this.b(true);
        }
    }

    public JTextField getNameComponent() {
        return this.e;
    }

    @NotNull
    public JLabel getPathLabel() {
        JLabel jLabel = this.b;
        if (jLabel == null) {
            NamePathComponent.a(0);
        }
        return jLabel;
    }

    public JTextField getPathComponent() {
        return this.j;
    }

    @NotNull
    public FieldPanel getPathPanel() {
        FieldPanel fieldPanel = this.l;
        if (fieldPanel == null) {
            NamePathComponent.a(1);
        }
        return fieldPanel;
    }

    public void setPathComponentVisible(boolean bl2) {
        this.l.setVisible(bl2);
    }

    public void setNameComponentVisible(boolean bl2) {
        this.e.setVisible(bl2);
        this.d.setVisible(bl2);
    }

    public boolean isNameChangedByUser() {
        return this.i;
    }

    public boolean isPathChangedByUser() {
        return this.g;
    }

    public boolean isSyncEnabled() {
        return this.f;
    }

    public void setSyncEnabled(boolean bl2) {
        this.f = bl2;
    }

    private boolean a() {
        if (!this.isSyncEnabled()) {
            return false;
        }
        return this.a;
    }

    private void b(boolean bl2) {
        this.a = bl2;
    }

    private boolean b() {
        if (!this.isSyncEnabled()) {
            return false;
        }
        return this.k;
    }

    private void a(boolean bl2) {
        this.k = bl2;
    }

    public void addChangeListener(final Runnable runnable) {
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                runnable.run();
            }
        };
        this.e.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.j.getDocument().addDocumentListener((DocumentListener)documentAdapter);
    }

    public void setShouldBeAbsolute(boolean bl2) {
        this.h = bl2;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/projectWizard/NamePathComponent";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathLabel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PathFieldDocument
    extends PlainDocument {
        public PathFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent documentEvent) {
                    NamePathComponent.this.g = true;
                    PathFieldDocument.this.a();
                }
            });
        }

        private void a() {
            if (NamePathComponent.this.a() && !NamePathComponent.this.i) {
                try {
                    NamePathComponent.this.a(false);
                    String string = this.getText(0, this.getLength());
                    int n2 = string.lastIndexOf(File.separator);
                    if (n2 >= 0 && n2 + 1 < string.length()) {
                        NamePathComponent.this.setNameValue(string.substring(n2 + 1));
                    }
                }
                catch (BadLocationException badLocationException) {
                    c.error((Throwable)badLocationException);
                }
                finally {
                    NamePathComponent.this.a(true);
                }
            }
        }
    }

    private class NameFieldDocument
    extends PlainDocument {
        public NameFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent documentEvent) {
                    NamePathComponent.this.i = true;
                    NameFieldDocument.this.a();
                }
            });
        }

        @Override
        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl2 = true;
            for (int i2 = 0; i2 < string.length() && bl2; ++i2) {
                char c2 = string.charAt(i2);
                bl2 = c2 != File.separatorChar && c2 != '\\' && c2 != '/' && c2 != '|' && c2 != ':';
            }
            if (bl2) {
                super.insertString(n2, string, attributeSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a() {
            if (NamePathComponent.this.b() && !NamePathComponent.this.g) {
                try {
                    NamePathComponent.this.b(false);
                    String string = this.getText(0, this.getLength());
                    String string2 = NamePathComponent.this.j.getText().trim();
                    int n2 = string2.lastIndexOf(File.separator);
                    if (n2 >= 0) {
                        NamePathComponent.this.setPath(string2.substring(0, n2 + 1) + string);
                    }
                }
                catch (BadLocationException badLocationException) {
                    c.error((Throwable)badLocationException);
                }
                finally {
                    NamePathComponent.this.b(true);
                }
            }
        }
    }
}

