/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkForModuleStep
extends ModuleWizardStep {
    private final JdkChooserPanel b;
    private final JPanel e;
    private final WizardContext f;
    private final SdkType a;
    private boolean d = false;
    private final JButton c;

    public ProjectJdkForModuleStep(final WizardContext wizardContext, final SdkType sdkType) {
        this.f = wizardContext;
        this.a = sdkType;
        this.b = new JdkChooserPanel(ProjectJdkForModuleStep.a(wizardContext, sdkType));
        this.e = new JPanel(new GridBagLayout());
        this.e.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel(IdeBundle.message((String)"prompt.please.select.module.jdk", (Object[])new Object[]{sdkType.getPresentableName()}));
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.e.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JLabel jLabel2 = new JLabel(IdeBundle.message((String)"label.project.jdk", (Object[])new Object[0]));
        jLabel2.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.e.add((Component)jLabel2, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.e.add((Component)this.b, new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)2, (int)10, (int)10, (int)5), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.configure", (Object[])new Object[0]));
        this.e.add((Component)jButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)0, (int)5, (int)5), 0, 0));
        this.c = new JButton("Set Default");
        this.c.setMnemonic('D');
        this.e.add((Component)this.c, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)2, (int)0, (int)10, (int)5), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Project project2 = ProjectJdkForModuleStep.a(wizardContext, sdkType);
                ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(project2);
                JdkListConfigurable jdkListConfigurable = JdkListConfigurable.getInstance(project2);
                ProjectSdksModel projectSdksModel = projectStructureConfigurable.getProjectJdksModel();
                boolean[] blArray = new boolean[1];
                projectSdksModel.reset(project2);
                projectSdksModel.doAdd((JComponent)ProjectJdkForModuleStep.this.e, sdkType, sdk -> {
                    blArray[0] = jdkListConfigurable.addJdkNode((Sdk)sdk, false);
                    ProjectJdkForModuleStep.this.b.updateList((Sdk)sdk, sdkType, projectSdksModel.getSdks());
                    if (!blArray[0]) {
                        try {
                            projectSdksModel.apply((MasterDetailsComponent)jdkListConfigurable);
                        }
                        catch (ConfigurationException configurationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        final Project project2 = ProjectManagerEx.getInstanceEx().getDefaultProject();
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Sdk sdk = ProjectJdkForModuleStep.this.getJdk();
                Runnable runnable = () -> ProjectRootManagerEx.getInstanceEx((Project)project2).setProjectSdk(sdk);
                ApplicationManager.getApplication().runWriteAction(runnable);
                ProjectJdkForModuleStep.this.c.setEnabled(false);
            }
        });
        this.b.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProjectJdkForModuleStep.this.c.setEnabled(ProjectJdkForModuleStep.this.getJdk() != ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk());
            }
        });
    }

    @Nullable
    private static Project a(WizardContext wizardContext, SdkType sdkType) {
        Project project2 = wizardContext.getProject();
        if (sdkType != null && project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return project2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.b.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return "project.new.page2";
    }

    public JComponent getComponent() {
        return this.e;
    }

    public void updateDataModel() {
        this.f.setProjectJdk(this.getJdk());
    }

    public void updateStep() {
        if (!this.d) {
            this.b.fillList(this.a, null);
            Sdk sdk = ProjectJdkForModuleStep.a(this.f);
            if (sdk != null) {
                this.b.selectJdk(sdk);
            }
            this.c.setEnabled(sdk != null);
            this.d = true;
        }
    }

    public Sdk getJdk() {
        return this.b.getChosenJdk();
    }

    public Object[] getAllJdks() {
        return this.b.getAllJdks();
    }

    public Icon getIcon() {
        return this.f.getStepIcon();
    }

    @Nullable
    private static Sdk a(WizardContext wizardContext) {
        Project project2 = ProjectManagerEx.getInstanceEx().getDefaultProject();
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk();
        if (sdk == null) {
            sdk = AddModuleWizard.getMostRecentSuitableSdk(wizardContext);
        }
        return sdk;
    }

    public boolean validate() {
        int n2;
        Sdk sdk = this.b.getChosenJdk();
        return sdk != null || (n2 = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }
}

