/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamMessages;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DeleteHandler;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonModelManagerImpl
extends CommonModelManager {
    private final List<JamDeleteHandler> a = new ArrayList<JamDeleteHandler>();
    private final Map<Class<? extends CommonModelElement>, JamDeleteHandler> b = FactoryMap.create(clazz -> {
        DeleteHandler deleteHandler = (DeleteHandler)DomReflectionUtil.findAnnotationDFS((Class)clazz, DeleteHandler.class);
        if (deleteHandler == null) {
            return null;
        }
        try {
            Class<?> clazz2 = deleteHandler.handlerClass();
            if (clazz2 == JamDeleteHandler.class) {
                clazz2 = Class.forName(deleteHandler.value(), true, clazz.getClassLoader());
            }
            return (JamDeleteHandler)clazz2.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    });

    public CommonModelManagerImpl() {
        this.registerDeleteHandler(new JamDeleteHandler(){

            public void addPsiElements(CommonModelElement commonModelElement, Collection<PsiElement> collection) {
                DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)commonModelElement, DomElement.class);
                JamElement jamElement = (JamElement)ModelMergerUtil.getImplementation((Object)commonModelElement, JamElement.class);
                if (domElement != null) {
                    XmlTag xmlTag = domElement.getXmlTag();
                    if (xmlTag != null) {
                        collection.add((PsiElement)xmlTag);
                    }
                } else if (jamElement instanceof CommonModelElement) {
                    ContainerUtil.addIfNotNull(collection, (Object)((CommonModelElement)jamElement).getIdentifyingPsiElement());
                }
            }
        });
    }

    public final void registerDeleteHandler(JamDeleteHandler jamDeleteHandler) {
        this.a.add(jamDeleteHandler);
    }

    @Nullable
    public <T extends DomElement> T getDomElement(CommonModelElement commonModelElement) {
        return (T)((DomElement)ModelMergerUtil.getImplementation((Object)commonModelElement, DomElement.class));
    }

    public final void deleteModelElement(CommonModelElement commonModelElement, JamUserResponse jamUserResponse) {
        this.deleteModelElements(Arrays.asList(commonModelElement), jamUserResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteModelElements(Collection<? extends CommonModelElement> collection, final JamUserResponse jamUserResponse) {
        Object object;
        String string;
        THashSet tHashSet = new THashSet();
        for (CommonModelElement object22 : collection) {
            if (object22 == null || !object22.isValid()) continue;
            tHashSet.add((Object)object22);
        }
        if (tHashSet.isEmpty()) {
            return;
        }
        CommonModelElement commonModelElement = collection.iterator().next();
        String string2 = string = collection.size() == 1 ? JamCommonUtil.getDisplayName((Object)commonModelElement) : JamMessages.message((String)"model.delete.items", (Object[])new Object[0]);
        if (!CommonModelManagerImpl.a(string, jamUserResponse)) {
            return;
        }
        this.a(tHashSet);
        final ArrayList<? extends PsiElement> arrayList = new ArrayList<PsiElement>(this.b((Collection<CommonModelElement>)tHashSet));
        if (arrayList.size() > tHashSet.size()) {
            object = new ArrayList(jamUserResponse.askUserToDeletePsiElements(arrayList, string));
            if (object.isEmpty()) {
                return;
            }
            arrayList.clear();
            arrayList.addAll((Collection<? extends PsiElement>)object);
        }
        object = commonModelElement.getPsiManager().getProject();
        String string3 = JamMessages.message((String)"local.vcs.action.name.deleting.element", (Object[])new Object[]{string});
        LocalHistoryAction localHistoryAction = LocalHistory.getInstance().startAction(string3);
        try {
            if (arrayList.isEmpty() || CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)object, arrayList)) {
                PsiDocumentManager.getInstance((Project)object).commitAllDocuments();
                new WriteCommandAction((Project)object, JamMessages.message((String)"command.name.deleting.element", (Object[])new Object[]{string}), new PsiFile[0]){

                    protected boolean isGlobalUndoAction() {
                        return true;
                    }

                    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                    }

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            2.a(0);
                        }
                        THashSet tHashSet = new THashSet();
                        for (Object object : arrayList) {
                            ContainerUtil.addIfNotNull((Collection)tHashSet, (Object)object.getParent());
                        }
                        CommonModelManagerImpl.a(arrayList, jamUserResponse, string);
                        DomManager domManager = DomManager.getDomManager((Project)this.getProject());
                        block1: for (PsiElement psiElement : tHashSet) {
                            if (!psiElement.isValid()) continue;
                            DomElement domElement = psiElement instanceof XmlTag ? domManager.getDomElement((XmlTag)psiElement) : null;
                            for (JamDeleteHandler jamDeleteHandler : CommonModelManagerImpl.this.a(domElement == null ? psiElement : domElement)) {
                                if ((domElement == null || !jamDeleteHandler.onChildrenDelete(domElement)) && (domElement != null || !jamDeleteHandler.onChildrenDelete(psiElement))) continue;
                                continue block1;
                            }
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jam/model/common/CommonModelManagerImpl$2", "run"));
                    }
                }.execute();
            }
        }
        finally {
            localHistoryAction.finish();
        }
        jamUserResponse.onDeletingHasBeenFinished();
    }

    private void a(Set<CommonModelElement> set) {
        THashSet tHashSet = new THashSet(CommonModelManagerImpl.a(set));
        while (!tHashSet.isEmpty()) {
            THashSet tHashSet2 = new THashSet();
            for (CommonModelElement commonModelElement : tHashSet) {
                for (JamDeleteHandler jamDeleteHandler : this.a(commonModelElement)) {
                    jamDeleteHandler.addModelElements(commonModelElement, (Collection)tHashSet2);
                }
            }
            tHashSet2.removeAll(set);
            set.addAll((Collection<CommonModelElement>)CommonModelManagerImpl.a(tHashSet2));
            tHashSet = tHashSet2;
        }
    }

    private List<JamDeleteHandler> a(Object object) {
        JamDeleteHandler jamDeleteHandler;
        Class<?> clazz = object.getClass();
        if (CommonModelElement.class.isAssignableFrom(clazz) && (jamDeleteHandler = this.b.get(clazz)) != null) {
            ArrayList<JamDeleteHandler> arrayList = new ArrayList<JamDeleteHandler>(this.a);
            arrayList.add(jamDeleteHandler);
            return arrayList;
        }
        return this.a;
    }

    private static <T extends Collection<CommonModelElement>> T a(T t2) {
        Iterator<CommonModelElement> iterator = t2.iterator();
        while (iterator.hasNext()) {
            CommonModelElement commonModelElement = iterator.next();
            if (commonModelElement != null && commonModelElement.isValid()) continue;
            iterator.remove();
        }
        return t2;
    }

    private Collection<? extends PsiElement> b(Collection<CommonModelElement> collection) {
        THashSet tHashSet = new THashSet();
        for (CommonModelElement commonModelElement : collection) {
            for (JamDeleteHandler jamDeleteHandler : this.a(commonModelElement)) {
                jamDeleteHandler.addPsiElements(commonModelElement, (Collection)tHashSet);
            }
        }
        Iterator iterator = tHashSet.iterator();
        while (iterator.hasNext()) {
            CommonModelElement commonModelElement;
            commonModelElement = (PsiElement)iterator.next();
            if (commonModelElement != null && !(commonModelElement instanceof PsiCompiledElement) && !(commonModelElement instanceof FakePsiElement) && commonModelElement.isValid() && commonModelElement.getManager().isInProject((PsiElement)commonModelElement)) continue;
            iterator.remove();
        }
        return tHashSet;
    }

    private static void a(List<PsiElement> list2, JamUserResponse jamUserResponse, String string) {
        for (PsiElement psiElement : list2) {
            if (!psiElement.isValid()) continue;
            try {
                psiElement.delete();
            }
            catch (IncorrectOperationException incorrectOperationException) {
                jamUserResponse.logErrorWhileDeletingPsiElement(incorrectOperationException, string, psiElement);
            }
        }
    }

    private static boolean a(String string, JamUserResponse jamUserResponse) {
        return jamUserResponse.showYesNoDialog(JamMessages.message((String)"confirmation.text.delete.element", (Object[])new Object[]{string}), JamMessages.message((String)"message.title.deleting.element", (Object[])new Object[]{string}), Messages.getQuestionIcon()) == 0;
    }
}

