/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VirtualFileSetState {
    public static final DataExternalizer<VirtualFileSetState> EXTERNALIZER = new VirtualFileWithDependenciesExternalizer();
    private final Map<String, Long> a = new HashMap<String, Long>();

    public VirtualFileSetState() {
    }

    public VirtualFileSetState(Collection<? extends VirtualFile> collection) {
        for (VirtualFile virtualFile : collection) {
            this.addFile(virtualFile);
        }
    }

    public void addFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            VirtualFileSetState.a(0);
        }
        this.a.put(virtualFile.getUrl(), virtualFile.getTimeStamp());
    }

    public boolean isUpToDate(Set<? extends VirtualFile> set) {
        if (set.size() != this.a.size()) {
            return false;
        }
        for (VirtualFile virtualFile : set) {
            Long l2 = this.a.get(virtualFile.getUrl());
            if (l2 != null && l2.longValue() == virtualFile.getTimeStamp()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/compiler/generic/VirtualFileSetState", "addFile"));
    }

    private static class VirtualFileWithDependenciesExternalizer
    implements DataExternalizer<VirtualFileSetState> {
        private VirtualFileWithDependenciesExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, VirtualFileSetState virtualFileSetState) throws IOException {
            if (dataOutput == null) {
                VirtualFileWithDependenciesExternalizer.a(0);
            }
            Map map = virtualFileSetState.a;
            dataOutput.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                IOUtil.writeUTF((DataOutput)dataOutput, (String)((String)entry.getKey()));
                dataOutput.writeLong((Long)entry.getValue());
            }
        }

        public VirtualFileSetState read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                VirtualFileWithDependenciesExternalizer.a(1);
            }
            VirtualFileSetState virtualFileSetState = new VirtualFileSetState();
            int n2 = dataInput.readInt();
            while (n2-- > 0) {
                String string = IOUtil.readUTF((DataInput)dataInput);
                long l2 = dataInput.readLong();
                virtualFileSetState.a.put(string, l2);
            }
            return virtualFileSetState;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/compiler/generic/VirtualFileSetState$VirtualFileWithDependenciesExternalizer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

