/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNodeAction<T>
extends ExternalSystemAction {
    private final Class<T> a;

    public ExternalSystemNodeAction(Class<T> clazz) {
        this.a = clazz;
    }

    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        return super.isEnabled(anActionEvent) && this.getSystemId(anActionEvent) != null && this.getExternalData(anActionEvent, this.a) != null;
    }

    protected abstract void perform(@NotNull Project var1, @NotNull ProjectSystemId var2, @NotNull T var3, @NotNull AnActionEvent var4);

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Project project2;
        if (anActionEvent == null) {
            ExternalSystemNodeAction.b(0);
        }
        if ((project2 = this.getProject(anActionEvent)) == null) {
            return;
        }
        ProjectSystemId projectSystemId = this.getSystemId(anActionEvent);
        if (projectSystemId == null) {
            return;
        }
        T t2 = this.getExternalData(anActionEvent, this.a);
        if (t2 == null) {
            return;
        }
        this.perform(project2, projectSystemId, t2, anActionEvent);
    }

    @Nullable
    protected ExternalSystemUiAware getExternalSystemUiAware(AnActionEvent anActionEvent) {
        return (ExternalSystemUiAware)ExternalSystemDataKeys.UI_AWARE.getData(anActionEvent.getDataContext());
    }

    @Nullable
    protected <T> T getExternalData(AnActionEvent anActionEvent, Class<T> clazz) {
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(anActionEvent.getDataContext())));
        return externalSystemNode != null && clazz.isInstance(externalSystemNode.getData()) ? (T)externalSystemNode.getData() : null;
    }

    protected boolean isIgnoredNode(AnActionEvent anActionEvent) {
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(anActionEvent.getDataContext())));
        return externalSystemNode != null && this.a.isInstance(externalSystemNode.getData()) && externalSystemNode.isIgnored();
    }

    @Nullable
    protected VirtualFile getExternalConfig(@NotNull ExternalConfigPathAware externalConfigPathAware, ProjectSystemId projectSystemId) {
        if (externalConfigPathAware == null) {
            ExternalSystemNodeAction.b(1);
        }
        String string = externalConfigPathAware.getLinkedExternalProjectPath();
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = localFileSystem.refreshAndFindFileByPath(string);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        for (ExternalSystemConfigLocator externalSystemConfigLocator : (ExternalSystemConfigLocator[])ExternalSystemConfigLocator.EP_NAME.getExtensions()) {
            if (!projectSystemId.equals((Object)externalSystemConfigLocator.getTargetExternalSystemId())) continue;
            if ((virtualFile2 = externalSystemConfigLocator.adjust(virtualFile2)) != null) break;
            return null;
        }
        return virtualFile2.isDirectory() ? null : virtualFile2;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemNodeAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

