/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nullable;

public class ToggleAutoImportAction
extends ExternalSystemToggleAction {
    public ToggleAutoImportAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.auto.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.auto.description", (Object[])new Object[0]));
    }

    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        if (!super.isEnabled(anActionEvent)) {
            return false;
        }
        if (this.getSystemId(anActionEvent) == null) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(anActionEvent.getDataContext()) != null;
    }

    @Override
    protected boolean isVisible(AnActionEvent anActionEvent) {
        if (!super.isVisible(anActionEvent)) {
            return false;
        }
        if (this.getSystemId(anActionEvent) == null) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(anActionEvent.getDataContext()) != null;
    }

    @Override
    protected boolean doIsSelected(AnActionEvent anActionEvent) {
        ExternalProjectSettings externalProjectSettings = this.a(anActionEvent);
        return externalProjectSettings != null && externalProjectSettings.isUseAutoImport();
    }

    public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
        ExternalProjectSettings externalProjectSettings = this.a(anActionEvent);
        if (externalProjectSettings != null && bl2 != externalProjectSettings.isUseAutoImport()) {
            externalProjectSettings.setUseAutoImport(bl2);
            ExternalSystemApiUtil.getSettings((Project)this.getProject(anActionEvent), (ProjectSystemId)this.getSystemId(anActionEvent)).getPublisher().onUseAutoImportChange(bl2, externalProjectSettings.getExternalProjectPath());
        }
    }

    @Nullable
    private ExternalProjectSettings a(AnActionEvent anActionEvent) {
        ProjectNode projectNode = (ProjectNode)ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(anActionEvent.getDataContext());
        if (projectNode == null || projectNode.getData() == null) {
            return null;
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.getProject(anActionEvent), (ProjectSystemId)this.getSystemId(anActionEvent));
        return abstractExternalSystemSettings.getLinkedProjectSettings(((ProjectData)projectNode.getData()).getLinkedExternalProjectPath());
    }
}

