/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.IntegrationKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemFacadeManager {
    private static final int e = 3;
    private final ConcurrentMap<IntegrationKey, RemoteExternalSystemFacade> d;
    private final Map<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>> b;
    @NotNull
    private final Lock a;
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager f;
    @NotNull
    private final RemoteExternalSystemCommunicationManager c;
    @NotNull
    private final InProcessExternalSystemCommunicationManager g;

    public ExternalSystemFacadeManager(@NotNull ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager, @NotNull RemoteExternalSystemCommunicationManager remoteExternalSystemCommunicationManager, @NotNull InProcessExternalSystemCommunicationManager inProcessExternalSystemCommunicationManager) {
        if (externalSystemProgressNotificationManager == null) {
            ExternalSystemFacadeManager.a(0);
        }
        if (remoteExternalSystemCommunicationManager == null) {
            ExternalSystemFacadeManager.a(1);
        }
        if (inProcessExternalSystemCommunicationManager == null) {
            ExternalSystemFacadeManager.a(2);
        }
        this.d = ContainerUtil.newConcurrentMap();
        this.b = ContainerUtil.newConcurrentMap();
        this.a = new ReentrantLock();
        this.f = (RemoteExternalSystemProgressNotificationManager)((Object)externalSystemProgressNotificationManager);
        this.c = remoteExternalSystemCommunicationManager;
        this.g = inProcessExternalSystemCommunicationManager;
    }

    @NotNull
    private static Project a(@NotNull IntegrationKey integrationKey) {
        if (integrationKey == null) {
            ExternalSystemFacadeManager.a(3);
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project2 : projectManager.getOpenProjects()) {
            if (!integrationKey.getIdeProjectName().equals(project2.getName()) || !integrationKey.getIdeProjectLocationHash().equals(project2.getLocationHash())) continue;
            Project project3 = project2;
            if (project3 == null) {
                ExternalSystemFacadeManager.a(4);
            }
            return project3;
        }
        Project project4 = projectManager.getDefaultProject();
        if (project4 == null) {
            ExternalSystemFacadeManager.a(5);
        }
        return project4;
    }

    public void onProjectRename(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            ExternalSystemFacadeManager.a(6);
        }
        if (string2 == null) {
            ExternalSystemFacadeManager.a(7);
        }
        ExternalSystemFacadeManager.a(this.d, string, string2);
        ExternalSystemFacadeManager.a(this.b, string, string2);
    }

    private static <V> void a(@NotNull Map<IntegrationKey, V> map, @NotNull String string, @NotNull String string2) {
        if (map == null) {
            ExternalSystemFacadeManager.a(8);
        }
        if (string == null) {
            ExternalSystemFacadeManager.a(9);
        }
        if (string2 == null) {
            ExternalSystemFacadeManager.a(10);
        }
        HashSet hashSet = ContainerUtilRt.newHashSet(map.keySet());
        for (IntegrationKey integrationKey : hashSet) {
            if (!integrationKey.getIdeProjectName().equals(string)) continue;
            IntegrationKey integrationKey2 = new IntegrationKey(string2, integrationKey.getIdeProjectLocationHash(), integrationKey.getExternalSystemId(), integrationKey.getExternalProjectConfigPath());
            V v2 = map.get(integrationKey);
            map.put(integrationKey2, v2);
            map.remove(integrationKey);
            if (!(v2 instanceof Consumer)) continue;
            ((Consumer)v2).consume((Object)integrationKey2);
        }
    }

    @NotNull
    public RemoteExternalSystemFacade getFacade(@Nullable Project project2, @NotNull String string, @NotNull ProjectSystemId projectSystemId) {
        IntegrationKey integrationKey;
        RemoteExternalSystemFacade remoteExternalSystemFacade;
        if (string == null) {
            ExternalSystemFacadeManager.a(11);
        }
        if (projectSystemId == null) {
            ExternalSystemFacadeManager.a(12);
        }
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        if ((remoteExternalSystemFacade = (RemoteExternalSystemFacade)this.d.get(integrationKey = new IntegrationKey(project2, projectSystemId, string))) == null) {
            RemoteExternalSystemFacade remoteExternalSystemFacade2 = (RemoteExternalSystemFacade)Proxy.newProxyInstance(ExternalSystemFacadeManager.class.getClassLoader(), new Class[]{RemoteExternalSystemFacade.class, Consumer.class}, (InvocationHandler)new MyHandler(integrationKey));
            this.d.putIfAbsent(integrationKey, remoteExternalSystemFacade2);
        }
        RemoteExternalSystemFacade remoteExternalSystemFacade3 = (RemoteExternalSystemFacade)this.d.get(integrationKey);
        if (remoteExternalSystemFacade3 == null) {
            ExternalSystemFacadeManager.a(13);
        }
        return remoteExternalSystemFacade3;
    }

    public Object doInvoke(@NotNull IntegrationKey integrationKey, @NotNull Project project2, Method method, Object[] objectArray, int n2) throws Throwable {
        if (integrationKey == null) {
            ExternalSystemFacadeManager.a(14);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.a(15);
        }
        RemoteExternalSystemFacade remoteExternalSystemFacade = this.a(integrationKey, project2);
        try {
            return method.invoke((Object)remoteExternalSystemFacade, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof RemoteException && n2 > 0) {
                Thread.sleep(1000L);
                return this.doInvoke(integrationKey, project2, method, objectArray, n2 - 1);
            }
            throw invocationTargetException;
        }
    }

    public ExternalSystemCommunicationManager getCommunicationManager(@NotNull ProjectSystemId projectSystemId) {
        boolean bl2;
        if (projectSystemId == null) {
            ExternalSystemFacadeManager.a(16);
        }
        return (bl2 = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)projectSystemId)) ? this.g : this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private RemoteExternalSystemFacade a(@NotNull IntegrationKey integrationKey, @NotNull Project project2) throws Exception {
        boolean bl2;
        if (integrationKey == null) {
            ExternalSystemFacadeManager.a(17);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.a(18);
        }
        ExternalSystemCommunicationManager externalSystemCommunicationManager = (bl2 = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)integrationKey.getExternalSystemId())) ? this.g : this.c;
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)integrationKey.getExternalSystemId());
        if (project2.isDisposed() || externalSystemManager == null) {
            RemoteExternalSystemFacade<?> remoteExternalSystemFacade = RemoteExternalSystemFacade.NULL_OBJECT;
            if (remoteExternalSystemFacade == null) {
                ExternalSystemFacadeManager.a(19);
            }
            return remoteExternalSystemFacade;
        }
        Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair2 = this.b.get(integrationKey);
        if (pair2 != null && this.a(externalSystemCommunicationManager, project2, integrationKey, pair2)) {
            RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair2.first;
            if (remoteExternalSystemFacade == null) {
                ExternalSystemFacadeManager.a(20);
            }
            return remoteExternalSystemFacade;
        }
        this.a.lock();
        pair2 = this.b.get(integrationKey);
        if (pair2 != null && this.a(externalSystemCommunicationManager, project2, integrationKey, pair2)) {
            RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair2.first;
            RemoteExternalSystemFacade remoteExternalSystemFacade2 = remoteExternalSystemFacade;
            if (remoteExternalSystemFacade2 == null) {
                ExternalSystemFacadeManager.a(21);
            }
            return remoteExternalSystemFacade2;
        }
        if (pair2 != null) {
            this.d.clear();
            this.b.clear();
        }
        RemoteExternalSystemFacade remoteExternalSystemFacade = this.a(integrationKey, project2, externalSystemCommunicationManager);
        RemoteExternalSystemFacade remoteExternalSystemFacade3 = remoteExternalSystemFacade;
        if (remoteExternalSystemFacade3 == null) {
            ExternalSystemFacadeManager.a(22);
        }
        return remoteExternalSystemFacade3;
        finally {
            this.a.unlock();
        }
    }

    @NotNull
    private RemoteExternalSystemFacade a(@NotNull IntegrationKey integrationKey, @NotNull Project project2, @NotNull ExternalSystemCommunicationManager externalSystemCommunicationManager) throws Exception {
        RemoteExternalSystemFacade remoteExternalSystemFacade;
        if (integrationKey == null) {
            ExternalSystemFacadeManager.a(23);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.a(24);
        }
        if (externalSystemCommunicationManager == null) {
            ExternalSystemFacadeManager.a(25);
        }
        if ((remoteExternalSystemFacade = externalSystemCommunicationManager.acquire(integrationKey.getExternalProjectConfigPath(), integrationKey.getExternalSystemId())) == null) {
            throw new IllegalStateException("Can't obtain facade to working with external api at the remote process. Project: " + project2);
        }
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                ExternalSystemFacadeManager.this.d.clear();
                ExternalSystemFacadeManager.this.b.clear();
            }
        });
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> externalSystemFacadeWrapper = new ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings>(remoteExternalSystemFacade, this.f);
        ExternalSystemExecutionSettings externalSystemExecutionSettings = ExternalSystemApiUtil.getExecutionSettings((Project)project2, (String)integrationKey.getExternalProjectConfigPath(), (ProjectSystemId)integrationKey.getExternalSystemId());
        Pair pair2 = Pair.create(externalSystemFacadeWrapper, (Object)externalSystemExecutionSettings);
        this.b.put(integrationKey, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)pair2);
        externalSystemFacadeWrapper.applySettings((ExternalSystemExecutionSettings)pair2.second);
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> externalSystemFacadeWrapper2 = externalSystemFacadeWrapper;
        if (externalSystemFacadeWrapper2 == null) {
            ExternalSystemFacadeManager.a(26);
        }
        return externalSystemFacadeWrapper2;
    }

    private boolean a(@NotNull ExternalSystemCommunicationManager externalSystemCommunicationManager, @NotNull Project project2, @NotNull IntegrationKey integrationKey, @NotNull Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair2) {
        if (externalSystemCommunicationManager == null) {
            ExternalSystemFacadeManager.a(27);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.a(28);
        }
        if (integrationKey == null) {
            ExternalSystemFacadeManager.a(29);
        }
        if (pair2 == null) {
            ExternalSystemFacadeManager.a(30);
        }
        if (!externalSystemCommunicationManager.isAlive((RemoteExternalSystemFacade)pair2.first)) {
            return false;
        }
        try {
            ExternalSystemExecutionSettings externalSystemExecutionSettings = ExternalSystemApiUtil.getExecutionSettings((Project)project2, (String)integrationKey.getExternalProjectConfigPath(), (ProjectSystemId)integrationKey.getExternalSystemId());
            if (!externalSystemExecutionSettings.equals(pair2.second)) {
                ((RemoteExternalSystemFacade)pair2.first).applySettings(externalSystemExecutionSettings);
                this.b.put(integrationKey, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)Pair.create((Object)pair2.first, (Object)externalSystemExecutionSettings));
            }
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskActive(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemFacadeManager.a(31);
        }
        HashMap hashMap = ContainerUtilRt.newHashMap(this.b);
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                if (!((RemoteExternalSystemFacade)((Pair)entry.getValue()).first).isTaskInProgress(externalSystemTaskId)) continue;
                return true;
            }
            catch (RemoteException remoteException) {
                this.a.lock();
                try {
                    this.b.remove(entry.getKey());
                    this.d.remove(entry.getKey());
                }
                finally {
                    this.a.unlock();
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCommunicationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inProcessCommunicationManager";
                break;
            }
            case 3: 
            case 14: 
            case 17: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 15: 
            case 18: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "communicationManager";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacade";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFacade";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateFacade";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onProjectRename";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFacade";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommunicationManager";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetFacade";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFacade";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isTaskActive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyHandler
    implements InvocationHandler {
        @NotNull
        private final AtomicReference<IntegrationKey> a;

        MyHandler(IntegrationKey integrationKey) {
            if (integrationKey == null) {
                MyHandler.a(0);
            }
            this.a = new AtomicReference();
            this.a.set(integrationKey);
        }

        @Override
        @Nullable
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("consume".equals(method.getName())) {
                this.a.set((IntegrationKey)objectArray[0]);
                return null;
            }
            Project project2 = ExternalSystemFacadeManager.a(this.a.get());
            return ExternalSystemFacadeManager.this.doInvoke(this.a.get(), project2, method, objectArray, 3);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager$MyHandler", "<init>"));
        }
    }
}

