/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputParserProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationEditor;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunConfiguration
extends LocatableConfigurationBase
implements SearchScopeProvidingRunProfile,
SMRunnerConsolePropertiesProvider {
    public static final Key<InputStream> RUN_INPUT_KEY = Key.create((String)"RUN_INPUT_KEY");
    public static final Key<Class<? extends BuildProgressListener>> PROGRESS_LISTENER_KEY = Key.create((String)"PROGRESS_LISTENER_KEY");
    private static final Logger a = Logger.getInstance(ExternalSystemRunConfiguration.class);
    private ExternalSystemTaskExecutionSettings b;

    public ExternalSystemRunConfiguration(@NotNull ProjectSystemId projectSystemId, Project project2, ConfigurationFactory configurationFactory, String string) {
        if (projectSystemId == null) {
            ExternalSystemRunConfiguration.a(0);
        }
        super(project2, configurationFactory, string);
        this.b = new ExternalSystemTaskExecutionSettings();
        this.b.setExternalSystemIdString(projectSystemId.getId());
    }

    public String suggestedName() {
        return AbstractExternalSystemTaskConfigurationType.generateName(this.getProject(), this.b);
    }

    public ExternalSystemRunConfiguration clone() {
        Element element = new Element("toClone");
        try {
            this.writeExternal(element);
            RunConfiguration runConfiguration = this.getFactory().createTemplateConfiguration(this.getProject());
            runConfiguration.setName(this.getName());
            runConfiguration.readExternal(element);
            return (ExternalSystemRunConfiguration)runConfiguration;
        }
        catch (InvalidDataException | WriteExternalException throwable) {
            a.error(throwable);
            return null;
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ExternalSystemRunConfiguration.a(1);
        }
        super.readExternal(element);
        Element element2 = element.getChild("ExternalSystemSettings");
        if (element2 != null) {
            this.b = (ExternalSystemTaskExecutionSettings)XmlSerializer.deserialize((Element)element2, ExternalSystemTaskExecutionSettings.class);
        }
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ExternalSystemRunConfiguration.a(2);
        }
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.b, (SerializationFilter)new SerializationFilter(){

            public boolean accepts(@NotNull Accessor accessor, @NotNull Object object) {
                if (accessor == null) {
                    1.a(0);
                }
                if (object == null) {
                    1.a(1);
                }
                switch (accessor.getName()) {
                    case "passParentEnvs": {
                        return !ExternalSystemRunConfiguration.this.b.isPassParentEnvs();
                    }
                    case "env": {
                        return !ExternalSystemRunConfiguration.this.b.getEnv().isEmpty();
                    }
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "accessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "bean";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$1";
                objectArray[2] = "accepts";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.b;
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemRunConfiguration.a(3);
        }
        return externalSystemTaskExecutionSettings;
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup settingsEditorGroup = new SettingsEditorGroup();
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ExternalSystemRunConfigurationEditor(this.getProject(), this.b.getExternalSystemId()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, settingsEditorGroup);
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup2 = settingsEditorGroup;
        if (settingsEditorGroup2 == null) {
            ExternalSystemRunConfiguration.a(4);
        }
        return settingsEditorGroup2;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) {
        if (executor == null) {
            ExternalSystemRunConfiguration.a(5);
        }
        if (executionEnvironment == null) {
            ExternalSystemRunConfiguration.a(6);
        }
        MyRunnableState myRunnableState = new MyRunnableState(this.b, this.getProject(), DefaultDebugExecutor.EXECUTOR_ID.equals(executor.getId()), this, executionEnvironment);
        this.copyUserDataTo(myRunnableState);
        return myRunnableState;
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        Module module2;
        VirtualFile virtualFile;
        GlobalSearchScope globalSearchScope = null;
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.b.getExternalSystemId());
        if (externalSystemManager != null) {
            globalSearchScope = externalSystemManager.getSearchScope(this.getProject(), this.b);
        }
        if (globalSearchScope == null && (virtualFile = VfsUtil.findFileByIoFile((File)new File(this.b.getExternalProjectPath()), (boolean)false)) != null && (module2 = DirectoryIndex.getInstance((Project)this.getProject()).getInfoForFile(virtualFile).getModule()) != null) {
            globalSearchScope = SearchScopeProvider.createSearchScope((Module[])((Module[])ContainerUtil.ar((Object[])new Module[]{module2})));
        }
        return globalSearchScope;
    }

    public SMTRunnerConsoleProperties createTestConsoleProperties(Executor executor) {
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.b.getExternalSystemId());
        if (externalSystemManager != null) {
            Object object = externalSystemManager.createTestConsoleProperties(this.getProject(), executor, (RunConfiguration)this);
            return object instanceof SMTRunnerConsoleProperties ? (SMTRunnerConsoleProperties)object : null;
        }
        return null;
    }

    private static void a(@Nullable ExecutionConsole executionConsole, String string, boolean bl2) {
        DuplexConsoleView duplexConsoleView;
        int n2 = 100;
        if (string.length() < n2) {
            return;
        }
        Object object = executionConsole instanceof ConsoleViewImpl ? (ConsoleViewImpl)executionConsole : (executionConsole instanceof DuplexConsoleView ? ((duplexConsoleView = (DuplexConsoleView)executionConsole).getPrimaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getPrimaryConsoleView() : (duplexConsoleView.getSecondaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getSecondaryConsoleView() : null)) : null);
        if (object != null) {
            object.performWhenNoDeferredOutput(() -> ExternalSystemRunConfiguration.a((ConsoleViewImpl)object, bl2, string, n2));
        }
    }

    private static /* synthetic */ void a(ConsoleViewImpl consoleViewImpl, boolean bl2, String string, int n2) {
        int n3;
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        Document document = consoleViewImpl.getEditor().getDocument();
        int n4 = n3 = bl2 ? 0 : document.getLineCount() - 2;
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(n3), (CharSequence)string)) {
            FoldingModel foldingModel = consoleViewImpl.getEditor().getFoldingModel();
            foldingModel.runBatchFoldingOperation(() -> {
                FoldRegion foldRegion = foldingModel.addFoldRegion(document.getLineStartOffset(n3), document.getLineEndOffset(n3) + 1, StringUtil.trimLog((String)string, (int)n2));
                if (foldRegion != null) {
                    foldRegion.setExpanded(false);
                }
            });
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTaskRerunAction
    extends FakeRerunAction {
        private final BuildProgressListener c;
        private final RunContentDescriptor b;
        private final ExecutionEnvironment a;

        public MyTaskRerunAction(BuildProgressListener buildProgressListener, ExecutionEnvironment executionEnvironment, RunContentDescriptor runContentDescriptor) {
            this.c = buildProgressListener;
            this.b = runContentDescriptor;
            this.a = executionEnvironment;
        }

        public void update(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                MyTaskRerunAction.a(0);
            }
            Presentation presentation = anActionEvent.getPresentation();
            ExecutionEnvironment executionEnvironment = this.getEnvironment(anActionEvent);
            if (executionEnvironment != null) {
                presentation.setText(ExecutionBundle.message((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)executionEnvironment.getRunProfile().getName())}));
                Icon icon = ExecutionManagerImpl.isProcessRunning((RunContentDescriptor)this.getDescriptor(anActionEvent)) ? AllIcons.Actions.Restart : (this.c instanceof BuildViewManager ? AllIcons.Actions.Compile : executionEnvironment.getExecutor().getIcon());
                presentation.setIcon(icon);
                presentation.setEnabled(this.isEnabled(anActionEvent));
                return;
            }
            presentation.setEnabled(false);
        }

        @Nullable
        protected RunContentDescriptor getDescriptor(AnActionEvent anActionEvent) {
            return this.b != null ? this.b : super.getDescriptor(anActionEvent);
        }

        protected ExecutionEnvironment getEnvironment(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                MyTaskRerunAction.a(1);
            }
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyTaskRerunAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyRunnableState
    extends UserDataHolderBase
    implements RunProfileState {
        @NotNull
        private final ExternalSystemTaskExecutionSettings b;
        @NotNull
        private final Project e;
        @NotNull
        private final ExternalSystemRunConfiguration f;
        @NotNull
        private final ExecutionEnvironment c;
        @Nullable
        private RunContentDescriptor a;
        private final int d;

        public MyRunnableState(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, @NotNull Project project2, boolean bl2, @NotNull ExternalSystemRunConfiguration externalSystemRunConfiguration, @NotNull ExecutionEnvironment executionEnvironment) {
            int n2;
            if (externalSystemTaskExecutionSettings == null) {
                MyRunnableState.a(0);
            }
            if (project2 == null) {
                MyRunnableState.a(1);
            }
            if (externalSystemRunConfiguration == null) {
                MyRunnableState.a(2);
            }
            if (executionEnvironment == null) {
                MyRunnableState.a(3);
            }
            this.b = externalSystemTaskExecutionSettings;
            this.e = project2;
            this.f = externalSystemRunConfiguration;
            this.c = executionEnvironment;
            if (bl2) {
                try {
                    n2 = NetUtils.findAvailableSocketPort();
                }
                catch (IOException iOException) {
                    a.warn("Unexpected I/O exception occurred on attempt to find a free port to use for external system task debugging", (Throwable)iOException);
                    n2 = 0;
                }
            } else {
                n2 = 0;
            }
            this.d = n2;
        }

        public int getDebugPort() {
            return this.d;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner programRunner) throws ExecutionException {
            ExternalSystemOutputParserProvider externalSystemOutputParserProvider2;
            AnAction[] anActionArray;
            void var5_8;
            ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> externalSystemExecutionConsoleManager2;
            Object object2;
            RunConfigurationExtension[] runConfigurationExtensionArray;
            if (programRunner == null) {
                MyRunnableState.a(4);
            }
            if (this.e.isDisposed()) {
                return null;
            }
            if (this.b.getTaskNames().isEmpty()) {
                throw new ExecutionException(ExternalSystemBundle.message((String)"run.error.undefined.task", (Object[])new Object[0]));
            }
            JavaParameters javaParameters = new JavaParameters();
            for (Object object2 : runConfigurationExtensionArray = (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
                object2.updateJavaParameters(this.f, javaParameters, this.c.getRunnerSettings());
            }
            if (this.d > 0) {
                String string = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + this.d;
            } else {
                ParametersList parametersList = javaParameters.getVMParametersList();
                ParametersList parametersList2 = (ParametersList)this.c.getUserData(ExternalSystemTaskExecutionSettings.JVM_AGENT_SETUP_KEY);
                if (parametersList2 != null) {
                    parametersList.addAll(parametersList2.getList());
                }
                for (ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> externalSystemExecutionConsoleManager2 : parametersList.getList()) {
                    if (externalSystemExecutionConsoleManager2.startsWith("-agentlib:") || externalSystemExecutionConsoleManager2.startsWith("-agentpath:") || externalSystemExecutionConsoleManager2.startsWith("-javaagent:")) continue;
                    throw new ExecutionException(ExternalSystemBundle.message((String)"run.invalid.jvm.agent.configuration", (Object[])new Object[]{externalSystemExecutionConsoleManager2}));
                }
                String string = parametersList.getParametersString();
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            FileDocumentManager.getInstance().saveAllDocuments();
            ExternalSystemExecuteTaskTask externalSystemExecuteTaskTask = new ExternalSystemExecuteTaskTask(this.e, this.b, (String)var5_8);
            this.copyUserDataTo(externalSystemExecuteTaskTask);
            String string = StringUtil.isNotEmpty((String)this.b.getExecutionName()) ? this.b.getExecutionName() : (StringUtil.isNotEmpty((String)this.f.getName()) ? this.f.getName() : AbstractExternalSystemTaskConfigurationType.generateName(this.e, this.b.getExternalSystemId(), this.b.getExternalProjectPath(), this.b.getTaskNames(), this.b.getExecutionName(), ": ", ""));
            object2 = new ExternalSystemProcessHandler(externalSystemExecuteTaskTask, string);
            externalSystemExecutionConsoleManager2 = ExternalSystemUtil.getConsoleManagerFor(externalSystemExecuteTaskTask);
            ExecutionConsole executionConsole = externalSystemExecutionConsoleManager2.attachExecutionConsole(this.e, (ExternalSystemTask)externalSystemExecuteTaskTask, this.c, (ProcessHandler)object2);
            if (executionConsole == null) {
                anActionArray = AnAction.EMPTY_ARRAY;
                Disposer.register((Disposable)this.e, (Disposable)object2);
            } else {
                Disposer.register((Disposable)this.e, (Disposable)executionConsole);
                Disposer.register((Disposable)executionConsole, (Disposable)object2);
                anActionArray = externalSystemExecutionConsoleManager2.getRestartActions(executionConsole);
            }
            Class clazz = (Class)externalSystemExecuteTaskTask.getUserData(PROGRESS_LISTENER_KEY);
            BuildProgressListener buildProgressListener = clazz != null ? (BuildProgressListener)ServiceManager.getService((Project)this.e, (Class)clazz) : this.a(externalSystemExecuteTaskTask.getId(), string, externalSystemExecuteTaskTask.getExternalProjectPath(), executionConsole);
            SmartList smartList = new SmartList();
            for (ExternalSystemOutputParserProvider externalSystemOutputParserProvider2 : (ExternalSystemOutputParserProvider[])ExternalSystemOutputParserProvider.EP_NAME.getExtensions()) {
                if (!externalSystemExecuteTaskTask.getExternalSystemId().equals((Object)externalSystemOutputParserProvider2.getExternalSystemId())) continue;
                smartList.addAll(externalSystemOutputParserProvider2.getBuildOutputParsers(externalSystemExecuteTaskTask));
            }
            ExternalSystemOutputParserProvider[] externalSystemOutputParserProviderArray = buildProgressListener == null || smartList.isEmpty() ? null : new BuildOutputInstantReaderImpl(externalSystemExecuteTaskTask.getId(), buildProgressListener, (List<BuildOutputParser>)smartList);
            JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.f, (ProcessHandler)object2, this.c.getRunnerSettings());
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.a(buildProgressListener, string, (ExternalSystemProcessHandler)((Object)object2), executionConsole, anActionArray, externalSystemExecutionConsoleManager2, (BuildOutputInstantReaderImpl)externalSystemOutputParserProviderArray, externalSystemExecuteTaskTask));
            ExecutionConsole executionConsole2 = buildProgressListener instanceof ExecutionConsole ? (ExecutionConsole)buildProgressListener : executionConsole;
            AnAction[] anActionArray2 = AnAction.EMPTY_ARRAY;
            if (executionConsole2 instanceof BuildView) {
                anActionArray2 = ((BuildView)executionConsole2).getSwitchActions();
            }
            externalSystemOutputParserProvider2 = new DefaultExecutionResult(executionConsole2, (ProcessHandler)object2, anActionArray2);
            externalSystemOutputParserProvider2.setRestartActions(anActionArray);
            return externalSystemOutputParserProvider2;
        }

        private BuildProgressListener a(ExternalSystemTaskId externalSystemTaskId, String string, String string2, ExecutionConsole executionConsole) {
            DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(externalSystemTaskId, string, string2, System.currentTimeMillis());
            return new BuildView(this.e, executionConsole, defaultBuildDescriptor, "build.toolwindow.run.selection.state", new ViewManager(){

                @Override
                public boolean isConsoleEnabledByDefault() {
                    return true;
                }

                @Override
                public boolean isBuildContentView() {
                    return false;
                }
            });
        }

        public void setContentDescriptor(@Nullable RunContentDescriptor runContentDescriptor) {
            this.a = runContentDescriptor;
            if (runContentDescriptor != null) {
                runContentDescriptor.setExecutionId(this.c.getExecutionId());
                runContentDescriptor.setAutoFocusContent(true);
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.c.getRunnerAndConfigurationSettings();
                if (runnerAndConfigurationSettings != null) {
                    runContentDescriptor.setActivateToolWindowWhenAdded(runnerAndConfigurationSettings.isActivateToolWindowBeforeRun());
                }
            }
        }

        private /* synthetic */ void a(final BuildProgressListener buildProgressListener, final String string, final ExternalSystemProcessHandler externalSystemProcessHandler, final ExecutionConsole executionConsole, final AnAction[] anActionArray, final ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager, final BuildOutputInstantReaderImpl buildOutputInstantReaderImpl, ExternalSystemExecuteTaskTask externalSystemExecuteTaskTask) {
            String string2 = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
            final String string3 = this.b.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.starting.multiple.task", (Object[])new Object[]{string2, this.b.toString()}) + "\n" : ExternalSystemBundle.message((String)"run.text.starting.single.task", (Object[])new Object[]{string2, this.b.toString()}) + "\n";
            ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){
                private boolean a = true;

                public void onStart(@NotNull ExternalSystemTaskId externalSystemTaskId, String string2) {
                    if (externalSystemTaskId == null) {
                        1.a(0);
                    }
                    if (buildProgressListener != null) {
                        long l2 = System.currentTimeMillis();
                        MyTaskRerunAction myTaskRerunAction = new MyTaskRerunAction(buildProgressListener, c, a);
                        buildProgressListener.onEvent(new StartBuildEventImpl(new DefaultBuildDescriptor(externalSystemTaskId, string, string2, l2), "running...").withProcessHandler(externalSystemProcessHandler, (Consumer<ConsoleView>)((Consumer)consoleView -> {
                            externalSystemProcessHandler.notifyTextAvailable(string3 + "\n", ProcessOutputTypes.SYSTEM);
                            ExternalSystemRunConfiguration.a(executionConsole, string3, true);
                        })).withContentDescriptorSupplier(() -> a).withRestartAction((AnAction)myTaskRerunAction).withRestartActions(anActionArray).withExecutionEnvironment(c));
                    }
                }

                public void onTaskOutput(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String string2, boolean bl2) {
                    if (externalSystemTaskId == null) {
                        1.a(1);
                    }
                    if (string2 == null) {
                        1.a(2);
                    }
                    if (this.a) {
                        externalSystemProcessHandler.notifyTextAvailable("\r", ProcessOutputTypes.SYSTEM);
                        this.a = false;
                    }
                    if (executionConsole != null) {
                        externalSystemExecutionConsoleManager.onOutput(executionConsole, (ProcessHandler)externalSystemProcessHandler, string2, bl2 ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                    } else {
                        externalSystemProcessHandler.notifyTextAvailable(string2, bl2 ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                    }
                    if (buildOutputInstantReaderImpl != null) {
                        buildOutputInstantReaderImpl.append(string2);
                    }
                }

                public void onFailure(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull Exception exception) {
                    if (externalSystemTaskId == null) {
                        1.a(3);
                    }
                    if (exception == null) {
                        1.a(4);
                    }
                    FailureResult failureResult = ExternalSystemUtil.createFailureResult(string + " failed", exception, externalSystemTaskId.getProjectSystemId(), e);
                    if (buildProgressListener != null) {
                        buildProgressListener.onEvent(new FinishBuildEventImpl(externalSystemTaskId, null, System.currentTimeMillis(), "failed", failureResult));
                    }
                    ExternalSystemUtil.printFailure(exception, failureResult, executionConsole, externalSystemProcessHandler);
                    externalSystemProcessHandler.notifyProcessTerminated(1);
                }

                public void onSuccess(@NotNull ExternalSystemTaskId externalSystemTaskId) {
                    if (externalSystemTaskId == null) {
                        1.a(5);
                    }
                    if (buildProgressListener != null) {
                        buildProgressListener.onEvent(new FinishBuildEventImpl(externalSystemTaskId, null, System.currentTimeMillis(), "completed successfully", new SuccessResultImpl()));
                    }
                }

                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent) {
                    if (externalSystemTaskNotificationEvent == null) {
                        1.a(6);
                    }
                    if (buildProgressListener != null && externalSystemTaskNotificationEvent instanceof ExternalSystemTaskExecutionEvent) {
                        BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)externalSystemTaskNotificationEvent);
                        buildProgressListener.onEvent(buildEvent);
                    }
                }

                public void onEnd(@NotNull ExternalSystemTaskId externalSystemTaskId) {
                    if (externalSystemTaskId == null) {
                        1.a(7);
                    }
                    String string4 = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                    String string2 = b.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.ended.multiple.task", (Object[])new Object[]{string4, b.toString()}) : ExternalSystemBundle.message((String)"run.text.ended.single.task", (Object[])new Object[]{string4, b.toString()});
                    externalSystemProcessHandler.notifyTextAvailable(string2 + "\n", ProcessOutputTypes.SYSTEM);
                    ExternalSystemRunConfiguration.a(executionConsole, string2, false);
                    externalSystemProcessHandler.notifyProcessTerminated(0);
                    if (buildOutputInstantReaderImpl != null) {
                        buildOutputInstantReaderImpl.close();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "id";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStart";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTaskOutput";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFailure";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStatusChange";
                            break;
                        }
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onEnd";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            externalSystemExecuteTaskTask.execute((ExternalSystemTaskNotificationListener[])ArrayUtil.prepend((Object)externalSystemTaskNotificationListenerAdapter, (Object[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions()));
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

