/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.TaskCompletionProvider;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskSettingsControl
implements ExternalSystemSettingsControl<ExternalSystemTaskExecutionSettings> {
    @NotNull
    private final ProjectSystemId d;
    @NotNull
    private final Project f;
    private JBLabel l;
    private ExternalProjectPathField h;
    private JBLabel e;
    private EditorTextField k;
    private JBLabel i;
    private RawCommandLineEditor b;
    private JBLabel c;
    private RawCommandLineEditor j;
    private EnvironmentVariablesComponent g;
    @Nullable
    private ExternalSystemTaskExecutionSettings a;

    public ExternalSystemTaskSettingsControl(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalSystemTaskSettingsControl.a(0);
        }
        if (projectSystemId == null) {
            ExternalSystemTaskSettingsControl.a(1);
        }
        this.f = project2;
        this.d = projectSystemId;
    }

    public void setOriginalSettings(@Nullable ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) {
        this.a = externalSystemTaskExecutionSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel paintAwarePanel, int n2) {
        if (paintAwarePanel == null) {
            ExternalSystemTaskSettingsControl.a(2);
        }
        this.l = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.project", (Object[])new Object[]{this.d.getReadableName()}));
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.d);
        FileChooserDescriptor fileChooserDescriptor = null;
        if (externalSystemManager instanceof ExternalSystemUiAware) {
            fileChooserDescriptor = ((ExternalSystemUiAware)externalSystemManager).getExternalProjectConfigDescriptor();
        }
        if (fileChooserDescriptor == null) {
            fileChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        }
        String string = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{this.d.getReadableName()});
        this.h = new ExternalProjectPathField(this.f, this.d, fileChooserDescriptor, string){

            public Dimension getPreferredSize() {
                return ExternalSystemTaskSettingsControl.this.b == null ? super.getPreferredSize() : ExternalSystemTaskSettingsControl.this.b.getTextField().getPreferredSize();
            }
        };
        paintAwarePanel.add((Component)this.l, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)((Object)this.h), ExternalSystemUiUtil.getFillLineConstraints(0));
        this.e = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.tasks", (Object[])new Object[0]));
        this.k = new EditorTextField("", this.f, (FileType)PlainTextFileType.INSTANCE);
        paintAwarePanel.add((Component)this.e, ExternalSystemUiUtil.getLabelConstraints(0));
        GridBag gridBag = ExternalSystemUiUtil.getFillLineConstraints(0);
        gridBag.insets.right = this.h.getButton().getPreferredSize().width + 8;
        paintAwarePanel.add((Component)this.k, gridBag);
        new TaskCompletionProvider(this.f, this.d, this.h).apply(this.k);
        this.i = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        this.b = new RawCommandLineEditor();
        this.b.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        paintAwarePanel.add((Component)this.i, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.b, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.c = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        this.j = new RawCommandLineEditor();
        this.j.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        paintAwarePanel.add((Component)this.c, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.j, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.g = new EnvironmentVariablesComponent();
        JBLabel jBLabel = this.g.getLabel();
        jBLabel.remove((Component)jBLabel);
        paintAwarePanel.add((Component)jBLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.g, ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @Override
    public void reset() {
        this.h.setText("");
        this.k.setText("");
        this.b.setText("");
        this.j.setText("");
        this.g.setEnvData(EnvironmentVariablesData.DEFAULT);
        this.showUi(true);
        if (this.a == null) {
            return;
        }
        String string = this.a.getExternalProjectPath();
        if (StringUtil.isEmpty((String)string)) {
            string = "";
        }
        this.h.setText(string);
        this.k.setText(StringUtil.join((Collection)this.a.getTaskNames(), (String)" "));
        this.b.setText(this.a.getVmOptions());
        this.j.setText(this.a.getScriptParameters());
        this.g.setEnvData(EnvironmentVariablesData.create((Map)this.a.getEnv(), (boolean)this.a.isPassParentEnvs()));
    }

    @Override
    public boolean isModified() {
        if (this.a == null) {
            return false;
        }
        return !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.h.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.a.getExternalProjectPath())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.k.getText()), (String)ExternalSystemApiUtil.normalizePath((String)StringUtil.join((Collection)this.a.getTaskNames(), (String)" "))) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.b.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.a.getVmOptions())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.j.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.a.getScriptParameters())) || this.g.isPassParentEnvs() != this.a.isPassParentEnvs() || !this.g.getEnvs().equals(this.a.getEnv());
    }

    @Override
    public void apply(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemTaskSettingsControl.a(3);
        }
        String string = this.h.getText();
        externalSystemTaskExecutionSettings.setExternalProjectPath(string);
        externalSystemTaskExecutionSettings.setTaskNames(StringUtil.split((String)this.k.getText(), (String)" "));
        externalSystemTaskExecutionSettings.setVmOptions(this.b.getText());
        externalSystemTaskExecutionSettings.setScriptParameters(this.j.getText());
        externalSystemTaskExecutionSettings.setPassParentEnvs(this.g.isPassParentEnvs());
        externalSystemTaskExecutionSettings.setEnv((Map)ContainerUtil.newHashMap((Map)this.g.getEnvs()));
    }

    @Override
    public boolean validate(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) throws ConfigurationException {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemTaskSettingsControl.a(4);
        }
        String string = this.h.getText();
        if (this.a == null) {
            throw new ConfigurationException(String.format("Can't store external task settings into run configuration. Reason: target run configuration is undefined. Tasks: '%s', external project: '%s', vm options: '%s', arguments: '%s'", this.k.getText(), string, this.b.getText(), this.j.getText()));
        }
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean bl2) {
        ExternalSystemUiUtil.showUi(this, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvas";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

