/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.cmd.CommandLineCompletionProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.util.containers.ContainerUtil;
import groovyjarjarcommonscli.Options;
import icons.ExternalSystemIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskCompletionProvider
extends CommandLineCompletionProvider {
    private volatile List<LookupElement> c;
    private volatile String f;
    private final Project e;
    private final ProjectSystemId d;
    private final TextAccessor b;

    public TaskCompletionProvider(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull TextAccessor textAccessor) {
        if (project2 == null) {
            TaskCompletionProvider.b(0);
        }
        if (projectSystemId == null) {
            TaskCompletionProvider.b(1);
        }
        if (textAccessor == null) {
            TaskCompletionProvider.b(2);
        }
        this(project2, projectSystemId, textAccessor, new Options());
    }

    public TaskCompletionProvider(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull TextAccessor textAccessor, @NotNull Options options) {
        if (project2 == null) {
            TaskCompletionProvider.b(3);
        }
        if (projectSystemId == null) {
            TaskCompletionProvider.b(4);
        }
        if (textAccessor == null) {
            TaskCompletionProvider.b(5);
        }
        if (options == null) {
            TaskCompletionProvider.b(6);
        }
        super(options);
        this.e = project2;
        this.d = projectSystemId;
        this.b = textAccessor;
    }

    @Override
    protected void addArgumentVariants(@NotNull CompletionResultSet completionResultSet) {
        if (completionResultSet == null) {
            TaskCompletionProvider.b(7);
        }
        ArrayList arrayList = this.c;
        String string = this.b.getText();
        if (arrayList == null || !StringUtil.equals((CharSequence)this.f, (CharSequence)string)) {
            ExternalProjectSettings externalProjectSettings = ExternalSystemApiUtil.getSettings((Project)this.e, (ProjectSystemId)this.d).getLinkedProjectSettings(string);
            if (externalProjectSettings == null) {
                return;
            }
            ExternalProjectInfo externalProjectInfo = ProjectDataManager.getInstance().getExternalProjectData(this.e, this.d, externalProjectSettings.getExternalProjectPath());
            if (externalProjectInfo == null || externalProjectInfo.getExternalProjectStructure() == null) {
                return;
            }
            this.c = arrayList = ContainerUtil.newArrayList(this.getVariants((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure(), string));
            this.f = string;
        }
        completionResultSet.addAllElements(arrayList);
    }

    protected List<LookupElement> getVariants(@NotNull DataNode<ProjectData> dataNode, @NotNull String string) {
        DataNode<ModuleData> dataNode2;
        if (dataNode == null) {
            TaskCompletionProvider.b(8);
        }
        if (string == null) {
            TaskCompletionProvider.b(9);
        }
        if ((dataNode2 = TaskCompletionProvider.findModuleDataNode(dataNode, string)) == null) {
            return Collections.emptyList();
        }
        Collection collection = ExternalSystemApiUtil.getChildren(dataNode2, (Key)ProjectKeys.TASK);
        ArrayList arrayList = ContainerUtil.newArrayListWithCapacity((int)collection.size());
        for (DataNode dataNode3 : collection) {
            arrayList.add(LookupElementBuilder.create((String)((TaskData)dataNode3.getData()).getName()).withIcon(ExternalSystemIcons.Task));
        }
        return arrayList;
    }

    @Nullable
    public static DataNode<ModuleData> findModuleDataNode(@NotNull DataNode<ProjectData> dataNode2, @NotNull String string) {
        if (dataNode2 == null) {
            TaskCompletionProvider.b(10);
        }
        if (string == null) {
            TaskCompletionProvider.b(11);
        }
        DataNode dataNode3 = ExternalSystemApiUtil.findFirstRecursively(dataNode2, dataNode -> {
            if (string == null) {
                TaskCompletionProvider.b(12);
            }
            return dataNode.getKey().equals((Object)ProjectKeys.MODULE) && dataNode.getData() instanceof ModuleData && ((ModuleData)dataNode.getData()).getLinkedExternalProjectPath().equals(string);
        });
        return dataNode3;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDirectoryField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addArgumentVariants";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariants";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleDataNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findModuleDataNode$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

