/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemResolveProjectTask
extends AbstractExternalSystemTask {
    private final AtomicReference<DataNode<ProjectData>> l;
    @NotNull
    private final String j;
    private final boolean h;
    @Nullable
    private final String i;
    @Nullable
    private final String k;

    public ExternalSystemResolveProjectTask(@NotNull ProjectSystemId projectSystemId, @NotNull Project project2, @NotNull String string, boolean bl2) {
        if (projectSystemId == null) {
            ExternalSystemResolveProjectTask.b(0);
        }
        if (project2 == null) {
            ExternalSystemResolveProjectTask.b(1);
        }
        if (string == null) {
            ExternalSystemResolveProjectTask.b(2);
        }
        this(projectSystemId, project2, string, null, null, bl2);
    }

    public ExternalSystemResolveProjectTask(@NotNull ProjectSystemId projectSystemId, @NotNull Project project2, @NotNull String string, @Nullable String string2, @Nullable String string3, boolean bl2) {
        if (projectSystemId == null) {
            ExternalSystemResolveProjectTask.b(3);
        }
        if (project2 == null) {
            ExternalSystemResolveProjectTask.b(4);
        }
        if (string == null) {
            ExternalSystemResolveProjectTask.b(5);
        }
        super(projectSystemId, ExternalSystemTaskType.RESOLVE_PROJECT, project2, string);
        this.l = new AtomicReference();
        this.j = string;
        this.h = bl2;
        this.i = string2;
        this.k = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        ExternalSystemExecutionSettings externalSystemExecutionSettings;
        RemoteExternalSystemProjectResolver<ExternalSystemExecutionSettings> remoteExternalSystemProjectResolver;
        Project project2;
        DataNode<ProjectData> dataNode;
        ExternalSystemProgressNotificationManagerImpl externalSystemProgressNotificationManagerImpl = (ExternalSystemProgressNotificationManagerImpl)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskId externalSystemTaskId = this.getId();
        try {
            externalSystemProgressNotificationManagerImpl.onStart(externalSystemTaskId, this.j);
            dataNode = (DataNode<ProjectData>)ServiceManager.getService(ExternalSystemFacadeManager.class);
            project2 = this.getIdeProject();
            remoteExternalSystemProjectResolver = dataNode.getFacade(project2, this.j, this.getExternalSystemId()).getResolver();
            externalSystemExecutionSettings = ExternalSystemApiUtil.getExecutionSettings((Project)project2, (String)this.j, (ProjectSystemId)this.getExternalSystemId());
            if (StringUtil.isNotEmpty((String)this.i)) {
                externalSystemExecutionSettings.withVmOptions((Collection)ParametersListUtil.parse((String)this.i));
            }
            if (StringUtil.isNotEmpty((String)this.k)) {
                externalSystemExecutionSettings.withArguments((Collection)ParametersListUtil.parse((String)this.k));
            }
        }
        catch (Exception exception) {
            externalSystemProgressNotificationManagerImpl.onFailure(externalSystemTaskId, exception);
            externalSystemProgressNotificationManagerImpl.onEnd(externalSystemTaskId);
            throw exception;
        }
        try {
            dataNode = remoteExternalSystemProjectResolver.resolveProjectInfo(externalSystemTaskId, this.j, this.h, externalSystemExecutionSettings);
            if (dataNode != null) {
                DataNode dataNode22;
                this.l.set(dataNode);
                ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.getExternalSystemId());
                assert (externalSystemManager != null);
                HashSet hashSet = ContainerUtil.newHashSet();
                Collection collection = ExternalSystemApiUtil.findAll(dataNode, (Key)ProjectKeys.MODULE);
                for (DataNode dataNode22 : collection) {
                    hashSet.add(((ModuleData)dataNode22.getData()).getLinkedExternalProjectPath());
                }
                String string = ((ProjectData)dataNode.getData()).getLinkedExternalProjectPath();
                dataNode22 = ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)project2)).getLinkedProjectSettings(string);
                if (dataNode22 != null) {
                    dataNode22.setModules((Set)hashSet);
                }
            }
            externalSystemProgressNotificationManagerImpl.onSuccess(externalSystemTaskId);
        }
        finally {
            externalSystemProgressNotificationManagerImpl.onEnd(externalSystemTaskId);
        }
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager externalSystemFacadeManager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project project2 = this.getIdeProject();
        RemoteExternalSystemProjectResolver remoteExternalSystemProjectResolver = externalSystemFacadeManager.getFacade(project2, this.j, this.getExternalSystemId()).getResolver();
        return remoteExternalSystemProjectResolver.cancelTask(this.getId());
    }

    @Override
    @NotNull
    protected String wrapProgressText(@NotNull String string) {
        if (string == null) {
            ExternalSystemResolveProjectTask.b(6);
        }
        String string2 = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId().getReadableName(), string});
        if (string2 == null) {
            ExternalSystemResolveProjectTask.b(7);
        }
        return string2;
    }

    @Override
    protected void setState(@NotNull ExternalSystemTaskState externalSystemTaskState) {
        if (externalSystemTaskState == null) {
            ExternalSystemResolveProjectTask.b(8);
        }
        super.setState(externalSystemTaskState);
        if (externalSystemTaskState.isStopped()) {
            InternalExternalProjectInfo internalExternalProjectInfo = new InternalExternalProjectInfo(this.getExternalSystemId(), this.getExternalProjectPath(), (DataNode<ProjectData>)((DataNode)this.l.getAndSet(null)));
            long l2 = System.currentTimeMillis();
            internalExternalProjectInfo.setLastImportTimestamp(l2);
            internalExternalProjectInfo.setLastSuccessfulImportTimestamp(externalSystemTaskState == ExternalSystemTaskState.FAILED ? -1L : l2);
            ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.getIdeProject(), internalExternalProjectInfo);
        }
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

