/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ModifiableWorkspace {
    private final Map<ProjectCoordinate, String> c = ContainerUtil.newTroveMap((TObjectHashingStrategy)new TObjectHashingStrategy<ProjectCoordinate>(){

        public int computeHashCode(ProjectCoordinate projectCoordinate) {
            String string = projectCoordinate.getGroupId();
            String string2 = projectCoordinate.getArtifactId();
            String string3 = projectCoordinate.getVersion();
            int n2 = string != null ? string.hashCode() : 0;
            n2 = 31 * n2 + (string2 != null ? string2.hashCode() : 0);
            n2 = 31 * n2 + (string3 != null ? string3.hashCode() : 0);
            return n2;
        }

        public boolean equals(ProjectCoordinate projectCoordinate, ProjectCoordinate projectCoordinate2) {
            if (projectCoordinate.getGroupId() != null ? !projectCoordinate.getGroupId().equals(projectCoordinate2.getGroupId()) : projectCoordinate2.getGroupId() != null) {
                return false;
            }
            if (projectCoordinate.getArtifactId() != null ? !projectCoordinate.getArtifactId().equals(projectCoordinate2.getArtifactId()) : projectCoordinate2.getArtifactId() != null) {
                return false;
            }
            return !(projectCoordinate.getVersion() != null ? !projectCoordinate.getVersion().equals(projectCoordinate2.getVersion()) : projectCoordinate2.getVersion() != null);
        }
    });
    private final AbstractIdeModifiableModelsProvider a;
    private final ExternalProjectsWorkspaceImpl.State b;
    private final MultiMap<String, String> e = MultiMap.createSet();
    private final Map<String, String> d = ContainerUtil.newHashMap();

    public ModifiableWorkspace(ExternalProjectsWorkspaceImpl.State state, AbstractIdeModifiableModelsProvider abstractIdeModifiableModelsProvider) {
        this.a = abstractIdeModifiableModelsProvider;
        HashSet hashSet = ContainerUtil.newHashSet();
        for (Module module2 : abstractIdeModifiableModelsProvider.getModules()) {
            this.a(module2, abstractIdeModifiableModelsProvider);
            hashSet.add(module2.getName());
        }
        this.b = state;
        if (this.b.names != null) {
            for (Map.Entry entry : this.b.names.entrySet()) {
                if (!hashSet.contains(entry.getKey())) continue;
                this.d.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.b.substitutions != null) {
            for (Map.Entry entry : this.b.substitutions.entrySet()) {
                if (!hashSet.contains(entry.getKey())) continue;
                this.e.put(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    public void commit() {
        HashSet hashSet = ContainerUtil.newHashSet();
        Arrays.stream(this.a.getModules()).map(Module::getName).forEach(hashSet::add);
        this.b.names = new HashMap<String, String>();
        this.d.forEach((string, string2) -> {
            if (hashSet.contains(string)) {
                this.b.names.put((String)string, (String)string2);
            }
        });
        this.b.substitutions = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this.e.entrySet()) {
            Collection collection;
            if (!hashSet.contains(entry.getKey()) || (collection = (Collection)entry.getValue()) == null || collection.isEmpty()) continue;
            this.b.substitutions.put((String)entry.getKey(), new TreeSet(collection));
        }
    }

    public void addSubstitution(String string, String string2, String string3, DependencyScope dependencyScope) {
        this.d.put(string2, string3);
        this.e.putValue((Object)string, (Object)(string2 + '_' + dependencyScope.getDisplayName()));
    }

    public void removeSubstitution(String string, String string2, String string3, DependencyScope dependencyScope) {
        this.e.remove((Object)string, (Object)(string2 + '_' + dependencyScope.getDisplayName()));
        Collection collection = this.e.values();
        for (DependencyScope dependencyScope2 : DependencyScope.values()) {
            if (!collection.contains(string2 + '_' + dependencyScope2.getDisplayName())) continue;
            return;
        }
        this.d.remove(string2, string3);
    }

    public boolean isSubstitution(String string, String string2, DependencyScope dependencyScope) {
        return this.e.get((Object)string).contains(string2 + '_' + dependencyScope.getDisplayName());
    }

    public boolean isSubstituted(String string) {
        return this.d.values().contains(string);
    }

    public String getSubstitutedLibrary(String string) {
        return this.d.get(string);
    }

    @Nullable
    public String findModule(@NotNull ProjectCoordinate projectCoordinate) {
        if (projectCoordinate == null) {
            ModifiableWorkspace.a(0);
        }
        if (StringUtil.isEmpty((String)projectCoordinate.getArtifactId())) {
            return null;
        }
        String string = this.c.get(projectCoordinate);
        return string == null && projectCoordinate.getVersion() != null ? this.c.get(new ProjectId(projectCoordinate.getGroupId(), projectCoordinate.getArtifactId(), null)) : string;
    }

    public void register(@NotNull ProjectCoordinate projectCoordinate, @NotNull Module module2) {
        if (projectCoordinate == null) {
            ModifiableWorkspace.a(1);
        }
        if (module2 == null) {
            ModifiableWorkspace.a(2);
        }
        this.c.put(projectCoordinate, module2.getName());
        this.c.put((ProjectCoordinate)new ProjectId(projectCoordinate.getGroupId(), projectCoordinate.getArtifactId(), null), module2.getName());
    }

    private void a(@NotNull Module module2, AbstractIdeModifiableModelsProvider abstractIdeModifiableModelsProvider) {
        if (module2 == null) {
            ModifiableWorkspace.a(3);
        }
        Arrays.stream(ExternalProjectsWorkspaceImpl.EP_NAME.getExtensions()).map(contributor -> {
            if (module2 == null) {
                ModifiableWorkspace.a(5);
            }
            return contributor.findProjectId(module2, abstractIdeModifiableModelsProvider);
        }).filter(Objects::nonNull).findFirst().ifPresent(projectCoordinate -> {
            if (module2 == null) {
                ModifiableWorkspace.a(4);
            }
            this.register((ProjectCoordinate)projectCoordinate, module2);
        });
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/ModifiableWorkspace";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$register$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$register$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

