/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483645)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create((String)"createEmptyDirectories");
    private static final Logger a = Logger.getInstance(ContentRootDataService.class);

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key = ProjectKeys.CONTENT_ROOT;
        if (key == null) {
            ContentRootDataService.a(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        Object object;
        if (collection == null) {
            ContentRootDataService.a(1);
        }
        if (project2 == null) {
            ContentRootDataService.a(2);
        }
        if (ideModifiableModelsProvider == null) {
            ContentRootDataService.a(3);
        }
        if (collection.isEmpty()) {
            return;
        }
        boolean bl2 = project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean bl3 = false;
        DataNode dataNode = ExternalSystemApiUtil.findParent(collection.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (dataNode != null) {
            bl3 = dataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        THashSet tHashSet = ContainerUtil.newTroveSet();
        MultiMap multiMap = ExternalSystemApiUtil.groupBy(collection, ModuleData.class);
        for (Map.Entry entry : multiMap.entrySet()) {
            object = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Object object2 = object = object != null ? object : ideModifiableModelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (object == null) {
                a.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.a(ideModifiableModelsProvider, (Collection)entry.getValue(), (Module)object, bl3);
            if (!bl3 && (!bl2 || projectData == null || !projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath((Module)object)))) continue;
            tHashSet.add(object);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !tHashSet.isEmpty()) {
            for (Map.Entry entry : tHashSet) {
                VirtualFile[] virtualFileArray;
                object = ideModifiableModelsProvider.getProductionModuleName((Module)entry);
                if (object != null && tHashSet.contains(ideModifiableModelsProvider.findIdeModule((String)object)) || (virtualFileArray = ideModifiableModelsProvider.getModifiableRootModel((Module)entry).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile = virtualFileArray[0];
                ExternalSystemUtil.invokeLater(project2, ModalityState.NON_MODAL, () -> {
                    if (project2 == null) {
                        ContentRootDataService.a(21);
                    }
                    ProjectView projectView = ProjectView.getInstance((Project)project2);
                    projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile, false));
                });
            }
        }
    }

    private static void a(@NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull Collection<DataNode<ContentRootData>> collection, @NotNull Module module2, boolean bl2) {
        ContentRootData contentRootData;
        if (ideModifiableModelsProvider == null) {
            ContentRootDataService.a(4);
        }
        if (collection == null) {
            ContentRootDataService.a(5);
        }
        if (module2 == null) {
            ContentRootDataService.a(6);
        }
        ModifiableRootModel modifiableRootModel = ideModifiableModelsProvider.getModifiableRootModel(module2);
        ContentEntry[] contentEntryArray = modifiableRootModel.getContentEntries();
        HashMap hashMap = ContainerUtilRt.newHashMap();
        for (ContentEntry object : contentEntryArray) {
            hashMap.put(object.getUrl(), object);
        }
        boolean bl3 = bl2;
        if (!bl2 && !collection.isEmpty()) {
            ProjectSystemId projectSystemId = ((ContentRootData)collection.iterator().next().getData()).getOwner();
            AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)module2.getProject(), (ProjectSystemId)projectSystemId);
            String string = ExternalSystemModulePropertyManager.getInstance((Module)module2).getRootProjectPath();
            if (string != null) {
                contentRootData = abstractExternalSystemSettings.getLinkedProjectSettings(string);
                bl3 = contentRootData != null && contentRootData.isCreateEmptyContentRootDirectories();
            }
        }
        THashSet tHashSet = ContainerUtil.newIdentityTroveSet();
        for (DataNode<ContentRootData> dataNode : collection) {
            contentRootData = (ContentRootData)dataNode.getData();
            ContentEntry contentEntry = ContentRootDataService.a(modifiableRootModel, contentRootData.getRootPath());
            if (!tHashSet.contains(contentEntry)) {
                contentEntry.clearSourceFolders();
                tHashSet.add(contentEntry);
            }
            if (a.isDebugEnabled()) {
                a.debug(String.format("Importing content root '%s' for module '%s'", contentRootData.getRootPath(), module2.getName()));
            }
            for (ContentRootData.SourceRoot sourceRoot : contentRootData.getPaths(ExternalSystemSourceType.SOURCE)) {
                ContentRootDataService.a(contentEntry, sourceRoot, module2.getName(), JavaSourceRootType.SOURCE, false, bl3);
            }
            for (ContentRootData.SourceRoot sourceRoot : contentRootData.getPaths(ExternalSystemSourceType.TEST)) {
                ContentRootDataService.a(contentEntry, sourceRoot, module2.getName(), JavaSourceRootType.TEST_SOURCE, false, bl3);
            }
            for (ContentRootData.SourceRoot sourceRoot : contentRootData.getPaths(ExternalSystemSourceType.SOURCE_GENERATED)) {
                ContentRootDataService.a(contentEntry, sourceRoot, module2.getName(), JavaSourceRootType.SOURCE, true, bl3);
            }
            for (ContentRootData.SourceRoot sourceRoot : contentRootData.getPaths(ExternalSystemSourceType.TEST_GENERATED)) {
                ContentRootDataService.a(contentEntry, sourceRoot, module2.getName(), JavaSourceRootType.TEST_SOURCE, true, bl3);
            }
            for (ContentRootData.SourceRoot sourceRoot : contentRootData.getPaths(ExternalSystemSourceType.RESOURCE)) {
                ContentRootDataService.a(contentEntry, sourceRoot, module2.getName(), JavaResourceRootType.RESOURCE, false, bl3);
            }
            for (ContentRootData.SourceRoot sourceRoot : contentRootData.getPaths(ExternalSystemSourceType.TEST_RESOURCE)) {
                ContentRootDataService.a(contentEntry, sourceRoot, module2.getName(), JavaResourceRootType.TEST_RESOURCE, false, bl3);
            }
            for (ContentRootData.SourceRoot sourceRoot : contentRootData.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.a(contentEntry, sourceRoot, module2.getName(), module2.getProject());
            }
            hashMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : hashMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @NotNull
    private static ContentEntry a(@NotNull ModifiableRootModel modifiableRootModel, @NotNull String string) {
        ContentEntry[] contentEntryArray;
        if (modifiableRootModel == null) {
            ContentRootDataService.a(7);
        }
        if (string == null) {
            ContentRootDataService.a(8);
        }
        for (ContentEntry contentEntry : contentEntryArray = modifiableRootModel.getContentEntries()) {
            VirtualFile virtualFile = contentEntry.getFile();
            if (virtualFile == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)virtualFile).equals(string)) continue;
            ContentEntry contentEntry2 = contentEntry;
            if (contentEntry2 == null) {
                ContentRootDataService.a(9);
            }
            return contentEntry2;
        }
        ContentEntry contentEntry = modifiableRootModel.addContentEntry(ContentRootDataService.a(string));
        if (contentEntry == null) {
            ContentRootDataService.a(10);
        }
        return contentEntry;
    }

    private static void a(@NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, @NotNull String string, @NotNull JpsModuleSourceRootType<?> jpsModuleSourceRootType, boolean bl2, boolean bl3) {
        JavaSourceRootProperties javaSourceRootProperties;
        SourceFolder sourceFolder;
        if (contentEntry == null) {
            ContentRootDataService.a(11);
        }
        if (sourceRoot == null) {
            ContentRootDataService.a(12);
        }
        if (string == null) {
            ContentRootDataService.a(13);
        }
        if (jpsModuleSourceRootType == null) {
            ContentRootDataService.a(14);
        }
        for (SourceFolder sourceFolder2 : sourceFolder = contentEntry.getSourceFolders()) {
            VirtualFile virtualFile = sourceFolder2.getFile();
            if (virtualFile == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)virtualFile).equals(sourceRoot.getPath())) continue;
            JpsModuleSourceRootType jpsModuleSourceRootType2 = sourceFolder2.getRootType();
            if (JavaSourceRootType.SOURCE.equals(jpsModuleSourceRootType2) || jpsModuleSourceRootType.equals((Object)jpsModuleSourceRootType2)) {
                return;
            }
            if (JavaSourceRootType.TEST_SOURCE.equals(jpsModuleSourceRootType2) && JavaResourceRootType.TEST_RESOURCE.equals(jpsModuleSourceRootType)) {
                return;
            }
            contentEntry.removeSourceFolder(sourceFolder2);
        }
        if (a.isDebugEnabled()) {
            a.debug(String.format("Importing %s for content root '%s' of module '%s'", sourceRoot, contentEntry.getUrl(), string));
        }
        SourceFolder sourceFolder3 = contentEntry.addSourceFolder(ContentRootDataService.a(sourceRoot.getPath()), jpsModuleSourceRootType);
        if (!StringUtil.isEmpty((String)sourceRoot.getPackagePrefix())) {
            sourceFolder3.setPackagePrefix(sourceRoot.getPackagePrefix());
        }
        if (bl2 && (javaSourceRootProperties = (JavaSourceRootProperties)sourceFolder3.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            javaSourceRootProperties.setForGeneratedSources(true);
        }
        if (bl3) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                if (sourceRoot == null) {
                    ContentRootDataService.a(20);
                }
                try {
                    VfsUtil.createDirectoryIfMissing((String)sourceRoot.getPath());
                }
                catch (IOException iOException) {
                    a.warn(String.format("Unable to create directory for the path: %s", sourceRoot.getPath()), (Throwable)iOException);
                }
            });
        }
    }

    private static void a(@NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, @NotNull String string, @NotNull Project project2) {
        if (contentEntry == null) {
            ContentRootDataService.a(15);
        }
        if (sourceRoot == null) {
            ContentRootDataService.a(16);
        }
        if (string == null) {
            ContentRootDataService.a(17);
        }
        if (project2 == null) {
            ContentRootDataService.a(18);
        }
        String string2 = sourceRoot.getPath();
        for (VirtualFile virtualFile : contentEntry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)virtualFile).equals(string2)) continue;
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", sourceRoot, contentEntry.getUrl(), string));
        }
        contentEntry.addExcludeFolder(ContentRootDataService.a(string2));
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            ChangeListManager.getInstance((Project)project2).addDirectoryToIgnoreImplicitly(string2);
        }
    }

    private static String a(@NotNull String string) {
        if (string == null) {
            ContentRootDataService.a(19);
        }
        return "file://" + string;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateContentRoot";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateContentRoot";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRootIfAbsent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedRootIfAbsent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toVfsUrl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSourceRootIfAbsent$2";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$importData$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

