/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskActivator {
    private static final Logger a = Logger.getInstance(ExternalSystemTaskActivator.class);
    public static final String RUN_CONFIGURATION_TASK_PREFIX = "run: ";
    @NotNull
    private final Project c;
    private final List<Listener> b;

    public ExternalSystemTaskActivator(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemTaskActivator.a(0);
        }
        this.b = ContainerUtil.createLockFreeCopyOnWriteList();
        this.c = project2;
    }

    @NotNull
    public static String getRunConfigurationActivationTaskName(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (runnerAndConfigurationSettings == null) {
            ExternalSystemTaskActivator.a(1);
        }
        String string = RUN_CONFIGURATION_TASK_PREFIX + runnerAndConfigurationSettings.getName();
        if (string == null) {
            ExternalSystemTaskActivator.a(2);
        }
        return string;
    }

    public void init() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.c);
        class MyCompileTask
        implements CompileTask {
            private final boolean a;

            MyCompileTask(boolean bl2) {
                this.a = bl2;
            }

            public boolean execute(CompileContext compileContext) {
                return ExternalSystemTaskActivator.this.a(this.a, compileContext);
            }
        }
        compilerManager.addBeforeTask((CompileTask)new MyCompileTask(true));
        compilerManager.addAfterTask((CompileTask)new MyCompileTask(false));
        this.fireTasksChanged();
    }

    public String getDescription(ProjectSystemId projectSystemId, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.c).getStateProvider();
        TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(projectSystemId, string);
        if (taskActivationState == null) {
            return null;
        }
        for (Phase phase : Phase.values()) {
            if (!taskActivationState.getTasks(phase).contains(string2)) continue;
            arrayList.add(phase.toString());
        }
        return StringUtil.join(arrayList, (String)", ");
    }

    private boolean a(boolean bl2, @NotNull CompileContext compileContext) {
        if (compileContext == null) {
            ExternalSystemTaskActivator.a(3);
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (compileContext == null) {
                ExternalSystemTaskActivator.a(28);
            }
            return ContainerUtil.mapNotNull((Object[])compileContext.getCompileScope().getAffectedModules(), module2 -> ExternalSystemApiUtil.getExternalProjectPath((Module)module2));
        });
        ArrayList arrayList = ContainerUtil.newArrayList();
        if (bl2) {
            if (compileContext.isRebuild()) {
                arrayList.add(Phase.BEFORE_REBUILD);
            }
            arrayList.add(Phase.BEFORE_COMPILE);
        } else {
            arrayList.add(Phase.AFTER_COMPILE);
            if (compileContext.isRebuild()) {
                arrayList.add(Phase.AFTER_REBUILD);
            }
        }
        return this.runTasks(list2, (Phase[])ArrayUtil.toObjectArray((Collection)arrayList, Phase.class));
    }

    public boolean runTasks(@NotNull String string, Phase ... phaseArray) {
        if (string == null) {
            ExternalSystemTaskActivator.a(4);
        }
        if (phaseArray == null) {
            ExternalSystemTaskActivator.a(5);
        }
        return this.runTasks(Collections.singleton(string), phaseArray);
    }

    public boolean runTasks(@NotNull Collection<String> collection, Phase ... phaseArray) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(6);
        }
        if (phaseArray == null) {
            ExternalSystemTaskActivator.a(7);
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.c).getStateProvider();
        LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> linkedList = new LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>>();
        Map map = FactoryMap.create(projectSystemId -> {
            AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType = ExternalSystemUtil.findConfigurationType(projectSystemId);
            if (abstractExternalSystemTaskConfigurationType == null) {
                return null;
            }
            return ContainerUtil.map2Map((Collection)RunManager.getInstance((Project)this.c).getConfigurationSettingsList((ConfigurationType)abstractExternalSystemTaskConfigurationType), runnerAndConfigurationSettings -> Pair.create((Object)runnerAndConfigurationSettings.getName(), (Object)runnerAndConfigurationSettings));
        });
        for (ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation tasksActivation : externalProjectsStateProvider.getAllTasksActivation()) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            boolean bl2 = collection.contains(tasksActivation.projectPath);
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
            for (Phase phase : phaseArray) {
                runnerAndConfigurationSettings = tasksActivation.state.getTasks(phase);
                if (!bl2 && (!phase.isSyncPhase() || runnerAndConfigurationSettings.isEmpty() || !this.a(collection, tasksActivation))) continue;
                ContainerUtil.addAll((Collection)linkedHashSet, runnerAndConfigurationSettings);
            }
            if (linkedHashSet.isEmpty()) continue;
            Object object = linkedHashSet.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string.length() <= RUN_CONFIGURATION_TASK_PREFIX.length() || !string.startsWith(RUN_CONFIGURATION_TASK_PREFIX)) continue;
                object.remove();
                String string2 = string.substring(RUN_CONFIGURATION_TASK_PREFIX.length());
                Map map2 = (Map)map.get(tasksActivation.systemId);
                if (map2 == null || (runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)map2.get(string2)) == null) continue;
                RunConfiguration runConfiguration = runnerAndConfigurationSettings.getConfiguration();
                if (!string2.equals(runnerAndConfigurationSettings.getName()) || !(runConfiguration instanceof ExternalSystemRunConfiguration)) continue;
                linkedList.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)tasksActivation.systemId, (Object)((ExternalSystemRunConfiguration)runConfiguration).getSettings()));
            }
            if (linkedHashSet.isEmpty() || ExternalProjectsManager.getInstance((Project)this.c).isIgnored(tasksActivation.systemId, tasksActivation.projectPath)) continue;
            object = new ExternalSystemTaskExecutionSettings();
            object.setExternalSystemIdString(tasksActivation.systemId.toString());
            object.setExternalProjectPath(tasksActivation.projectPath);
            object.getTaskNames().addAll(linkedHashSet);
            linkedList.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)tasksActivation.systemId, (Object)object));
        }
        return this.a(linkedList);
    }

    private boolean a(@NotNull Collection<String> collection, @NotNull ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation tasksActivation) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(8);
        }
        if (tasksActivation == null) {
            ExternalSystemTaskActivator.a(9);
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.c, (ProjectSystemId)tasksActivation.systemId);
        String string2 = ExternalSystemTaskActivator.b(abstractExternalSystemSettings, tasksActivation.projectPath);
        List list2 = ContainerUtil.mapNotNull(collection, string -> ExternalSystemTaskActivator.b(abstractExternalSystemSettings, string));
        return list2.contains(string2);
    }

    @Nullable
    private static String b(@NotNull AbstractExternalSystemSettings abstractExternalSystemSettings, @NotNull String string) {
        ExternalProjectSettings externalProjectSettings;
        if (abstractExternalSystemSettings == null) {
            ExternalSystemTaskActivator.a(10);
        }
        if (string == null) {
            ExternalSystemTaskActivator.a(11);
        }
        return (externalProjectSettings = abstractExternalSystemSettings.getLinkedProjectSettings(string)) != null ? externalProjectSettings.getExternalProjectPath() : null;
    }

    private boolean a(final Queue<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> queue) {
        Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings> pair2 = queue.poll();
        if (pair2 == null) {
            return true;
        }
        ProjectSystemId projectSystemId = (ProjectSystemId)pair2.first;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = (ExternalSystemTaskExecutionSettings)pair2.getSecond();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref ref = new Ref((Object)false);
        ExternalSystemUtil.runTask(externalSystemTaskExecutionSettings, DefaultRunExecutor.EXECUTOR_ID, this.c, projectSystemId, new TaskCallback(){

            public void onSuccess() {
                ref.set((Object)ExternalSystemTaskActivator.this.a(queue));
                semaphore.up();
            }

            public void onFailure() {
                semaphore.up();
            }
        }, ProgressExecutionMode.IN_BACKGROUND_ASYNC, false);
        semaphore.waitFor();
        return (Boolean)ref.get();
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            ExternalSystemTaskActivator.a(12);
        }
        this.b.add(listener);
    }

    public boolean isTaskOfPhase(@NotNull TaskData taskData, @NotNull Phase phase) {
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider;
        TaskActivationState taskActivationState;
        if (taskData == null) {
            ExternalSystemTaskActivator.a(13);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.a(14);
        }
        if ((taskActivationState = (externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.c).getStateProvider()).getTasksActivation(taskData.getOwner(), taskData.getLinkedExternalProjectPath())) == null) {
            return false;
        }
        return taskActivationState.getTasks(phase).contains(taskData.getName());
    }

    public void addTasks(@NotNull Collection<TaskData> collection, @NotNull Phase phase) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(15);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.a(16);
        }
        if (collection.isEmpty()) {
            return;
        }
        this.addTasks(ContainerUtil.map(collection, taskData -> {
            if (phase == null) {
                ExternalSystemTaskActivator.a(27);
            }
            return new TaskActivationEntry(taskData.getOwner(), phase, taskData.getLinkedExternalProjectPath(), taskData.getName());
        }));
        this.fireTasksChanged();
    }

    public void addTasks(@NotNull Collection<TaskActivationEntry> collection) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(17);
        }
        if (collection.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.c).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : collection) {
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(taskActivationEntry.c, taskActivationEntry.a);
            taskActivationState.getTasks(taskActivationEntry.b).add(taskActivationEntry.d);
        }
        this.fireTasksChanged();
    }

    public void removeTasks(@NotNull Collection<TaskData> collection, @NotNull Phase phase) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(18);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.a(19);
        }
        if (collection.isEmpty()) {
            return;
        }
        this.removeTasks(ContainerUtil.map(collection, taskData -> {
            if (phase == null) {
                ExternalSystemTaskActivator.a(26);
            }
            return new TaskActivationEntry(taskData.getOwner(), phase, taskData.getLinkedExternalProjectPath(), taskData.getName());
        }));
    }

    public void removeTasks(@NotNull Collection<TaskActivationEntry> collection) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(20);
        }
        if (collection.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.c).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : collection) {
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(taskActivationEntry.c, taskActivationEntry.a);
            taskActivationState.getTasks(taskActivationEntry.b).remove(taskActivationEntry.d);
        }
        this.fireTasksChanged();
    }

    public void addTask(@NotNull TaskActivationEntry taskActivationEntry) {
        if (taskActivationEntry == null) {
            ExternalSystemTaskActivator.a(21);
        }
        this.addTasks(Collections.singleton(taskActivationEntry));
    }

    public void removeTask(@NotNull TaskActivationEntry taskActivationEntry) {
        if (taskActivationEntry == null) {
            ExternalSystemTaskActivator.a(22);
        }
        this.removeTasks(Collections.singleton(taskActivationEntry));
    }

    public void moveTasks(@NotNull Collection<TaskActivationEntry> collection, int n2) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(23);
        }
        a.assertTrue(n2 == -1 || n2 == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.c).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : collection) {
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(taskActivationEntry.c, taskActivationEntry.a);
            List<String> list2 = taskActivationState.getTasks(taskActivationEntry.b);
            int n3 = list2.indexOf(taskActivationEntry.d);
            int n4 = n3 + n2;
            if (n3 == -1 || list2.size() <= n4 || n4 < 0) continue;
            Collections.swap(list2, n3, n4);
        }
    }

    public void moveProjects(@NotNull ProjectSystemId projectSystemId, @NotNull List<String> list2, @Nullable Collection<String> collection, int n2) {
        if (projectSystemId == null) {
            ExternalSystemTaskActivator.a(24);
        }
        if (list2 == null) {
            ExternalSystemTaskActivator.a(25);
        }
        a.assertTrue(n2 == -1 || n2 == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.c).getStateProvider();
        Map<String, TaskActivationState> map = externalProjectsStateProvider.getProjectsTasksActivationMap(projectSystemId);
        ArrayList arrayList = ContainerUtil.newArrayList(map.keySet());
        if (collection != null) {
            arrayList.retainAll(collection);
        }
        for (String object : list2) {
            int string = arrayList.indexOf(object);
            int n3 = string + n2;
            if (string == -1 || arrayList.size() <= n3 || n3 < 0) continue;
            Collections.swap(arrayList, string, n3);
        }
        LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap();
        for (String string : arrayList) {
            linkedHashMap.put(string, map.get(string));
            map.remove(string);
        }
        map.putAll(linkedHashMap);
    }

    public void fireTasksChanged() {
        for (Listener listener : this.b) {
            listener.tasksActivationChanged();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator";
                break;
            }
            case 3: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phases";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskData";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsPathsToMove";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationActivationTaskName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationActivationTaskName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteCompileTasks";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isShareSameRootPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isTaskOfPhase";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTasks";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeTasks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveTasks";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveProjects";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeTasks$6";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTasks$5";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doExecuteCompileTasks$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TaskActivationEntry {
        @NotNull
        private final ProjectSystemId c;
        @NotNull
        private final Phase b;
        @NotNull
        private final String a;
        @NotNull
        private final String d;

        public TaskActivationEntry(@NotNull ProjectSystemId projectSystemId, @NotNull Phase phase, @NotNull String string, @NotNull String string2) {
            if (projectSystemId == null) {
                TaskActivationEntry.a(0);
            }
            if (phase == null) {
                TaskActivationEntry.a(1);
            }
            if (string == null) {
                TaskActivationEntry.a(2);
            }
            if (string2 == null) {
                TaskActivationEntry.a(3);
            }
            this.c = projectSystemId;
            this.b = phase;
            this.a = string;
            this.d = string2;
        }

        @NotNull
        public ProjectSystemId getSystemId() {
            ProjectSystemId projectSystemId = this.c;
            if (projectSystemId == null) {
                TaskActivationEntry.a(4);
            }
            return projectSystemId;
        }

        @NotNull
        public Phase getPhase() {
            Phase phase = this.b;
            if (phase == null) {
                TaskActivationEntry.a(5);
            }
            return phase;
        }

        @NotNull
        public String getProjectPath() {
            String string = this.a;
            if (string == null) {
                TaskActivationEntry.a(6);
            }
            return string;
        }

        @NotNull
        public String getTaskName() {
            String string = this.d;
            if (string == null) {
                TaskActivationEntry.a(7);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "systemId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phase";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator$TaskActivationEntry";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator$TaskActivationEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSystemId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectPath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        public void tasksActivationChanged();
    }

    public static enum Phase {
        BEFORE_RUN("external.system.task.before.run"),
        BEFORE_SYNC("external.system.task.before.sync"),
        AFTER_SYNC("external.system.task.after.sync"),
        BEFORE_COMPILE("external.system.task.before.compile"),
        AFTER_COMPILE("external.system.task.after.compile"),
        BEFORE_REBUILD("external.system.task.before.rebuild"),
        AFTER_REBUILD("external.system.task.after.rebuild");

        public final String myMessageKey;

        private Phase(String string2) {
            this.myMessageKey = string2;
        }

        public boolean isSyncPhase() {
            return this == BEFORE_SYNC || this == AFTER_SYNC;
        }

        public String toString() {
            return ExternalSystemBundle.message((String)this.myMessageKey, (Object[])new Object[0]);
        }
    }
}

