/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger b = Logger.getInstance(ProjectDataManagerImpl.class);
    private static final com.intellij.openapi.util.Key<Boolean> a = com.intellij.openapi.util.Key.create((String)"externalSystem.data.ready");
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> c = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

        @NotNull
        protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
            HashMap hashMap = ContainerUtilRt.newHashMap();
            for (ProjectDataService projectDataService : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                List list2 = (List)hashMap.get(projectDataService.getTargetDataKey());
                if (list2 == null) {
                    list2 = ContainerUtilRt.newArrayList();
                    hashMap.put(projectDataService.getTargetDataKey(), list2);
                }
                list2.add(projectDataService);
            }
            for (List list3 : hashMap.values()) {
                ExternalSystemApiUtil.orderAwareSort((List)list3);
            }
            HashMap hashMap2 = hashMap;
            if (hashMap2 == null) {
                1.a(0);
            }
            return hashMap2;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl$1", "compute"));
        }
    };

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)projectDataManager;
    }

    public void importData(@NotNull Collection<DataNode<?>> collection, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, boolean bl2) {
        Object object;
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        Key key2;
        if (collection == null) {
            ProjectDataManagerImpl.a(0);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(1);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(2);
        }
        if (project2.isDisposed()) {
            return;
        }
        MultiMap multiMap = ExternalSystemApiUtil.recursiveGroup(collection);
        for (Key key2 : ((Map)this.c.getValue()).keySet()) {
            if (multiMap.containsKey((Object)key2)) continue;
            multiMap.put((Object)key2, Collections.emptyList());
        }
        Collection collection2 = multiMap.get((Object)ProjectKeys.PROJECT);
        assert (collection2.size() == 1 || collection2.isEmpty());
        key2 = (DataNode)ContainerUtil.getFirstItem((Collection)collection2);
        if (key2 != null) {
            projectData = (ProjectData)key2.getData();
            projectSystemId = ((ProjectData)key2.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project2).saveInclusionSettings((DataNode<ProjectData>)key2);
        } else {
            projectData = null;
            object = (DataNode)ContainerUtil.getFirstItem((Collection)multiMap.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = object != null ? ((ModuleData)object.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project2, projectSystemId);
        }
        object = ContainerUtil.newSmartList();
        List list2 = ContainerUtil.newSmartList();
        try {
            Set set = multiMap.entrySet();
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(false);
            }
            int n2 = set.size();
            int n3 = 0;
            List list3 = ContainerUtil.newSmartList();
            for (Object object2 : set) {
                if (progressIndicator != null) {
                    String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", "Refresh " + ProjectDataManagerImpl.a((Key)object2.getKey())});
                    progressIndicator.setText(string);
                    progressIndicator.setFraction((double)n3++ / (double)n2);
                }
                this.a((Key)object2.getKey(), (Collection)object2.getValue(), projectData, project2, ideModifiableModelsProvider, list3, (List<Runnable>)object, list2);
            }
            for (Object object2 : list3) {
                object2.run();
            }
            ProjectDataManagerImpl.a(ideModifiableModelsProvider, project2, bl2, "Imported data");
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project2.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData != null ? projectData.getLinkedExternalProjectPath() : null);
        }
        catch (Throwable throwable) {
            ProjectDataManagerImpl.a(bl2, list2);
            ProjectDataManagerImpl.a(ideModifiableModelsProvider, project2, bl2);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
        }
        ProjectDataManagerImpl.a(bl2, (List<Runnable>)object);
    }

    private static void a(boolean bl2, List<Runnable> list2) {
        Runnable runnable = () -> {
            for (Runnable runnable : ContainerUtil.reverse((List)list2)) {
                runnable.run();
            }
        };
        if (bl2) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                b.warn((Throwable)exception);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    @NotNull
    private static String a(@NotNull Key key) {
        if (key == null) {
            ProjectDataManagerImpl.a(3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = key.toString();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isUpperCase(c2)) {
                if (i2 != 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(StringUtil.toLowerCase((char)c2));
                continue;
            }
            stringBuilder.append(c2);
        }
        String string2 = stringBuilder.toString();
        if (string2 == null) {
            ProjectDataManagerImpl.a(4);
        }
        return string2;
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> collection, @NotNull Project project2, boolean bl2) {
        if (collection == null) {
            ProjectDataManagerImpl.a(5);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(6);
        }
        List list2 = ContainerUtil.newSmartList();
        list2.addAll(collection);
        this.importData(list2, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), bl2);
    }

    public <T> void importData(@NotNull DataNode<T> dataNode, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, boolean bl2) {
        if (dataNode == null) {
            ProjectDataManagerImpl.a(7);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(8);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(9);
        }
        List list2 = ContainerUtil.newSmartList();
        list2.add(dataNode);
        this.importData(list2, project2, ideModifiableModelsProvider, bl2);
    }

    public <T> void importData(@NotNull DataNode<T> dataNode, @NotNull Project project2, boolean bl2) {
        if (dataNode == null) {
            ProjectDataManagerImpl.a(10);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(11);
        }
        this.importData(dataNode, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), bl2);
    }

    private <T> void a(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull List<Runnable> list2, @NotNull List<Runnable> list3, @NotNull List<Runnable> list4) {
        if (key == null) {
            ProjectDataManagerImpl.a(12);
        }
        if (collection == null) {
            ProjectDataManagerImpl.a(13);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(14);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(15);
        }
        if (list2 == null) {
            ProjectDataManagerImpl.a(16);
        }
        if (list3 == null) {
            ProjectDataManagerImpl.a(17);
        }
        if (list4 == null) {
            ProjectDataManagerImpl.a(18);
        }
        if (project2.isDisposed()) {
            return;
        }
        if (project2 instanceof ProjectImpl) assert (((ProjectImpl)project2).isComponentsCreated());
        List list5 = ContainerUtil.newSmartList();
        List list6 = ContainerUtil.newSmartList();
        for (DataNode<?> object : collection) {
            if (!key.equals((Object)object.getKey())) continue;
            if (object.isIgnored()) {
                list6.add(object);
                continue;
            }
            list5.add(object);
        }
        this.a(list5);
        List list7 = (List)((Map)this.c.getValue()).get(key);
        if (list7 == null) {
            b.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", list5, key, ((Map)this.c.getValue()).keySet()));
        } else {
            Iterator iterator = list7.iterator();
            while (iterator.hasNext()) {
                long l2;
                ProjectDataService projectDataService = (ProjectDataService)iterator.next();
                long l3 = System.currentTimeMillis();
                projectDataService.importData((Collection)list5, projectData, project2, ideModifiableModelsProvider);
                if (b.isDebugEnabled()) {
                    l2 = System.currentTimeMillis() - l3;
                    b.debug(String.format("Service %s imported data in %d ms", projectDataService.getClass().getSimpleName(), l2));
                }
                if (projectData == null) continue;
                this.a(list6);
                l2 = System.currentTimeMillis();
                Computable computable = projectDataService.computeOrphanData((Collection)list5, projectData, project2, ideModifiableModelsProvider);
                projectDataService.removeData(computable, (Collection)list6, projectData, project2, ideModifiableModelsProvider);
                if (!b.isDebugEnabled()) continue;
                long l4 = System.currentTimeMillis() - l2;
                b.debug(String.format("Service %s computed and removed data in %d ms", projectDataService.getClass().getSimpleName(), l4));
            }
        }
        if (list7 != null && projectData != null) {
            list2.add(() -> {
                if (project2 == null) {
                    ProjectDataManagerImpl.a(48);
                }
                if (ideModifiableModelsProvider == null) {
                    ProjectDataManagerImpl.a(49);
                }
                for (ProjectDataService projectDataService : list7) {
                    if (!(projectDataService instanceof AbstractProjectDataService)) continue;
                    long l2 = System.currentTimeMillis();
                    ((AbstractProjectDataService)projectDataService).postProcess((Collection)list5, projectData, project2, ideModifiableModelsProvider);
                    if (!b.isDebugEnabled()) continue;
                    long l3 = System.currentTimeMillis() - l2;
                    b.debug(String.format("Service %s run post import task in %d ms", projectDataService.getClass().getSimpleName(), l3));
                }
            });
            list4.add(() -> {
                if (project2 == null) {
                    ProjectDataManagerImpl.a(47);
                }
                for (ProjectDataService projectDataService : list7) {
                    if (!(projectDataService instanceof AbstractProjectDataService)) continue;
                    long l2 = System.currentTimeMillis();
                    ((AbstractProjectDataService)projectDataService).onFailureImport(project2);
                    if (!b.isDebugEnabled()) continue;
                    long l3 = System.currentTimeMillis() - l2;
                    b.debug(String.format("Service %s run failure import task in %d ms", projectDataService.getClass().getSimpleName(), l3));
                }
            });
            list3.add(() -> {
                if (project2 == null) {
                    ProjectDataManagerImpl.a(46);
                }
                IdeModelsProviderImpl ideModelsProviderImpl = new IdeModelsProviderImpl(project2);
                for (ProjectDataService projectDataService : list7) {
                    if (!(projectDataService instanceof AbstractProjectDataService)) continue;
                    long l2 = System.currentTimeMillis();
                    ((AbstractProjectDataService)projectDataService).onSuccessImport((Collection)list5, projectData, project2, (IdeModelsProvider)ideModelsProviderImpl);
                    if (!b.isDebugEnabled()) continue;
                    long l3 = System.currentTimeMillis() - l2;
                    b.debug(String.format("Service %s run success import task in %d ms", projectDataService.getClass().getSimpleName(), l3));
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode dataNode2) {
        if (dataNode2 == null) {
            return;
        }
        if (Boolean.TRUE.equals(dataNode2.getUserData(a))) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode2, dataNode -> {
            this.b((DataNode)dataNode);
            dataNode.putUserData(a, (Object)Boolean.TRUE);
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> collection, @NotNull Collection<DataNode<E>> collection2, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, boolean bl2) {
        if (key == null) {
            ProjectDataManagerImpl.a(19);
        }
        if (collection == null) {
            ProjectDataManagerImpl.a(20);
        }
        if (collection2 == null) {
            ProjectDataManagerImpl.a(21);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.a(22);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(23);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(24);
        }
        try {
            List list2 = (List)((Map)this.c.getValue()).get(key);
            for (ProjectDataService projectDataService : list2) {
                long l2 = System.currentTimeMillis();
                projectDataService.removeData((Computable)new Computable.PredefinedValueComputable(collection), collection2, projectData, project2, ideModifiableModelsProvider);
                if (!b.isDebugEnabled()) continue;
                long l3 = System.currentTimeMillis() - l2;
                b.debug(String.format("Service %s removed data in %d ms", projectDataService.getClass().getSimpleName(), l3));
            }
            ProjectDataManagerImpl.a(ideModifiableModelsProvider, project2, bl2, "Removed data");
        }
        catch (Throwable throwable) {
            ProjectDataManagerImpl.a(ideModifiableModelsProvider, project2, bl2);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> collection, @NotNull Collection<DataNode<E>> collection2, @NotNull ProjectData projectData, @NotNull Project project2, boolean bl2) {
        if (key == null) {
            ProjectDataManagerImpl.a(25);
        }
        if (collection == null) {
            ProjectDataManagerImpl.a(26);
        }
        if (collection2 == null) {
            ProjectDataManagerImpl.a(27);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.a(28);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(29);
        }
        this.removeData(key, collection, collection2, projectData, project2, new IdeModifiableModelsProviderImpl(project2), bl2);
    }

    public void updateExternalProjectData(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project2 == null) {
            ProjectDataManagerImpl.a(30);
        }
        if (externalProjectInfo == null) {
            ProjectDataManagerImpl.a(31);
        }
        if (!project2.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project2).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        if (project2 == null) {
            ProjectDataManagerImpl.a(32);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.a(33);
        }
        if (string == null) {
            ProjectDataManagerImpl.a(34);
        }
        return !project2.isDisposed() ? ExternalProjectsDataStorage.getInstance(project2).get(projectSystemId, string) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ProjectDataManagerImpl.a(35);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.a(36);
        }
        if (!project2.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project2).list(projectSystemId);
            if (collection == null) {
                ProjectDataManagerImpl.a(37);
            }
            return collection;
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            ProjectDataManagerImpl.a(38);
        }
        return list2;
    }

    private void a(@NotNull Collection<DataNode<?>> collection) {
        if (collection == null) {
            ProjectDataManagerImpl.a(39);
        }
        for (DataNode<?> dataNode : collection) {
            this.ensureTheDataIsReadyToUse(dataNode);
        }
    }

    private void b(@NotNull DataNode dataNode) {
        Map map;
        List list2;
        if (dataNode == null) {
            ProjectDataManagerImpl.a(40);
        }
        if ((list2 = (List)(map = (Map)this.c.getValue()).get(dataNode.getKey())) != null) {
            try {
                dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)list2, ClassLoader.class, projectDataService -> projectDataService.getClass().getClassLoader()));
            }
            catch (Exception exception) {
                b.debug((Throwable)exception);
                dataNode.clear(true);
            }
        }
    }

    private static void a(final @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull Project project2, boolean bl2, final @NotNull String string) {
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(41);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(42);
        }
        if (string == null) {
            ProjectDataManagerImpl.a(43);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)bl2, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                long l2 = System.currentTimeMillis();
                ideModifiableModelsProvider.commit();
                long l3 = System.currentTimeMillis() - l2;
                b.debug(String.format("%s committed in %d ms", string, l3));
            }
        });
    }

    private static void a(final @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull Project project2, boolean bl2) {
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(44);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(45);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)bl2, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                ideModifiableModelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 23: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 24: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postImportTasks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessImportTasks";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureImportTasks";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDesc";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableText";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectsData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReadableText";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doImportData";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateExternalProjectData";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectData";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsData";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "ensureTheDataIsReadyToUse";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "prepareDataToUse";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$3";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$2";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

