/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.HideableTitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportFromExternalSystemControl<ProjectSettings extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<ProjectSettings>, SystemSettings extends AbstractExternalSystemSettings<SystemSettings, ProjectSettings, L>> {
    @NotNull
    private final SystemSettings e;
    @NotNull
    private final ProjectSettings d;
    @NotNull
    private final PaintAwarePanel h;
    @NotNull
    private final NamePathComponent c;
    @Nullable
    private final HideableTitledPanel j;
    @NotNull
    private final ProjectFormatPanel k;
    @NotNull
    private final ExternalSystemSettingsControl<ProjectSettings> g;
    @NotNull
    private final ProjectSystemId a;
    @Nullable
    private final ExternalSystemSettingsControl<SystemSettings> i;
    @Nullable
    Project myCurrentProject;
    private boolean f;
    private final JLabel b;

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId projectSystemId, @NotNull SystemSettings SystemSettings, @NotNull ProjectSettings ProjectSettings) {
        if (projectSystemId == null) {
            AbstractImportFromExternalSystemControl.a(0);
        }
        if (SystemSettings == null) {
            AbstractImportFromExternalSystemControl.a(1);
        }
        if (ProjectSettings == null) {
            AbstractImportFromExternalSystemControl.a(2);
        }
        this(projectSystemId, SystemSettings, ProjectSettings, false);
    }

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId projectSystemId, @NotNull SystemSettings SystemSettings, @NotNull ProjectSettings ProjectSettings, boolean bl2) {
        if (projectSystemId == null) {
            AbstractImportFromExternalSystemControl.a(3);
        }
        if (SystemSettings == null) {
            AbstractImportFromExternalSystemControl.a(4);
        }
        if (ProjectSettings == null) {
            AbstractImportFromExternalSystemControl.a(5);
        }
        this.h = new PaintAwarePanel(new GridBagLayout());
        this.a = projectSystemId;
        this.e = SystemSettings;
        this.d = ProjectSettings;
        this.g = this.createProjectSettingsControl(ProjectSettings);
        this.i = this.createSystemSettingsControl(SystemSettings);
        this.f = bl2;
        String string = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{projectSystemId.getReadableName()});
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        assert (externalSystemManager != null);
        this.c = new NamePathComponent("", string, string, "", false, false);
        this.c.setNameComponentVisible(false);
        this.c.setNameValue("untitled");
        FileChooserDescriptor fileChooserDescriptor = externalSystemManager.getExternalProjectDescriptor();
        BrowseFilesListener browseFilesListener = new BrowseFilesListener(this.c.getPathComponent(), string, "", fileChooserDescriptor);
        this.c.getPathPanel().setBrowseButtonActionListener((ActionListener)browseFilesListener);
        this.c.getPathComponent().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.c.getPath());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.c.getPath());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.c.getPath());
            }
        });
        this.h.add((Component)this.c, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.g.fillUi(this.h, 0);
        this.k = new ProjectFormatPanel();
        this.b = new JLabel(ExternalSystemBundle.message((String)"settings.label.project.format", (Object[])new Object[0]));
        this.h.add((Component)this.b, ExternalSystemUiUtil.getLabelConstraints(0));
        this.h.add((Component)this.k.getStorageFormatComboBox(), ExternalSystemUiUtil.getFillLineConstraints(0));
        if (this.i != null) {
            PaintAwarePanel paintAwarePanel = new PaintAwarePanel();
            this.i.fillUi(paintAwarePanel, 0);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)paintAwarePanel, "Center");
            this.j = new HideableTitledPanel(ExternalSystemBundle.message((String)"settings.title.system.settings", (Object[])new Object[]{this.a.getReadableName()}), false);
            this.j.setContentComponent((JComponent)jPanel);
            this.j.setOn(false);
            this.h.add((Component)this.j, ExternalSystemUiUtil.getFillLineConstraints(0));
        } else {
            this.j = null;
        }
        ExternalSystemUiUtil.fillBottom(this.h);
    }

    public void setCurrentProject(@Nullable Project project2) {
        this.myCurrentProject = project2;
    }

    protected abstract void onLinkedProjectPathChange(@NotNull String var1);

    @NotNull
    protected abstract ExternalSystemSettingsControl<ProjectSettings> createProjectSettingsControl(@NotNull ProjectSettings var1);

    @Nullable
    protected abstract ExternalSystemSettingsControl<SystemSettings> createSystemSettingsControl(@NotNull SystemSettings var1);

    @NotNull
    public JComponent getComponent() {
        PaintAwarePanel paintAwarePanel = this.h;
        if (paintAwarePanel == null) {
            AbstractImportFromExternalSystemControl.a(6);
        }
        return paintAwarePanel;
    }

    @NotNull
    public ExternalSystemSettingsControl<ProjectSettings> getProjectSettingsControl() {
        ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl = this.g;
        if (externalSystemSettingsControl == null) {
            AbstractImportFromExternalSystemControl.a(7);
        }
        return externalSystemSettingsControl;
    }

    @Nullable
    public ExternalSystemSettingsControl<SystemSettings> getSystemSettingsControl() {
        return this.i;
    }

    public void setLinkedProjectPath(@NotNull String string) {
        if (string == null) {
            AbstractImportFromExternalSystemControl.a(8);
        }
        this.d.setExternalProjectPath(string);
        this.c.setPath(string);
    }

    @NotNull
    public SystemSettings getSystemSettings() {
        SystemSettings SystemSettings = this.e;
        if (SystemSettings == null) {
            AbstractImportFromExternalSystemControl.a(9);
        }
        return SystemSettings;
    }

    @NotNull
    public ProjectSettings getProjectSettings() {
        ProjectSettings ProjectSettings = this.d;
        if (ProjectSettings == null) {
            AbstractImportFromExternalSystemControl.a(10);
        }
        return ProjectSettings;
    }

    public void setShowProjectFormatPanel(boolean bl2) {
        this.f = bl2;
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(@Nullable WizardContext wizardContext) {
        this.c.setNameComponentVisible(false);
        this.c.setNameValue("untitled");
        this.c.setPath("");
        this.g.reset(wizardContext);
        if (this.i != null) {
            this.i.reset(wizardContext);
        }
        if (this.j != null) {
            this.j.setOn(false);
        }
        this.b.setVisible(this.f);
        this.k.setVisible(this.f);
        this.k.getPanel().setVisible(this.f);
        this.k.getStorageFormatComboBox().setVisible(this.f);
    }

    public void apply() {
        String string = this.c.getPath();
        this.d.setExternalProjectPath(ExternalSystemApiUtil.normalizePath((String)string));
        this.g.apply(this.d);
        if (this.i != null) {
            this.i.apply(this.e);
        }
    }

    @Nullable
    public ProjectFormatPanel getProjectFormatPanel() {
        return this.f ? this.k : null;
    }

    public boolean validate(WizardContext wizardContext, boolean bl2) throws ConfigurationException {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        if (!this.g.validate(this.d)) {
            return false;
        }
        if (this.i != null && !this.i.validate(this.e)) {
            return false;
        }
        String string = this.c.getPath();
        if (StringUtil.isEmpty((String)string)) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        if (this.myCurrentProject != null) {
            ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.a);
            assert (externalSystemManager != null);
            AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.myCurrentProject);
            if (abstractExternalSystemSettings.getLinkedProjectSettings(string) != null) {
                throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
            }
        }
        return !wizardContext.isCreatingNewProject() || this.c.validateNameAndPath(wizardContext, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemSettings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettingsControl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLinkedProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

