/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.AbstractBuildEvent;
import com.intellij.build.events.impl.FailureImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.service.ImportCanceledException;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemUtil {
    private static final Logger a = Logger.getInstance(ExternalSystemUtil.class);
    @NotNull
    private static final Map<String, String> b = ContainerUtilRt.newHashMap();
    public static final TObjectHashingStrategy<Pair<ProjectSystemId, File>> HASHING_STRATEGY = new TObjectHashingStrategy<Pair<ProjectSystemId, File>>(){

        public int computeHashCode(Pair<ProjectSystemId, File> pair2) {
            return ((ProjectSystemId)pair2.first).hashCode() + ExternalSystemUtil.fileHashCode((File)pair2.second);
        }

        public boolean equals(Pair<ProjectSystemId, File> pair2, Pair<ProjectSystemId, File> pair3) {
            return ((ProjectSystemId)pair2.first).equals(pair3.first) && ExternalSystemUtil.filesEqual((File)pair2.second, (File)pair3.second);
        }
    };

    private ExternalSystemUtil() {
    }

    public static int fileHashCode(@Nullable File file) {
        int n2;
        try {
            n2 = FileUtil.pathHashCode((String)(file == null ? null : file.getCanonicalPath()));
        }
        catch (IOException iOException) {
            a.warn("unable to get canonical file path", (Throwable)iOException);
            n2 = FileUtil.fileHashCode((File)file);
        }
        return n2;
    }

    public static boolean filesEqual(@Nullable File file, @Nullable File file2) {
        try {
            return FileUtil.pathsEqual((String)(file == null ? null : file.getCanonicalPath()), (String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException iOException) {
            a.warn("unable to get canonical file path", (Throwable)iOException);
            return FileUtil.filesEqual((File)file, (File)file2);
        }
    }

    public static void ensureToolWindowInitialized(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalSystemUtil.a(0);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(1);
        }
        try {
            ToolWindowEP[] toolWindowEPArray;
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
            if (!(toolWindowManager instanceof ToolWindowManagerEx)) {
                return;
            }
            ToolWindowManagerEx toolWindowManagerEx = (ToolWindowManagerEx)toolWindowManager;
            String string = projectSystemId.getReadableName();
            ToolWindow toolWindow = toolWindowManager.getToolWindow(string);
            if (toolWindow != null) {
                return;
            }
            for (ToolWindowEP toolWindowEP : toolWindowEPArray = (ToolWindowEP[])Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME)) {
                if (!string.equals(toolWindowEP.id)) continue;
                toolWindowManagerEx.initToolWindow(toolWindowEP);
            }
        }
        catch (Exception exception) {
            a.error(String.format("Unable to initialize %s tool window", projectSystemId.getReadableName()), (Throwable)exception);
        }
    }

    @Nullable
    public static ToolWindow ensureToolWindowContentInitialized(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        ToolWindowManager toolWindowManager;
        if (project2 == null) {
            ExternalSystemUtil.a(2);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(3);
        }
        if ((toolWindowManager = ToolWindowManager.getInstance((Project)project2)) == null) {
            return null;
        }
        ToolWindow toolWindow = toolWindowManager.getToolWindow(projectSystemId.getReadableName());
        if (toolWindow == null) {
            return null;
        }
        if (toolWindow instanceof ToolWindowImpl) {
            ((ToolWindowImpl)toolWindow).ensureContentInitialized();
        }
        return toolWindow;
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, boolean bl2) {
        if (project2 == null) {
            ExternalSystemUtil.a(4);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(5);
        }
        ExternalSystemUtil.refreshProjects(project2, projectSystemId, bl2, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, boolean bl2, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.a(6);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(7);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(8);
        }
        ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, projectSystemId).forceWhenUptodate(bl2).use(progressExecutionMode));
    }

    public static void refreshProjects(@NotNull ImportSpecBuilder importSpecBuilder) {
        if (importSpecBuilder == null) {
            ExternalSystemUtil.a(9);
        }
        ExternalSystemUtil.refreshProjects(importSpecBuilder.build());
    }

    public static void refreshProjects(@NotNull ImportSpec importSpec) {
        ExternalSystemManager externalSystemManager;
        if (importSpec == null) {
            ExternalSystemUtil.a(10);
        }
        if ((externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)importSpec.getExternalSystemId())) == null) {
            return;
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)importSpec.getProject());
        Collection collection = abstractExternalSystemSettings.getLinkedProjectsSettings();
        if (collection.isEmpty()) {
            return;
        }
        ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        ExternalProjectRefreshCallback externalProjectRefreshCallback = importSpec.getCallback() == null ? new MyMultiExternalProjectRefreshCallback(importSpec.getProject(), projectDataManager) : importSpec.getCallback();
        HashSet hashSet = ContainerUtilRt.newHashSet();
        for (Object object : collection) {
            if (!object.isUseAutoImport() && importSpec.whenAutoImportEnabled()) continue;
            hashSet.add(object.getExternalProjectPath());
        }
        if (!hashSet.isEmpty()) {
            ExternalSystemNotificationManager.getInstance(importSpec.getProject()).clearNotifications(null, NotificationSource.PROJECT_SYNC, importSpec.getExternalSystemId());
            for (Object object : hashSet) {
                ExternalSystemUtil.refreshProject((String)object, new ImportSpecBuilder(importSpec).callback(externalProjectRefreshCallback).build());
            }
        }
    }

    @Nullable
    private static String a(@NotNull Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            ExternalSystemUtil.a(11);
        }
        if ((throwable2 = RemoteUtil.unwrap((Throwable)throwable)) instanceof ExternalSystemException) {
            return ((ExternalSystemException)throwable2).getOriginalReason();
        }
        return null;
    }

    public static void refreshProject(final @NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String string, boolean bl2, final @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.a(12);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(13);
        }
        if (string == null) {
            ExternalSystemUtil.a(14);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(15);
        }
        ExternalSystemUtil.refreshProject(project2, projectSystemId, string, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> dataNode) {
                if (dataNode == null) {
                    return;
                }
                boolean bl2 = progressExecutionMode == ProgressExecutionMode.MODAL_SYNC;
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(dataNode, project2, bl2);
            }

            public void onFailure(@NotNull String string, @Nullable String string2) {
                if (string == null) {
                    2.a(0);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$2", "onFailure"));
            }
        }, bl2, progressExecutionMode, true);
    }

    public static void refreshProject(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String string, @NotNull ExternalProjectRefreshCallback externalProjectRefreshCallback, boolean bl2, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.a(16);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(17);
        }
        if (string == null) {
            ExternalSystemUtil.a(18);
        }
        if (externalProjectRefreshCallback == null) {
            ExternalSystemUtil.a(19);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(20);
        }
        ExternalSystemUtil.refreshProject(project2, projectSystemId, string, externalProjectRefreshCallback, bl2, progressExecutionMode, true);
    }

    public static void refreshProject(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String string, @NotNull ExternalProjectRefreshCallback externalProjectRefreshCallback, boolean bl2, @NotNull ProgressExecutionMode progressExecutionMode, boolean bl3) {
        if (project2 == null) {
            ExternalSystemUtil.a(21);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(22);
        }
        if (string == null) {
            ExternalSystemUtil.a(23);
        }
        if (externalProjectRefreshCallback == null) {
            ExternalSystemUtil.a(24);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(25);
        }
        ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project2, projectSystemId).callback(externalProjectRefreshCallback).use(progressExecutionMode);
        if (bl2) {
            importSpecBuilder.usePreviewMode();
        }
        if (!bl3) {
            importSpecBuilder.dontReportRefreshErrors();
        }
        ExternalSystemUtil.refreshProject(string, importSpecBuilder.build());
    }

    public static void refreshProject(final @NotNull String string, final @NotNull ImportSpec importSpec) {
        if (string == null) {
            ExternalSystemUtil.a(26);
        }
        if (importSpec == null) {
            ExternalSystemUtil.a(27);
        }
        final Project project2 = importSpec.getProject();
        final ProjectSystemId projectSystemId = importSpec.getExternalSystemId();
        final ExternalProjectRefreshCallback externalProjectRefreshCallback = importSpec.getCallback();
        final boolean bl2 = importSpec.isPreviewMode();
        ProgressExecutionMode progressExecutionMode = importSpec.getProgressExecutionMode();
        final boolean bl3 = importSpec.isReportRefreshError();
        String string2 = importSpec.getArguments();
        String string3 = importSpec.getVmOptions();
        File file = new File(string);
        final String string4 = file.isFile() ? file.getParentFile().getName() : file.getName();
        AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)projectSystemId);
        AbstractExternalSystemLocalSettings.SyncType syncType = bl2 ? AbstractExternalSystemLocalSettings.SyncType.PREVIEW : (abstractExternalSystemLocalSettings.getProjectSyncType().get(string) == AbstractExternalSystemLocalSettings.SyncType.PREVIEW ? AbstractExternalSystemLocalSettings.SyncType.IMPORT : AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT);
        abstractExternalSystemLocalSettings.getProjectSyncType().put(string, syncType);
        final ExternalSystemResolveProjectTask externalSystemResolveProjectTask = new ExternalSystemResolveProjectTask(projectSystemId, project2, string, string3, string2, bl2);
        final TaskUnderProgress taskUnderProgress = new TaskUnderProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(@NotNull ProgressIndicator progressIndicator) {
                ExternalSystemProcessingManager externalSystemProcessingManager;
                if (progressIndicator == null) {
                    3.a(0);
                }
                if (project2.isDisposed()) {
                    return;
                }
                if (progressIndicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)progressIndicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                        public void cancel() {
                            super.cancel();
                            this.a();
                        }
                    });
                }
                if ((externalSystemProcessingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, projectSystemId, string) != null) {
                    if (externalProjectRefreshCallback != null) {
                        externalProjectRefreshCallback.onFailure(ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{string}), null);
                    }
                    return;
                }
                if (!(externalProjectRefreshCallback instanceof MyMultiExternalProjectRefreshCallback)) {
                    ExternalSystemNotificationManager.getInstance(project2).clearNotifications(null, NotificationSource.PROJECT_SYNC, projectSystemId);
                }
                ExternalSystemTaskActivator externalSystemTaskActivator = ExternalProjectsManagerImpl.getInstance(project2).getTaskActivator();
                if (!bl2 && !externalSystemTaskActivator.runTasks(string, ExternalSystemTaskActivator.Phase.BEFORE_SYNC)) {
                    return;
                }
                final ExternalSystemProcessHandler externalSystemProcessHandler = new ExternalSystemProcessHandler(externalSystemResolveProjectTask, string4 + " import"){

                    @Override
                    protected void destroyProcessImpl() {
                        this.a();
                        this.closeInput();
                    }
                };
                ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> externalSystemExecutionConsoleManager = ExternalSystemUtil.getConsoleManagerFor(externalSystemResolveProjectTask);
                final ExecutionConsole executionConsole = externalSystemExecutionConsoleManager.attachExecutionConsole(project2, (ExternalSystemTask)externalSystemResolveProjectTask, null, (ProcessHandler)externalSystemProcessHandler);
                if (executionConsole != null) {
                    Disposer.register((Disposable)project2, (Disposable)executionConsole);
                } else {
                    Disposer.register((Disposable)project2, (Disposable)externalSystemProcessHandler);
                }
                ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){

                    public void onStart(@NotNull ExternalSystemTaskId externalSystemTaskId, String string) {
                        if (externalSystemTaskId == null) {
                            3.a(0);
                        }
                        long l2 = System.currentTimeMillis();
                        AnAction anAction = new AnAction(){

                            public void update(@NotNull AnActionEvent anActionEvent) {
                                if (anActionEvent == null) {
                                    1.a(0);
                                }
                                super.update(anActionEvent);
                                Presentation presentation = anActionEvent.getPresentation();
                                presentation.setEnabled(externalSystemProcessHandler.isProcessTerminated());
                            }

                            public void actionPerformed(AnActionEvent anActionEvent) {
                                ExternalSystemUtil.refreshProject(string, importSpec);
                            }

                            private static /* synthetic */ void a(int n2) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3$3$1", "update"));
                            }
                        };
                        String string2 = externalSystemTaskId.getProjectSystemId().getReadableName();
                        anAction.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.text", (Object[])new Object[]{string2}));
                        anAction.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.description", (Object[])new Object[]{string2}));
                        anAction.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
                        String string3 = bl2 ? "creating of the project preview..." : "syncing...";
                        ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent(new StartBuildEventImpl(new DefaultBuildDescriptor(externalSystemTaskId, string4, string, l2), string3).withProcessHandler(externalSystemProcessHandler, null).withRestartAction(anAction).withContentDescriptorSupplier(() -> {
                            if (executionConsole == null) {
                                return null;
                            }
                            boolean bl3 = project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE || project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
                            BuildContentDescriptor buildContentDescriptor = new BuildContentDescriptor(executionConsole, externalSystemProcessHandler, executionConsole.getComponent(), "Sync");
                            buildContentDescriptor.setActivateToolWindowWhenAdded(bl3);
                            buildContentDescriptor.setActivateToolWindowWhenFailed(bl3);
                            buildContentDescriptor.setAutoFocusContent(bl3);
                            return buildContentDescriptor;
                        }));
                    }

                    public void onTaskOutput(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String string, boolean bl2) {
                        if (externalSystemTaskId == null) {
                            3.a(1);
                        }
                        if (string == null) {
                            3.a(2);
                        }
                        externalSystemProcessHandler.notifyTextAvailable(string, bl2 ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                    }

                    public void onFailure(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull Exception exception) {
                        if (externalSystemTaskId == null) {
                            3.a(3);
                        }
                        if (exception == null) {
                            3.a(4);
                        }
                        String string = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{projectSystemId.getReadableName(), string4});
                        com.intellij.build.events.FailureResult failureResult = ExternalSystemUtil.createFailureResult(string, exception, projectSystemId, project2);
                        String string2 = bl2 ? "project preview creation failed" : "sync failed";
                        ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent(new FinishBuildEventImpl(externalSystemTaskId, null, System.currentTimeMillis(), string2, failureResult));
                        ExternalSystemUtil.printFailure(exception, failureResult, executionConsole, externalSystemProcessHandler);
                        externalSystemProcessHandler.notifyProcessTerminated(1);
                    }

                    public void onSuccess(@NotNull ExternalSystemTaskId externalSystemTaskId) {
                        if (externalSystemTaskId == null) {
                            3.a(5);
                        }
                        String string = bl2 ? "project preview created" : "synced successfully";
                        ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent(new FinishBuildEventImpl(externalSystemTaskId, null, System.currentTimeMillis(), string, new SuccessResultImpl()));
                        externalSystemProcessHandler.notifyProcessTerminated(0);
                    }

                    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent) {
                        if (externalSystemTaskNotificationEvent == null) {
                            3.a(6);
                        }
                        if (externalSystemTaskNotificationEvent instanceof ExternalSystemTaskExecutionEvent) {
                            BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)externalSystemTaskNotificationEvent);
                            ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent(buildEvent);
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "id";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3$3";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStart";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTaskOutput";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onFailure";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccess";
                                break;
                            }
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStatusChange";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                externalSystemResolveProjectTask.execute(progressIndicator, (ExternalSystemTaskNotificationListener[])ArrayUtil.prepend((Object)externalSystemTaskNotificationListenerAdapter, (Object[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions()));
                if (project2.isDisposed()) {
                    return;
                }
                try {
                    Throwable throwable = externalSystemResolveProjectTask.getError();
                    if (throwable == null) {
                        ExternalProjectInfo externalProjectInfo;
                        if (externalProjectRefreshCallback != null && (externalProjectInfo = ProjectDataManagerImpl.getInstance().getExternalProjectData(project2, projectSystemId, string)) != null) {
                            DataNode dataNode = externalProjectInfo.getExternalProjectStructure();
                            if (dataNode != null && importSpec.shouldCreateDirectoriesForEmptyContentRoots()) {
                                dataNode.putUserData(ContentRootDataService.CREATE_EMPTY_DIRECTORIES, (Object)Boolean.TRUE);
                            }
                            externalProjectRefreshCallback.onSuccess(dataNode);
                        }
                        if (!bl2) {
                            externalSystemTaskActivator.runTasks(string, ExternalSystemTaskActivator.Phase.AFTER_SYNC);
                        }
                        return;
                    }
                    if (throwable instanceof ImportCanceledException) {
                        return;
                    }
                    String string2 = ExternalSystemApiUtil.buildErrorMessage((Throwable)throwable);
                    if (StringUtil.isEmpty((String)string2)) {
                        string2 = String.format("Can't resolve %s project at '%s'. Reason: %s", projectSystemId.getReadableName(), string, string2);
                    }
                    if (externalProjectRefreshCallback != null) {
                        externalProjectRefreshCallback.onFailure(string2, ExternalSystemUtil.a(throwable));
                    }
                }
                finally {
                    if (!bl2) {
                        project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                        project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                    }
                }
            }

            private void a() {
                externalSystemResolveProjectTask.cancel((ExternalSystemTaskNotificationListener[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions());
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3", "execute"));
            }
        };
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: 
            case NO_PROGRESS_ASYNC: {
                throw new ExternalSystemException("Please, use progress for the project import!");
            }
            case MODAL_SYNC: {
                String string5 = ExternalSystemBundle.message((String)"progress.import.text", (Object[])new Object[]{string4, projectSystemId.getReadableName()});
                new Task.Modal(project2, string5, true){

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            4.a(0);
                        }
                        taskUnderProgress.execute(progressIndicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$4", "run"));
                    }
                }.queue();
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                String string6 = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{string4, projectSystemId.getReadableName()});
                new Task.Backgroundable(project2, string6){

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            5.a(0);
                        }
                        taskUnderProgress.execute(progressIndicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5", "run"));
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                String string7 = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{string4, projectSystemId.getReadableName()});
                new Task.Backgroundable(project2, string7, true, PerformInBackgroundOption.DEAF){

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            6.a(0);
                        }
                        taskUnderProgress.execute(progressIndicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6", "run"));
                    }
                }.queue();
            }
        }
    }

    public static void printFailure(@NotNull Exception exception, com.intellij.build.events.FailureResult failureResult, ExecutionConsole executionConsole, ExternalSystemProcessHandler externalSystemProcessHandler) {
        if (exception == null) {
            ExternalSystemUtil.a(28);
        }
        if (executionConsole instanceof ConsoleView) {
            for (com.intellij.build.events.Failure failure : failureResult.getFailures()) {
                BuildConsoleUtils.printDetails((ConsoleView)executionConsole, failure);
            }
        } else {
            String string = ExceptionUtil.getMessage((Throwable)exception);
            String string2 = string == null ? exception.toString() : string;
            externalSystemProcessHandler.notifyTextAvailable(string2 + '\n', ProcessOutputTypes.STDERR);
        }
    }

    @NotNull
    public static com.intellij.build.events.FailureResult createFailureResult(@NotNull String string, @NotNull Exception exception, @NotNull ProjectSystemId projectSystemId, @NotNull Project project2) {
        if (string == null) {
            ExternalSystemUtil.a(29);
        }
        if (exception == null) {
            ExternalSystemUtil.a(30);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(31);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(32);
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = ExternalSystemNotificationManager.getInstance(project2);
        NotificationData notificationData = externalSystemNotificationManager.createNotification(string, exception, projectSystemId, project2);
        FailureResultImpl failureResultImpl = ExternalSystemUtil.a(exception, projectSystemId, project2, externalSystemNotificationManager, notificationData);
        if (failureResultImpl == null) {
            ExternalSystemUtil.a(33);
        }
        return failureResultImpl;
    }

    @NotNull
    public static FailureResultImpl createFailureResult(@NotNull Exception exception, @NotNull String string, @NotNull ProjectSystemId projectSystemId, @NotNull Project project2) {
        if (exception == null) {
            ExternalSystemUtil.a(34);
        }
        if (string == null) {
            ExternalSystemUtil.a(35);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(36);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(37);
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = ExternalSystemNotificationManager.getInstance(project2);
        NotificationData notificationData = externalSystemNotificationManager.createNotification(exception, string, projectSystemId, project2);
        FailureResultImpl failureResultImpl = ExternalSystemUtil.a(exception, projectSystemId, project2, externalSystemNotificationManager, notificationData);
        if (failureResultImpl == null) {
            ExternalSystemUtil.a(38);
        }
        return failureResultImpl;
    }

    @NotNull
    private static FailureResultImpl a(@NotNull Exception exception, @NotNull ProjectSystemId projectSystemId, @NotNull Project project2, @NotNull ExternalSystemNotificationManager externalSystemNotificationManager, @NotNull NotificationData notificationData) {
        VirtualFile virtualFile;
        Object object;
        if (exception == null) {
            ExternalSystemUtil.a(39);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(40);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(41);
        }
        if (externalSystemNotificationManager == null) {
            ExternalSystemUtil.a(42);
        }
        if (notificationData == null) {
            ExternalSystemUtil.a(43);
        }
        if (notificationData.isBalloonNotification()) {
            externalSystemNotificationManager.showNotification(projectSystemId, notificationData);
            FailureResultImpl failureResultImpl = new FailureResultImpl(exception);
            if (failureResultImpl == null) {
                ExternalSystemUtil.a(44);
            }
            return failureResultImpl;
        }
        Object object2 = notificationData.getBalloonGroup() == null ? ((object = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(projectSystemId)) instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)object).getNotificationGroup() : null) : ((object = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup())) != null ? object : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup()));
        int n2 = notificationData.getLine() - 1;
        int n3 = notificationData.getColumn() - 1;
        VirtualFile virtualFile2 = virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        Object object3 = notificationData.getNavigatable() == null || notificationData.getNavigatable() instanceof NonNavigatable ? (virtualFile != null ? new OpenFileDescriptor(project2, virtualFile, n2, n3) : NonNavigatable.INSTANCE) : notificationData.getNavigatable();
        Notification notification = object2 == null ? new Notification(projectSystemId.getReadableName() + " build", notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener()) : object2.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
        FailureResultImpl failureResultImpl = new FailureResultImpl(ContainerUtil.list((Object[])new com.intellij.build.events.Failure[]{new FailureImpl(notificationData.getMessage(), exception, notification, (Navigatable)object3)}));
        if (failureResultImpl == null) {
            ExternalSystemUtil.a(45);
        }
        return failureResultImpl;
    }

    public static BuildEvent convert(ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent) {
        Object object;
        AbstractBuildEvent abstractBuildEvent;
        ExternalSystemProgressEvent externalSystemProgressEvent = externalSystemTaskExecutionEvent.getProgressEvent();
        String string = externalSystemProgressEvent.getDescriptor().getDisplayName();
        long l2 = externalSystemProgressEvent.getDescriptor().getEventTime();
        Object object2 = ObjectUtils.chooseNotNull((Object)externalSystemProgressEvent.getParentEventId(), (Object)externalSystemTaskExecutionEvent.getId());
        if (externalSystemProgressEvent instanceof ExternalSystemStartEvent) {
            abstractBuildEvent = new StartEventImpl(externalSystemProgressEvent.getEventId(), object2, l2, string);
        } else if (externalSystemProgressEvent instanceof ExternalSystemFinishEvent) {
            OperationResult operationResult = ((ExternalSystemFinishEvent)externalSystemProgressEvent).getOperationResult();
            if (operationResult instanceof FailureResult) {
                SmartList smartList = new SmartList();
                for (Failure failure : ((FailureResult)operationResult).getFailures()) {
                    smartList.add(ExternalSystemUtil.a(failure));
                }
                object = new FailureResultImpl((List<com.intellij.build.events.Failure>)smartList);
            } else {
                object = operationResult instanceof SkippedResult ? new SkippedResultImpl() : (operationResult instanceof SuccessResult ? new SuccessResultImpl(((SuccessResult)operationResult).isUpToDate()) : new SuccessResultImpl());
            }
            abstractBuildEvent = new FinishEventImpl(externalSystemProgressEvent.getEventId(), object2, l2, string, (EventResult)object);
        } else if (externalSystemProgressEvent instanceof ExternalSystemStatusEvent) {
            object = (ExternalSystemStatusEvent)externalSystemProgressEvent;
            abstractBuildEvent = new ProgressBuildEventImpl(externalSystemProgressEvent.getEventId(), object2, l2, string, object.getTotal(), object.getProgress(), object.getUnit());
        } else {
            abstractBuildEvent = new OutputBuildEventImpl((Object)externalSystemProgressEvent.getEventId(), object2, string, true);
        }
        object = externalSystemProgressEvent.getDescriptor().getHint();
        abstractBuildEvent.setHint((String)object);
        return abstractBuildEvent;
    }

    private static com.intellij.build.events.Failure a(Failure failure) {
        SmartList smartList = new SmartList();
        for (Failure failure2 : failure.getCauses()) {
            smartList.add(ExternalSystemUtil.a(failure2));
        }
        return new FailureImpl(failure.getMessage(), failure.getDescription(), (List<? extends com.intellij.build.events.Failure>)smartList);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, @NotNull String string, @NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemUtil.a(46);
        }
        if (string == null) {
            ExternalSystemUtil.a(47);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(48);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(49);
        }
        ExternalSystemUtil.runTask(externalSystemTaskExecutionSettings, string, project2, projectSystemId, null, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, @NotNull String string, @NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @Nullable TaskCallback taskCallback, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemUtil.a(50);
        }
        if (string == null) {
            ExternalSystemUtil.a(51);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(52);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(53);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(54);
        }
        ExternalSystemUtil.runTask(externalSystemTaskExecutionSettings, string, project2, projectSystemId, taskCallback, progressExecutionMode, true);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, @NotNull String string, @NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @Nullable TaskCallback taskCallback, @NotNull ProgressExecutionMode progressExecutionMode, boolean bl2) {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemUtil.a(55);
        }
        if (string == null) {
            ExternalSystemUtil.a(56);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(57);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(58);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(59);
        }
        ExternalSystemUtil.runTask(externalSystemTaskExecutionSettings, string, project2, projectSystemId, taskCallback, progressExecutionMode, bl2, null);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, final @NotNull String string, final @NotNull Project project2, @NotNull ProjectSystemId projectSystemId, final @Nullable TaskCallback taskCallback, @NotNull ProgressExecutionMode progressExecutionMode, boolean bl2, @Nullable UserDataHolderBase userDataHolderBase) {
        Object object;
        ExecutionEnvironment executionEnvironment;
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemUtil.a(60);
        }
        if (string == null) {
            ExternalSystemUtil.a(61);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(62);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(63);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(64);
        }
        if ((executionEnvironment = ExternalSystemUtil.createExecutionEnvironment(project2, projectSystemId, externalSystemTaskExecutionSettings, string)) == null) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = executionEnvironment.getRunnerAndConfigurationSettings();
        assert (runnerAndConfigurationSettings != null);
        runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(bl2);
        if (userDataHolderBase != null) {
            object = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            userDataHolderBase.copyUserDataTo((UserDataHolderBase)object);
        }
        object = new TaskUnderProgress(){

            @Override
            public void execute(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    7.a(0);
                }
                progressIndicator.setIndeterminate(true);
                final Semaphore semaphore = new Semaphore();
                final Ref ref = new Ref((Object)false);
                Disposable disposable = Disposer.newDisposable();
                project2.getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                    public void processStartScheduled(@NotNull String string, @NotNull ExecutionEnvironment executionEnvironment) {
                        if (string == null) {
                            1.a(0);
                        }
                        if (executionEnvironment == null) {
                            1.a(1);
                        }
                        if (string.equals(string) && executionEnvironment.equals(executionEnvironment)) {
                            semaphore.down();
                        }
                    }

                    public void processNotStarted(@NotNull String string, @NotNull ExecutionEnvironment executionEnvironment) {
                        if (string == null) {
                            1.a(2);
                        }
                        if (executionEnvironment == null) {
                            1.a(3);
                        }
                        if (string.equals(string) && executionEnvironment.equals(executionEnvironment)) {
                            semaphore.up();
                        }
                    }

                    public void processStarted(@NotNull String string, @NotNull ExecutionEnvironment executionEnvironment, @NotNull ProcessHandler processHandler) {
                        if (string == null) {
                            1.a(4);
                        }
                        if (executionEnvironment == null) {
                            1.a(5);
                        }
                        if (processHandler == null) {
                            1.a(6);
                        }
                        if (string.equals(string) && executionEnvironment.equals(executionEnvironment)) {
                            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                                public void processTerminated(@NotNull ProcessEvent processEvent) {
                                    if (processEvent == null) {
                                        1.a(0);
                                    }
                                    ref.set((Object)(processEvent.getExitCode() == 0 ? 1 : 0));
                                    semaphore.up();
                                }

                                private static /* synthetic */ void a(int n2) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7$1$1", "processTerminated"));
                                }
                            });
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "executorIdLocal";
                                break;
                            }
                            case 1: 
                            case 3: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "environmentLocal";
                                break;
                            }
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "handler";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStartScheduled";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processNotStarted";
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStarted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        try {
                            executionEnvironment.getRunner().execute(executionEnvironment);
                        }
                        catch (ExecutionException executionException) {
                            semaphore.up();
                            a.error((Throwable)executionException);
                        }
                    }, ModalityState.defaultModalityState());
                }
                catch (Exception exception) {
                    a.error((Throwable)exception);
                    Disposer.dispose((Disposable)disposable);
                    return;
                }
                semaphore.waitFor();
                Disposer.dispose((Disposable)disposable);
                if (taskCallback != null) {
                    if (((Boolean)ref.get()).booleanValue()) {
                        taskCallback.onSuccess();
                    } else {
                        taskCallback.onFailure();
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7", "execute"));
            }
        };
        String string2 = AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemTaskExecutionSettings);
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: {
                object.execute((ProgressIndicator)new EmptyProgressIndicator());
                break;
            }
            case MODAL_SYNC: {
                new Task.Modal(project2, string2, true, (TaskUnderProgress)object){
                    final /* synthetic */ TaskUnderProgress val$task;
                    {
                        this.val$task = taskUnderProgress;
                        super(project2, string, bl2);
                    }

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            8.a(0);
                        }
                        this.val$task.execute(progressIndicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$8", "run"));
                    }
                }.queue();
                break;
            }
            case NO_PROGRESS_ASYNC: {
                ApplicationManager.getApplication().executeOnPooledThread(() -> ExternalSystemUtil.a((TaskUnderProgress)object));
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                new Task.Backgroundable(project2, string2, (TaskUnderProgress)object){
                    final /* synthetic */ TaskUnderProgress val$task;
                    {
                        this.val$task = taskUnderProgress;
                        super(project2, string);
                    }

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            9.a(0);
                        }
                        this.val$task.execute(progressIndicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$9", "run"));
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                new Task.Backgroundable(project2, string2, true, PerformInBackgroundOption.DEAF, (TaskUnderProgress)object){
                    final /* synthetic */ TaskUnderProgress val$task;
                    {
                        this.val$task = taskUnderProgress;
                        super(project2, string, bl2, performInBackgroundOption);
                    }

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            10.a(0);
                        }
                        this.val$task.execute(progressIndicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$10", "run"));
                    }
                }.queue();
            }
        }
    }

    @Nullable
    public static ExecutionEnvironment createExecutionEnvironment(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, @NotNull String string) {
        Executor executor;
        if (project2 == null) {
            ExternalSystemUtil.a(65);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(66);
        }
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemUtil.a(67);
        }
        if (string == null) {
            ExternalSystemUtil.a(68);
        }
        if ((executor = ExecutorRegistry.getInstance().getExecutorById(string)) == null) {
            return null;
        }
        String string2 = ExternalSystemUtil.getRunnerId(string);
        if (string2 == null) {
            return null;
        }
        ProgramRunner programRunner = RunnerRegistry.getInstance().findRunnerById(string2);
        if (programRunner == null) {
            return null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings(externalSystemTaskExecutionSettings, project2, projectSystemId);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        return new ExecutionEnvironment(executor, programRunner, runnerAndConfigurationSettings, project2);
    }

    @Nullable
    public static Pair<ProgramRunner, ExecutionEnvironment> createRunner(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, @NotNull String string, @NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        ExecutionEnvironment executionEnvironment;
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemUtil.a(69);
        }
        if (string == null) {
            ExternalSystemUtil.a(70);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(71);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(72);
        }
        return (executionEnvironment = ExternalSystemUtil.createExecutionEnvironment(project2, projectSystemId, externalSystemTaskExecutionSettings, string)) == null ? null : Pair.create((Object)executionEnvironment.getRunner(), (Object)executionEnvironment);
    }

    @Nullable
    public static RunnerAndConfigurationSettings createExternalSystemRunnerAndConfigurationSettings(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings, @NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType;
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemUtil.a(73);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(74);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(75);
        }
        if ((abstractExternalSystemTaskConfigurationType = ExternalSystemUtil.findConfigurationType(projectSystemId)) == null) {
            return null;
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemTaskExecutionSettings);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project2).createRunConfiguration(string, abstractExternalSystemTaskConfigurationType.getFactory());
        ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
        externalSystemRunConfiguration.getSettings().setExternalProjectPath(externalSystemTaskExecutionSettings.getExternalProjectPath());
        externalSystemRunConfiguration.getSettings().setTaskNames((List)ContainerUtil.newArrayList((Iterable)externalSystemTaskExecutionSettings.getTaskNames()));
        externalSystemRunConfiguration.getSettings().setTaskDescriptions((List)ContainerUtil.newArrayList((Iterable)externalSystemTaskExecutionSettings.getTaskDescriptions()));
        externalSystemRunConfiguration.getSettings().setVmOptions(externalSystemTaskExecutionSettings.getVmOptions());
        externalSystemRunConfiguration.getSettings().setScriptParameters(externalSystemTaskExecutionSettings.getScriptParameters());
        externalSystemRunConfiguration.getSettings().setPassParentEnvs(externalSystemTaskExecutionSettings.isPassParentEnvs());
        externalSystemRunConfiguration.getSettings().setEnv((Map)ContainerUtil.newHashMap((Map)externalSystemTaskExecutionSettings.getEnv()));
        externalSystemRunConfiguration.getSettings().setExecutionName(externalSystemTaskExecutionSettings.getExecutionName());
        return runnerAndConfigurationSettings;
    }

    @Nullable
    public static AbstractExternalSystemTaskConfigurationType findConfigurationType(@NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            ExternalSystemUtil.a(76);
        }
        for (ConfigurationType configurationType : (ConfigurationType[])Extensions.getExtensions((ExtensionPointName)ConfigurationType.CONFIGURATION_TYPE_EP)) {
            AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType;
            if (!(configurationType instanceof AbstractExternalSystemTaskConfigurationType) || !projectSystemId.equals((Object)(abstractExternalSystemTaskConfigurationType = (AbstractExternalSystemTaskConfigurationType)configurationType).getExternalSystemId())) continue;
            return abstractExternalSystemTaskConfigurationType;
        }
        return null;
    }

    @Nullable
    public static String getRunnerId(@NotNull String string) {
        if (string == null) {
            ExternalSystemUtil.a(77);
        }
        return b.get(string);
    }

    public static void linkExternalProject(final @NotNull ProjectSystemId projectSystemId, final @NotNull ExternalProjectSettings externalProjectSettings, final @NotNull Project project2, final @Nullable Consumer<Boolean> consumer, boolean bl2, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (projectSystemId == null) {
            ExternalSystemUtil.a(78);
        }
        if (externalProjectSettings == null) {
            ExternalSystemUtil.a(79);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(80);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(81);
        }
        ExternalProjectRefreshCallback externalProjectRefreshCallback = new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> dataNode) {
                if (dataNode == null) {
                    if (consumer != null) {
                        consumer.consume((Object)false);
                    }
                    return;
                }
                AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId);
                HashSet hashSet = ContainerUtilRt.newHashSet((Iterable)abstractExternalSystemSettings.getLinkedProjectsSettings());
                hashSet.add(externalProjectSettings);
                abstractExternalSystemSettings.setLinkedProjectsSettings((Collection)hashSet);
                ExternalSystemUtil.ensureToolWindowInitialized(project2, projectSystemId);
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(dataNode, project2, true);
                if (consumer != null) {
                    consumer.consume((Object)true);
                }
            }

            public void onFailure(@NotNull String string, @Nullable String string2) {
                if (string == null) {
                    11.a(0);
                }
                if (consumer != null) {
                    consumer.consume((Object)false);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$11", "onFailure"));
            }
        };
        ExternalSystemUtil.refreshProject(project2, projectSystemId, externalProjectSettings.getExternalProjectPath(), externalProjectRefreshCallback, bl2, progressExecutionMode);
    }

    @Nullable
    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        Application application;
        if (file == null) {
            ExternalSystemUtil.a(82);
        }
        if (!(application = ApplicationManager.getApplication()).isDispatchThread()) assert (!((ApplicationEx)application).holdsReadLock());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(String string) {
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(string);
        if (virtualFile != null) {
            return virtualFile;
        }
        return !ApplicationManager.getApplication().isReadAccessAllowed() ? ExternalSystemUtil.c(string) : ExternalSystemUtil.b(string);
    }

    @Nullable
    private static VirtualFile c(String string) {
        return (VirtualFile)ExternalSystemApiUtil.doWriteAction(() -> StandardFileSystems.local().refreshAndFindFileByPath(string));
    }

    @Nullable
    private static VirtualFile b(String string) {
        return (VirtualFile)ReadAction.compute(() -> StandardFileSystems.local().findFileByPath(string));
    }

    public static void scheduleExternalViewStructureUpdate(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        ExternalProjectsView externalProjectsView;
        if (project2 == null) {
            ExternalSystemUtil.a(83);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(84);
        }
        if ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(projectSystemId)) instanceof ExternalProjectsViewImpl) {
            ((ExternalProjectsViewImpl)externalProjectsView).scheduleStructureUpdate();
        }
    }

    @Nullable
    public static ExternalProjectInfo getExternalProjectInfo(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        ExternalProjectSettings externalProjectSettings;
        if (project2 == null) {
            ExternalSystemUtil.a(85);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(86);
        }
        if (string == null) {
            ExternalSystemUtil.a(87);
        }
        if ((externalProjectSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(string)) == null) {
            return null;
        }
        return ProjectDataManagerImpl.getInstance().getExternalProjectData(project2, projectSystemId, externalProjectSettings.getExternalProjectPath());
    }

    @NotNull
    public static ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> getConsoleManagerFor(@NotNull ExternalSystemTask externalSystemTask) {
        if (externalSystemTask == null) {
            ExternalSystemUtil.a(88);
        }
        for (ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager : (ExternalSystemExecutionConsoleManager[])ExternalSystemExecutionConsoleManager.EP_NAME.getExtensions()) {
            if (!externalSystemExecutionConsoleManager.isApplicableFor(externalSystemTask)) continue;
            ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager2 = externalSystemExecutionConsoleManager;
            if (externalSystemExecutionConsoleManager2 == null) {
                ExternalSystemUtil.a(89);
            }
            return externalSystemExecutionConsoleManager2;
        }
        DefaultExternalSystemExecutionConsoleManager defaultExternalSystemExecutionConsoleManager = new DefaultExternalSystemExecutionConsoleManager();
        if (defaultExternalSystemExecutionConsoleManager == null) {
            ExternalSystemUtil.a(90);
        }
        return defaultExternalSystemExecutionConsoleManager;
    }

    public static void invokeLater(Project project2, Runnable runnable) {
        ExternalSystemUtil.invokeLater(project2, ModalityState.defaultModalityState(), runnable);
    }

    public static void invokeLater(Project project2, ModalityState modalityState, Runnable runnable) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)runnable, (Project)project2), modalityState);
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    private static /* synthetic */ void a(TaskUnderProgress taskUnderProgress) {
        taskUnderProgress.execute((ProgressIndicator)new EmptyProgressIndicator());
    }

    static {
        b.put(DefaultRunExecutor.EXECUTOR_ID, "ExternalSystemTaskRunner");
        b.put(DefaultDebugExecutor.EXECUTOR_ID, "ExternalSystemTaskDebugRunner");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 38: 
            case 44: 
            case 45: 
            case 89: 
            case 90: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 33: 
            case 38: 
            case 44: 
            case 45: 
            case 89: 
            case 90: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 17: 
            case 22: 
            case 31: 
            case 36: 
            case 40: 
            case 49: 
            case 53: 
            case 58: 
            case 63: 
            case 66: 
            case 72: 
            case 75: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 8: 
            case 15: 
            case 20: 
            case 25: 
            case 54: 
            case 59: 
            case 64: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specBuilder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 30: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 33: 
            case 38: 
            case 44: 
            case 45: 
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 46: 
            case 50: 
            case 55: 
            case 60: 
            case 67: 
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSettings";
                break;
            }
            case 47: 
            case 51: 
            case 56: 
            case 61: 
            case 68: 
            case 70: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 33: 
            case 38: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createFailureResult";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleManagerFor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowInitialized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowContentInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshProjects";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractDetails";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "refreshProject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "printFailure";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createFailureResult";
                break;
            }
            case 33: 
            case 38: 
            case 44: 
            case 45: 
            case 89: 
            case 90: {
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionEnvironment";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createRunner";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createExternalSystemRunnerAndConfigurationSettings";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerId";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "linkExternalProject";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "scheduleExternalViewStructureUpdate";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectInfo";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleManagerFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 38: 
            case 44: 
            case 45: 
            case 89: 
            case 90: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMultiExternalProjectRefreshCallback
    implements ExternalProjectRefreshCallback {
        @NotNull
        private final Set<String> b;
        private final Project a;
        private final ProjectDataManager c;

        public MyMultiExternalProjectRefreshCallback(Project project2, ProjectDataManager projectDataManager) {
            this.a = project2;
            this.c = projectDataManager;
            this.b = ContainerUtilRt.newHashSet();
        }

        public void onSuccess(@Nullable DataNode<ProjectData> dataNode) {
            if (dataNode == null) {
                return;
            }
            Collection collection = ExternalSystemApiUtil.findAllRecursively(dataNode, (Key)ProjectKeys.MODULE);
            for (DataNode dataNode2 : collection) {
                this.b.add(((ModuleData)dataNode2.getData()).getLinkedExternalProjectPath());
            }
            this.c.importData(dataNode, this.a, true);
        }

        public void onFailure(@NotNull String string, @Nullable String string2) {
            if (string == null) {
                MyMultiExternalProjectRefreshCallback.a(0);
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$MyMultiExternalProjectRefreshCallback", "onFailure"));
        }
    }

    private static interface TaskUnderProgress {
        public void execute(@NotNull ProgressIndicator var1);
    }
}

