/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import icons.ExternalSystemIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=10)
public class TasksNode
extends ExternalSystemNode {
    private final MultiMap<String, TaskNode> h = new MultiMap();

    public TasksNode(ExternalProjectsView externalProjectsView, Collection<DataNode<?>> collection) {
        super(externalProjectsView, null, null);
        if (collection != null && !collection.isEmpty()) {
            for (DataNode<?> dataNode : collection) {
                if (!(dataNode.getData() instanceof TaskData)) continue;
                String string = ((TaskData)dataNode.getData()).getGroup();
                if (string == null) {
                    string = "other";
                }
                this.h.putValue((Object)StringUtil.toLowerCase((String)string), (Object)new TaskNode(externalProjectsView, dataNode));
            }
        }
    }

    protected void update(PresentationData presentationData) {
        super.update(presentationData);
        presentationData.setIcon(ExternalSystemIcons.TaskGroup);
    }

    public String getName() {
        return "Tasks";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasChildren();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        ArrayList arrayList = ContainerUtil.newArrayList();
        boolean bl2 = this.getExternalProjectsView().getGroupTasks();
        if (bl2) {
            for (Map.Entry entry : this.h.entrySet()) {
                final String string = (String)ObjectUtils.notNull(entry.getKey(), (Object)"other");
                ExternalSystemNode externalSystemNode = new ExternalSystemNode(this.getExternalProjectsView(), null, null){

                    protected void update(PresentationData presentationData) {
                        super.update(presentationData);
                        presentationData.setIcon(ExternalSystemIcons.TaskGroup);
                    }

                    public String getName() {
                        return string;
                    }

                    @Override
                    public boolean isVisible() {
                        return super.isVisible() && this.hasChildren();
                    }

                    @Override
                    public int compareTo(@NotNull ExternalSystemNode externalSystemNode) {
                        if (externalSystemNode == null) {
                            1.b(0);
                        }
                        return "other".equals(string) ? 1 : super.compareTo(externalSystemNode);
                    }

                    private static /* synthetic */ void b(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/view/TasksNode$1", "compareTo"));
                    }
                };
                externalSystemNode.addAll((Collection)entry.getValue());
                arrayList.add(externalSystemNode);
            }
        } else {
            arrayList.addAll(this.h.values());
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            TasksNode.b(0);
        }
        return arrayList2;
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/TasksNode", "doBuildChildren"));
    }
}

