/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.view.DefaultBackgroundRendererImpl;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import org.jetbrains.annotations.NotNull;

public class GraphBuilderFactoryImpl
extends GraphBuilderFactory {
    private final Project a;

    public GraphBuilderFactoryImpl(Project project2) {
        this.a = project2;
    }

    public <N, E> GraphBuilder createGraphBuilder(@NotNull Graph2D graph2D, @NotNull Graph2DView graph2DView, @NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel) {
        if (graph2D == null) {
            GraphBuilderFactoryImpl.a(0);
        }
        if (graph2DView == null) {
            GraphBuilderFactoryImpl.a(1);
        }
        if (graphDataModel == null) {
            GraphBuilderFactoryImpl.a(2);
        }
        if (graphPresentationModel == null) {
            GraphBuilderFactoryImpl.a(3);
        }
        final GraphBuilderImpl<N, E> graphBuilderImpl = new GraphBuilderImpl<N, E>(this.getProject(), graph2D, graph2DView, graphDataModel, graphPresentationModel);
        if (graphPresentationModel instanceof BasicGraphPresentationModel) {
            ((BasicGraphPresentationModel)graphPresentationModel).setGraphBuilder(graphBuilderImpl);
            graph2D.addGraph2DSelectionListener(new Graph2DSelectionListener(){

                public void onGraph2DSelectionEvent(Graph2DSelectionEvent graph2DSelectionEvent) {
                    if (graph2DSelectionEvent.isNodeSelection()) {
                        graphBuilderImpl.getGraphPresentationModel().onSelectionChanged(graph2DSelectionEvent);
                    }
                }
            });
        }
        ((DefaultBackgroundRendererImpl)graph2DView.getBackgroundRenderer()).setColor(JBColor.background());
        return graphBuilderImpl;
    }

    public <N, E> GraphBuilder createGraphBuilder(@NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel) {
        if (graphDataModel == null) {
            GraphBuilderFactoryImpl.a(4);
        }
        if (graphPresentationModel == null) {
            GraphBuilderFactoryImpl.a(5);
        }
        return this.createGraphBuilder(GraphManager.getGraphManager().createGraph2D(), GraphManager.getGraphManager().createGraph2DView(), graphDataModel, graphPresentationModel);
    }

    public <N, E> GraphBuilder createGraphBuilder(@NotNull GraphDataModel<N, E> graphDataModel) {
        if (graphDataModel == null) {
            GraphBuilderFactoryImpl.a(6);
        }
        Graph2D graph2D = GraphManager.getGraphManager().createGraph2D();
        return this.createGraphBuilder(graph2D, GraphManager.getGraphManager().createGraph2DView(), graphDataModel, (GraphPresentationModel<N, E>)new BasicGraphPresentationModel((Graph)graph2D));
    }

    public Project getProject() {
        return this.a;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "graph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "dataModel";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "presentationModel";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl";
        objectArray[2] = "createGraphBuilder";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

