/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraphEventManager
extends GraphBuilderEventManager {
    private final Graph2DView h;
    private final EditMode a;
    private final ViewMode c = new NavigationMode();
    private final MagnifierViewMode e = new MagnifierViewMode();
    private volatile boolean i = false;
    private volatile boolean f = false;
    private final List<GraphBuilderListener> d = new ArrayList<GraphBuilderListener>();
    private final GraphBuilder g;
    private boolean b = false;

    GraphEventManager(EditMode editMode, GraphBuilder graphBuilder) {
        this.g = graphBuilder;
        this.h = graphBuilder.getView();
        this.a = editMode;
        this.e.setMagnifierRadius(150);
        Disposer.register((Disposable)graphBuilder, (Disposable)this);
        JComponent jComponent = this.h.getCanvasComponent();
        jComponent.addMouseMotionListener((MouseMotionListener)((Object)this));
        jComponent.addKeyListener((KeyListener)((Object)this));
        jComponent.addMouseWheelListener((MouseWheelListener)((Object)this));
        jComponent.addFocusListener((FocusListener)((Object)this));
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (GraphEventManager.this.b) {
                    GraphEventManager.this.b = false;
                    GraphEventManager.this.a(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
            this.a();
        } else if (mouseEvent.isAltDown() && !mouseEvent.isControlDown()) {
            this.c();
        } else {
            if (!this.b) {
                this.b = true;
                this.a(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.b();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isAltDown() && this.f || !mouseEvent.isControlDown() && this.i) {
            this.b();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        boolean bl2 = keyEvent.isAltDown();
        boolean bl3 = keyEvent.isControlDown();
        if (bl3 && GraphEventManager.a(n2)) {
            this.b(n2);
        } else if (n2 == 17 && !bl2) {
            this.a();
        } else if (n2 == 18 && !bl3) {
            this.c();
        } else {
            this.b();
        }
    }

    private void b(int n2) {
        Graph2D graph2D = this.h.getGraph2D();
        List list2 = GraphViewUtil.getSelectedNodes((Graph2D)graph2D);
        if (list2.size() > 0) {
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node : list2) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(3 * (n2 == 37 ? -1 : (n2 == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(3 * (n2 == 38 ? -1 : (n2 == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean a(int n2) {
        return n2 == 37 || n2 == 39 || n2 == 40 || n2 == 38;
    }

    private synchronized void a() {
        if (!this.i) {
            this.h.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.a.setEditing(false);
            this.a.reactivateParent();
            this.i = true;
            this.h.removeViewMode((ViewMode)(this.f ? this.e : this.a));
            this.f = false;
            this.h.addViewMode(this.c);
        }
    }

    private synchronized void c() {
        if (!this.f) {
            this.f = true;
            double d2 = this.h.getZoom();
            d2 = d2 < 1.0 ? 1.5 / d2 : 2.0 * d2;
            this.e.setMagnifierZoomFactor(d2);
            this.h.removeViewMode((ViewMode)(this.i ? this.c : this.a));
            this.i = false;
            this.h.addViewMode((ViewMode)this.e);
        }
    }

    private synchronized void b() {
        if (this.i) {
            this.a(GraphBuilderEvent.GRAPH_MOVED, false);
            this.i = false;
            this.h.removeViewMode(this.c);
            this.h.addViewMode((ViewMode)this.a);
        } else if (this.f) {
            this.f = false;
            this.h.removeViewMode((ViewMode)this.e);
            this.h.updateView();
            this.h.addViewMode((ViewMode)this.a);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 18) {
            this.b();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        if (mouseWheelEvent.isControlDown()) {
            double d2 = this.h.getZoom() - (double)n2 * 0.1;
            Magnificator magnificator = (Magnificator)UIUtil.getParentOfType(Magnificator.class, (Component)this.h.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(d2 / this.h.getZoom(), mouseWheelEvent.getPoint());
            }
        }
    }

    public double zoomView(double d2) {
        this.a(GraphBuilderEvent.ZOOM_CHANGED, true);
        double d3 = Math.min(10.0, Math.max(d2, 0.1));
        this.h.setZoom(d3);
        this.h.updateView();
        this.a(GraphBuilderEvent.ZOOM_CHANGED, false);
        return d3;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.b();
    }

    public void subscribe(GraphBuilderListener graphBuilderListener) {
        if (!this.d.contains(graphBuilderListener)) {
            this.d.add(graphBuilderListener);
        }
    }

    public void dispose() {
        this.d.clear();
    }

    private void a(GraphBuilderEvent graphBuilderEvent, boolean bl2) {
        for (GraphBuilderListener graphBuilderListener : this.d) {
            if (bl2) {
                graphBuilderListener.beforeActionPerformed(this.g, graphBuilderEvent);
                continue;
            }
            graphBuilderListener.actionPerformed(this.g, graphBuilderEvent);
        }
    }
}

