/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectJdksConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ProjectJdksEditor
extends DialogWrapper {
    private ProjectJdksConfigurable b;
    private Sdk a;

    public ProjectJdksEditor(Sdk sdk, Project project2, Component component) {
        this(sdk, component, new ProjectJdksConfigurable(project2));
    }

    public ProjectJdksEditor(Sdk sdk, Component component, ProjectJdksConfigurable projectJdksConfigurable) {
        super(component, true);
        this.b = projectJdksConfigurable;
        SwingUtilities.invokeLater(() -> this.b.selectNodeInTree(sdk != null ? sdk.getName() : null));
        this.setTitle(ProjectBundle.message((String)"sdk.configure.title", (Object[])new Object[0]));
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (ProjectJdksEditor.this.b != null) {
                    ProjectJdksEditor.this.b.disposeUIResources();
                    ProjectJdksEditor.this.b = null;
                }
            }
        });
        this.init();
    }

    public ProjectJdksEditor(Sdk sdk, Component component) {
        this(sdk, (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), component);
    }

    protected JComponent createCenterPanel() {
        this.b.reset();
        return this.b.createComponent();
    }

    protected void doOKAction() {
        try {
            this.a = this.b.getSelectedJdk();
            this.b.apply();
            super.doOKAction();
        }
        catch (ConfigurationException configurationException) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)configurationException.getMessage(), (String)ProjectBundle.message((String)"sdk.configure.save.settings.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.projectRoots.ui.ProjectJdksEditor";
    }

    public Sdk getSelectedJdk() {
        return this.a;
    }
}

